/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.listeners;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.AxMinionsAPI;
import com.artillexstudios.axminions.api.config.Config;
import com.artillexstudios.axminions.api.config.Messages;
import com.artillexstudios.axminions.api.events.PreMinionPlaceEvent;
import com.artillexstudios.axminions.api.integrations.types.IslandIntegration;
import com.artillexstudios.axminions.api.integrations.types.ProtectionIntegrations;
import com.artillexstudios.axminions.api.minions.Direction;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.minions.miniontype.MinionTypes;
import com.artillexstudios.axminions.api.utils.Keys;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axminions.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axminions.libs.axapi.utils.StringUtils;
import com.artillexstudios.axminions.minions.Minion;
import com.artillexstudios.axminions.minions.Minions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/artillexstudios/axminions/listeners/MinionPlaceListener;", "Lorg/bukkit/event/Listener;", "()V", "onBlockPlace", "", "event", "Lorg/bukkit/event/block/BlockPlaceEvent;", "onPlayerInteractEvent", "Lorg/bukkit/event/player/PlayerInteractEvent;", "common"})
public final class MinionPlaceListener
implements Listener {
    @EventHandler
    public final void onPlayerInteractEvent(@NotNull PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK && event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        EquipmentSlot equipmentSlot = event.getHand();
        if (equipmentSlot == null) {
            return;
        }
        ItemStack itemStack = event.getPlayer().getInventory().getItem(equipmentSlot);
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        Ref.ObjectRef meta = new Ref.ObjectRef();
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        meta.element = itemMeta;
        String string = (String)((ItemMeta)meta.element).getPersistentDataContainer().get(Keys.MINION_TYPE, PersistentDataType.STRING);
        if (string == null) {
            return;
        }
        String type = string;
        MinionType minionType = MinionTypes.valueOf(type);
        if (minionType == null) {
            return;
        }
        MinionType minionType2 = minionType;
        event.setCancelled(true);
        ProtectionIntegrations protectionIntegrations = AxMinionsPlugin.Companion.getIntegrations().getProtectionIntegration();
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block);
        if (!protectionIntegrations.canBuildAt(player, block.getLocation())) {
            if (Config.Companion.DEBUG()) {
                event.getPlayer().sendMessage("Could not place due to protection hook!");
            }
            return;
        }
        Player player2 = event.getPlayer();
        Block block2 = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block2);
        PreMinionPlaceEvent prePlaceEvent = new PreMinionPlaceEvent(player2, block2.getLocation());
        Integer n = (Integer)((ItemMeta)meta.element).getPersistentDataContainer().get(Keys.LEVEL, PersistentDataType.INTEGER);
        if (n == null) {
            n = 0;
        }
        int level = n;
        Long l = (Long)((ItemMeta)meta.element).getPersistentDataContainer().get(Keys.STATISTICS, PersistentDataType.LONG);
        if (l == null) {
            l = 0L;
        }
        long stats = l;
        Long l2 = (Long)((ItemMeta)meta.element).getPersistentDataContainer().get(Keys.CHARGE, PersistentDataType.LONG);
        if (l2 == null) {
            l2 = 0L;
        }
        long charge = l2;
        if (Config.Companion.PLACE_PERMISSION() && !event.getPlayer().hasPermission("axminions.place." + minionType2.getName())) {
            event.getPlayer().sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.PLACE_MISSING_PERMISSION(), new TagResolver[0]));
            return;
        }
        if (((ItemMeta)meta.element).getPersistentDataContainer().has(Keys.PLACED, PersistentDataType.BYTE)) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)prePlaceEvent);
        if (prePlaceEvent.isCancelled()) {
            return;
        }
        ((ItemMeta)meta.element).getPersistentDataContainer().set(Keys.PLACED, PersistentDataType.BYTE, (Object)0);
        item.setItemMeta((ItemMeta)meta.element);
        Block block3 = event.getClickedBlock();
        Intrinsics.checkNotNull((Object)block3);
        Location location = block3.getRelative(event.getBlockFace()).getLocation();
        int maxMinions = AxMinionsAPI.Companion.getINSTANCE().getMinionLimit(event.getPlayer());
        Chunk chunk = location.getChunk();
        AxMinionsPlugin.Companion.getDataQueue().submit(() -> MinionPlaceListener.onPlayerInteractEvent$lambda$4(event, location, maxMinions, prePlaceEvent, minionType2, level, stats, charge, chunk, meta, item));
    }

    @EventHandler
    public final void onBlockPlace(@NotNull BlockPlaceEvent event) {
        Location blockLocation = event.getBlock().getLocation();
        if (AxMinionsPlugin.Companion.getDataHandler().isMinion(blockLocation)) {
            event.setCancelled(true);
        }
    }

    private static final void onPlayerInteractEvent$lambda$4$lambda$0(Ref.ObjectRef $meta, ItemStack $item, ScheduledTask scheduledTask) {
        ItemMeta itemMeta = $item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        $meta.element = itemMeta;
        ((ItemMeta)$meta.element).getPersistentDataContainer().remove(Keys.PLACED);
        $item.setItemMeta((ItemMeta)$meta.element);
    }

    private static final void onPlayerInteractEvent$lambda$4$lambda$1(Ref.ObjectRef $meta, ItemStack $item, ScheduledTask scheduledTask) {
        ItemMeta itemMeta = $item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        $meta.element = itemMeta;
        ((ItemMeta)$meta.element).getPersistentDataContainer().remove(Keys.PLACED);
        $item.setItemMeta((ItemMeta)$meta.element);
    }

    private static final void onPlayerInteractEvent$lambda$4$lambda$2(Ref.ObjectRef $meta, ItemStack $item, ScheduledTask scheduledTask) {
        ItemMeta itemMeta = $item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        $meta.element = itemMeta;
        ((ItemMeta)$meta.element).getPersistentDataContainer().remove(Keys.PLACED);
        $item.setItemMeta((ItemMeta)$meta.element);
    }

    private static final void onPlayerInteractEvent$lambda$4$lambda$3(Ref.ObjectRef $meta, ItemStack $item, ScheduledTask scheduledTask) {
        ItemMeta itemMeta = $item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        $meta.element = itemMeta;
        ((ItemMeta)$meta.element).getPersistentDataContainer().remove(Keys.PLACED);
        $item.setItemMeta((ItemMeta)$meta.element);
        $item.setAmount($item.getAmount() - 1);
    }

    private static final void onPlayerInteractEvent$lambda$4(PlayerInteractEvent $event, Location $location, int $maxMinions, PreMinionPlaceEvent $prePlaceEvent, MinionType $minionType, int $level, long $stats, long $charge, Chunk $chunk, Ref.ObjectRef $meta, ItemStack $item) {
        int placed = AxMinionsPlugin.Companion.getDataHandler().getMinionAmount($event.getPlayer().getUniqueId());
        int islandLimit = Config.Companion.ISLAND_LIMIT();
        int islandPlaced = 0;
        String islandId = "";
        if (islandLimit > 0 && AxMinionsAPI.Companion.getINSTANCE().getIntegrations().getIslandIntegration() != null) {
            IslandIntegration islandIntegration = AxMinionsAPI.Companion.getINSTANCE().getIntegrations().getIslandIntegration();
            Intrinsics.checkNotNull((Object)islandIntegration);
            islandId = islandIntegration.getIslandAt($location);
            IslandIntegration islandIntegration2 = AxMinionsAPI.Companion.getINSTANCE().getIntegrations().getIslandIntegration();
            Intrinsics.checkNotNull((Object)islandIntegration2);
            islandLimit += islandIntegration2.getExtra($location);
            if (Config.Companion.DEBUG()) {
                $event.getPlayer().sendMessage("Island ID: " + islandId + ", limit: " + islandLimit);
            }
            if (!StringsKt.isBlank((CharSequence)islandId)) {
                islandPlaced = AxMinionsAPI.Companion.getINSTANCE().getDataHandler().getIsland(islandId);
                if (Config.Companion.DEBUG()) {
                    $event.getPlayer().sendMessage("Placed: " + islandPlaced);
                }
                if (islandPlaced >= islandLimit && !$event.getPlayer().hasPermission("axminions.limit.*")) {
                    if (Config.Companion.DEBUG()) {
                        $event.getPlayer().sendMessage("Return");
                    }
                    TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("placed", String.valueOf(islandPlaced)), Placeholder.unparsed("max", String.valueOf(islandLimit))};
                    $event.getPlayer().sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.ISLAND_LIMIT_REACHED(), tagResolverArray));
                    Scheduler.get().run(arg_0 -> MinionPlaceListener.onPlayerInteractEvent$lambda$4$lambda$0($meta, $item, arg_0));
                    return;
                }
                if (Config.Companion.DEBUG()) {
                    $event.getPlayer().sendMessage("Not return " + (islandPlaced >= islandLimit) + " " + !$event.getPlayer().hasPermission("axminions.limit.*"));
                }
                ++islandPlaced;
            }
        }
        if (placed >= $maxMinions && !$prePlaceEvent.getShouldOverridePlayerLimit() && !$event.getPlayer().hasPermission("axminions.limit.*")) {
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("placed", String.valueOf(placed)), Placeholder.unparsed("max", String.valueOf($maxMinions))};
            $event.getPlayer().sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.PLACE_LIMIT_REACHED(), tagResolverArray));
            Scheduler.get().run(arg_0 -> MinionPlaceListener.onPlayerInteractEvent$lambda$4$lambda$1($meta, $item, arg_0));
            return;
        }
        if (AxMinionsPlugin.Companion.getDataHandler().isMinion($location)) {
            $event.getPlayer().sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.PLACE_MINION_AT_LOCATION(), new TagResolver[0]));
            Scheduler.get().run(arg_0 -> MinionPlaceListener.onPlayerInteractEvent$lambda$4$lambda$2($meta, $item, arg_0));
            return;
        }
        int locationId = AxMinionsPlugin.Companion.getDataHandler().getLocationID($location);
        Minion minion = new Minion($location, $event.getPlayer().getUniqueId(), (OfflinePlayer)$event.getPlayer(), $minionType, $level, new ItemStack(Material.AIR), null, Direction.NORTH, $stats, 0.0, locationId, 0, $charge);
        Minions.INSTANCE.startTicking($chunk);
        Scheduler.get().run(arg_0 -> MinionPlaceListener.onPlayerInteractEvent$lambda$4$lambda$3($meta, $item, arg_0));
        if (Config.Companion.DEBUG()) {
            $event.getPlayer().sendMessage("Placed minion " + minion + ". Ticking? " + minion.isTicking() + " Is chunk ticking? " + Minions.INSTANCE.isTicking($chunk) + " Chunk x: " + $chunk.getX() + " z: " + $chunk.getZ() + " location x: " + $location.getX() + " y: " + $location.getY() + " z: " + $location.getZ());
        }
        minion.setOwnerOnline(true);
        AxMinionsPlugin.Companion.getDataHandler().saveMinion(minion);
        if (!StringsKt.isBlank((CharSequence)islandId)) {
            AxMinionsPlugin.Companion.getDataHandler().islandPlace(islandId);
        }
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("type", $minionType.getName()), Placeholder.unparsed("placed", String.valueOf(placed + 1)), Placeholder.unparsed("max", String.valueOf($maxMinions)), Placeholder.unparsed("island-placed", String.valueOf(islandPlaced)), Placeholder.unparsed("island-max", String.valueOf(islandLimit))};
        $event.getPlayer().sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.PLACE_SUCCESS(), tagResolverArray));
    }
}

