/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.listeners;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.AxMinionsAPI;
import com.artillexstudios.axminions.api.config.Config;
import com.artillexstudios.axminions.api.config.Messages;
import com.artillexstudios.axminions.api.events.MinionToolEvent;
import com.artillexstudios.axminions.api.integrations.types.EconomyIntegration;
import com.artillexstudios.axminions.api.minions.Direction;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.minions.miniontype.MinionTypes;
import com.artillexstudios.axminions.api.utils.CoolDown;
import com.artillexstudios.axminions.api.utils.Keys;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axminions.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axminions.libs.axapi.utils.StringUtils;
import com.artillexstudios.axminions.listeners.LinkingListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/artillexstudios/axminions/listeners/MinionInventoryListener;", "Lorg/bukkit/event/Listener;", "()V", "coolDown", "Lcom/artillexstudios/axminions/api/utils/CoolDown;", "Lorg/bukkit/entity/Player;", "onInventoryClickEvent", "", "event", "Lorg/bukkit/event/inventory/InventoryClickEvent;", "onInventoryCloseEvent", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "onInventoryDragEvent", "Lorg/bukkit/event/inventory/InventoryDragEvent;", "sendFail", "player", "common"})
@SourceDebugExtension(value={"SMAP\nMinionInventoryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinionInventoryListener.kt\ncom/artillexstudios/axminions/listeners/MinionInventoryListener\n+ 2 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n*L\n1#1,359:1\n11#2,6:360\n*S KotlinDebug\n*F\n+ 1 MinionInventoryListener.kt\ncom/artillexstudios/axminions/listeners/MinionInventoryListener\n*L\n57#1:360,6\n*E\n"})
public final class MinionInventoryListener
implements Listener {
    @NotNull
    private final CoolDown<Player> coolDown = new CoolDown();

    @EventHandler
    public final void onInventoryDragEvent(@NotNull InventoryDragEvent event) {
        if (!(event.getInventory().getHolder() instanceof Minion)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public final void onInventoryClickEvent(@NotNull InventoryClickEvent event) {
        Minion minion;
        block82: {
            int n;
            IntRange indices$iv;
            int i$iv;
            InventoryHolder inventoryHolder = event.getInventory().getHolder();
            Minion minion2 = inventoryHolder instanceof Minion ? (Minion)inventoryHolder : null;
            if (minion2 == null) {
                return;
            }
            minion = minion2;
            if (event.getClickedInventory() == null) {
                return;
            }
            event.setCancelled(true);
            HumanEntity humanEntity = event.getWhoClicked();
            Intrinsics.checkNotNull((Object)humanEntity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
            Player player = (Player)humanEntity;
            if (this.coolDown.contains(player)) {
                return;
            }
            this.coolDown.add(player, 250L);
            ArrayList<Material> allowedTools = new ArrayList<Material>();
            MinionInventoryListener $this$onInventoryClickEvent_u24lambda_u241 = this;
            boolean bl = false;
            ItemStack[] $this$fastFor$iv = minion.getType().getConfig().getStringList("tool.material");
            boolean $i$f$fastFor = false;
            if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)((Collection)$this$fastFor$iv))).getFirst()) <= (n = indices$iv.getLast())) {
                while (true) {
                    String it = $this$fastFor$iv.get(i$iv);
                    boolean bl2 = false;
                    if (it.equals("*")) {
                        allowedTools.addAll((Collection)EntriesMappings.entries$0);
                        break;
                    }
                    Material material = Material.matchMaterial((String)it);
                    if (material != null) {
                        allowedTools.add(material);
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            if (Intrinsics.areEqual((Object)event.getClickedInventory(), (Object)player.getInventory()) && event.getCurrentItem() != null) {
                ItemStack itemStack = event.getCurrentItem();
                Intrinsics.checkNotNull((Object)itemStack);
                if (!allowedTools.contains(itemStack.getType())) {
                    player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.WRONG_TOOL(), new TagResolver[0]));
                    return;
                }
                ItemStack itemStack2 = event.getCurrentItem();
                Intrinsics.checkNotNull((Object)itemStack2);
                ItemStack itemStack3 = itemStack2.clone();
                ItemStack itemStack4 = minion.getTool();
                Intrinsics.checkNotNull((Object)itemStack4);
                MinionToolEvent minionToolEvent = new MinionToolEvent(minion, player, itemStack3, itemStack4.clone());
                Bukkit.getPluginManager().callEvent((Event)minionToolEvent);
                if (minionToolEvent.isCancelled()) {
                    return;
                }
                ItemStack itemStack5 = minion.getTool();
                if ((itemStack5 != null ? itemStack5.getType() : null) != Material.AIR) {
                    ItemStack current = minionToolEvent.getNewTool();
                    ItemStack tool = minionToolEvent.getOldTool();
                    Minion.DefaultImpls.setTool$default(minion, current, false, 2, null);
                    minion.updateArmour();
                    ItemStack itemStack6 = event.getCurrentItem();
                    Intrinsics.checkNotNull((Object)itemStack6);
                    itemStack6.setAmount(0);
                    Inventory inventory = event.getClickedInventory();
                    Intrinsics.checkNotNull((Object)inventory);
                    $this$fastFor$iv = new ItemStack[]{tool};
                    inventory.addItem($this$fastFor$iv);
                } else {
                    Minion.DefaultImpls.setTool$default(minion, minionToolEvent.getNewTool(), false, 2, null);
                    ItemStack itemStack7 = event.getCurrentItem();
                    Intrinsics.checkNotNull((Object)itemStack7);
                    itemStack7.setAmount(0);
                }
                minion.updateInventories();
                return;
            }
            Object t = AxMinionsAPI.Companion.getINSTANCE().getConfig().get("gui.items.item.slot");
            if (t instanceof Integer && event.getSlot() == ((Number)t).intValue()) {
                ItemStack itemStack = minion.getTool();
                if ((itemStack != null ? itemStack.getType() : null) == Material.AIR) {
                    return;
                }
                if (player.getInventory().firstEmpty() == -1) {
                    player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.ERROR_INVENTORY_FULL(), new TagResolver[0]));
                    return;
                }
                ItemStack itemStack8 = minion.getTool();
                if (itemStack8 == null || (itemStack8 = itemStack8.clone()) == null) {
                    return;
                }
                ItemStack tool = itemStack8;
                MinionToolEvent minionToolEvent = new MinionToolEvent(minion, player, new ItemStack(Material.AIR), tool);
                Bukkit.getPluginManager().callEvent((Event)minionToolEvent);
                if (minionToolEvent.isCancelled()) {
                    return;
                }
                Minion.DefaultImpls.setTool$default(minion, new ItemStack(Material.AIR), false, 2, null);
                minion.updateArmour();
                ItemMeta itemMeta = minionToolEvent.getOldTool().getItemMeta();
                if (itemMeta == null) {
                    return;
                }
                ItemMeta toolMeta = itemMeta;
                toolMeta.getPersistentDataContainer().remove(Keys.GUI);
                minionToolEvent.getOldTool().setItemMeta(toolMeta);
                $this$fastFor$iv = new ItemStack[]{minionToolEvent.getOldTool()};
                player.getInventory().addItem($this$fastFor$iv);
                minion.updateInventories();
                return;
            }
            Inventory inventory = event.getClickedInventory();
            if (inventory == null || (inventory = inventory.getItem(event.getSlot())) == null) {
                return;
            }
            if (!inventory.hasItemMeta()) {
                return;
            }
            Inventory inventory2 = event.getClickedInventory();
            if (inventory2 == null || (inventory2 = inventory2.getItem(event.getSlot())) == null || (inventory2 = inventory2.getItemMeta()) == null) {
                return;
            }
            Inventory meta = inventory2;
            if (!meta.getPersistentDataContainer().has(Keys.GUI, PersistentDataType.STRING)) {
                return;
            }
            String type = (String)meta.getPersistentDataContainer().get(Keys.GUI, PersistentDataType.STRING);
            String string = type;
            if (string == null) break block82;
            int n2 = -1;
            switch (string.hashCode()) {
                case -925180581: {
                    if (string.equals("rotate")) {
                        n2 = 1;
                    }
                    break;
                }
                case -1361632588: {
                    if (string.equals("charge")) {
                        n2 = 2;
                    }
                    break;
                }
                case -231171556: {
                    if (string.equals("upgrade")) {
                        n2 = 3;
                    }
                    break;
                }
                case 3321850: {
                    if (string.equals("link")) {
                        n2 = 4;
                    }
                    break;
                }
                case -94588637: {
                    if (string.equals("statistics")) {
                        n2 = 5;
                    }
                    break;
                }
            }
            switch (n2) {
                case 1: {
                    switch (WhenMappings.$EnumSwitchMapping$0[minion.getDirection().ordinal()]) {
                        case 1: {
                            Minion.DefaultImpls.setDirection$default(minion, Direction.WEST, false, 2, null);
                            break;
                        }
                        case 2: {
                            Minion.DefaultImpls.setDirection$default(minion, Direction.NORTH, false, 2, null);
                            break;
                        }
                        case 3: {
                            Minion.DefaultImpls.setDirection$default(minion, Direction.EAST, false, 2, null);
                            break;
                        }
                        case 4: {
                            Minion.DefaultImpls.setDirection$default(minion, Direction.SOUTH, false, 2, null);
                        }
                    }
                    break;
                }
                case 4: {
                    if (minion.getLinkedChest() != null) {
                        minion.setLinkedChest(null);
                        player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.LINK_UNLINK(), new TagResolver[0]));
                        return;
                    }
                    player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.LINK_START(), new TagResolver[0]));
                    ((Map)LinkingListener.Companion.getLinking()).put(player, minion);
                    player.closeInventory();
                    break;
                }
                case 3: {
                    double money = minion.getType().getDouble("requirements.money", minion.getLevel() + 1);
                    double actions = minion.getType().getDouble("requirements.actions", minion.getLevel() + 1);
                    if (minion.getType().hasReachedMaxLevel(minion)) {
                        return;
                    }
                    if ((double)minion.getActionAmount() < actions) {
                        this.sendFail(player);
                        return;
                    }
                    EconomyIntegration economyIntegration = AxMinionsPlugin.Companion.getIntegrations().getEconomyIntegration();
                    if (economyIntegration != null) {
                        EconomyIntegration it = economyIntegration;
                        boolean bl3 = false;
                        if (it.getBalance((OfflinePlayer)player) < money) {
                            this.sendFail(player);
                            return;
                        }
                        it.takeBalance((OfflinePlayer)player, money);
                    }
                    if (!StringsKt.isBlank((CharSequence)Config.Companion.UPGRADE_SOUND())) {
                        Entity entity = (Entity)player;
                        String string2 = Config.Companion.UPGRADE_SOUND().toUpperCase(Locale.ENGLISH);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                        player.playSound(entity, Sound.valueOf((String)string2), 1.0f, 1.0f);
                    }
                    minion.setLevel(minion.getLevel() + 1);
                    break;
                }
                case 5: {
                    double stored = minion.getStorage();
                    if (stored == 0.0) {
                        return;
                    }
                    if (Intrinsics.areEqual((Object)minion.getType(), (Object)MinionTypes.getMinionTypes().get("seller"))) {
                        EconomyIntegration economyIntegration = AxMinionsPlugin.Companion.getIntegrations().getEconomyIntegration();
                        if (economyIntegration != null) {
                            EconomyIntegration it = economyIntegration;
                            boolean bl4 = false;
                            OfflinePlayer offlinePlayer = minion.getOwner();
                            if (offlinePlayer != null) {
                                OfflinePlayer player2 = offlinePlayer;
                                boolean bl5 = false;
                                it.giveBalance(player2, stored);
                                minion.setStorage(0.0);
                            }
                        }
                    } else {
                        player.giveExp((int)stored);
                        minion.setStorage(0.0);
                    }
                    AxMinionsPlugin.Companion.getDataQueue().submit(() -> MinionInventoryListener.onInventoryClickEvent$lambda$5(minion));
                    break;
                }
                case 2: {
                    boolean itemCharge;
                    if (event.isShiftClick()) {
                        while (true) {
                            long chargeSeconds = (minion.getCharge() - System.currentTimeMillis()) / (long)1000;
                            if ((long)(Config.Companion.MAX_CHARGE() * 60) - chargeSeconds < (long)Config.Companion.MINIMUM_CHARGE()) {
                                player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE_NOT_ENOUGH_TIME_PASSED(), new TagResolver[0]));
                                return;
                            }
                            int chargeAmount = Config.Companion.CHARGE_AMOUNT();
                            itemCharge = false;
                            Section section = Config.Companion.CHARGE_ITEMS();
                            for (Object key : section.getKeys()) {
                                ItemStack item = ItemBuilder.create(section.getSection(key.toString())).get();
                                if (!player.getInventory().containsAtLeast(item, 1)) continue;
                                itemCharge = true;
                                chargeAmount = section.getSection(key.toString()).getInt("charge");
                                ItemStack[] itemStackArray = new ItemStack[]{item};
                                player.getInventory().removeItem(itemStackArray);
                                break;
                            }
                            if (Config.Companion.CHARGE_PRICE() <= 0.0 && !itemCharge) {
                                player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE_FAIL(), new TagResolver[0]));
                                return;
                            }
                            if (!itemCharge) {
                                EconomyIntegration economyIntegration = AxMinionsPlugin.Companion.getIntegrations().getEconomyIntegration();
                                if (economyIntegration == null) {
                                    return;
                                }
                                if (economyIntegration.getBalance((OfflinePlayer)player) < Config.Companion.CHARGE_PRICE()) {
                                    player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE_FAIL(), new TagResolver[0]));
                                    return;
                                }
                                if (AxMinionsPlugin.Companion.getIntegrations().getEconomyIntegration() != null) {
                                    boolean bl6 = false;
                                    if (minion.getOwner() != null) {
                                        OfflinePlayer player3;
                                        EconomyIntegration it;
                                        boolean bl7 = false;
                                        it.takeBalance(player3, Config.Companion.CHARGE_PRICE());
                                    }
                                }
                            }
                            if (chargeSeconds + (long)chargeAmount > (long)Config.Companion.MAX_CHARGE() * 60L) {
                                minion.setCharge(System.currentTimeMillis() + (long)Config.Companion.MAX_CHARGE() * 60L * 1000L);
                                return;
                            }
                            if (minion.getCharge() < System.currentTimeMillis()) {
                                minion.setCharge(System.currentTimeMillis() + (long)(chargeAmount * 1000));
                            } else {
                                minion.setCharge(minion.getCharge() + (long)(chargeAmount * 1000));
                            }
                            if (!(!StringsKt.isBlank((CharSequence)Messages.Companion.CHARGE()))) continue;
                            player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE(), new TagResolver[0]));
                        }
                    }
                    long chargeSeconds = (minion.getCharge() - System.currentTimeMillis()) / (long)1000;
                    if ((long)(Config.Companion.MAX_CHARGE() * 60) - chargeSeconds < (long)Config.Companion.MINIMUM_CHARGE()) {
                        player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE_NOT_ENOUGH_TIME_PASSED(), new TagResolver[0]));
                        return;
                    }
                    int chargeAmount = Config.Companion.CHARGE_AMOUNT();
                    itemCharge = false;
                    Section section = Config.Companion.CHARGE_ITEMS();
                    for (Object key : section.getKeys()) {
                        ItemStack item = ItemBuilder.create(section.getSection(key.toString())).get();
                        if (!player.getInventory().containsAtLeast(item, 1)) continue;
                        itemCharge = true;
                        chargeAmount = section.getSection(key.toString()).getInt("charge");
                        ItemStack[] bl6 = new ItemStack[]{item};
                        player.getInventory().removeItem(bl6);
                        break;
                    }
                    if (Config.Companion.CHARGE_PRICE() <= 0.0 && !itemCharge) {
                        player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE_FAIL(), new TagResolver[0]));
                        return;
                    }
                    if (!itemCharge) {
                        EconomyIntegration economyIntegration = AxMinionsPlugin.Companion.getIntegrations().getEconomyIntegration();
                        if (economyIntegration == null) {
                            return;
                        }
                        if (economyIntegration.getBalance((OfflinePlayer)player) < Config.Companion.CHARGE_PRICE()) {
                            player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE_FAIL(), new TagResolver[0]));
                            return;
                        }
                        EconomyIntegration economyIntegration2 = AxMinionsPlugin.Companion.getIntegrations().getEconomyIntegration();
                        if (economyIntegration2 != null) {
                            EconomyIntegration it = economyIntegration2;
                            boolean bl8 = false;
                            OfflinePlayer offlinePlayer = minion.getOwner();
                            if (offlinePlayer != null) {
                                OfflinePlayer player4 = offlinePlayer;
                                boolean bl9 = false;
                                it.takeBalance(player4, Config.Companion.CHARGE_PRICE());
                            }
                        }
                    }
                    if (chargeSeconds + (long)chargeAmount > (long)Config.Companion.MAX_CHARGE() * 60L) {
                        minion.setCharge(System.currentTimeMillis() + (long)Config.Companion.MAX_CHARGE() * 60L * 1000L);
                        return;
                    }
                    if (minion.getCharge() < System.currentTimeMillis()) {
                        minion.setCharge(System.currentTimeMillis() + (long)(chargeAmount * 1000));
                    } else {
                        minion.setCharge(minion.getCharge() + (long)(chargeAmount * 1000));
                    }
                    if (!(!StringsKt.isBlank((CharSequence)Messages.Companion.CHARGE()))) break;
                    player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.CHARGE(), new TagResolver[0]));
                }
            }
        }
        minion.updateInventories();
    }

    @EventHandler
    public final void onInventoryCloseEvent(@NotNull InventoryCloseEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        Minion minion = inventoryHolder instanceof Minion ? (Minion)inventoryHolder : null;
        if (minion == null) {
            return;
        }
        Minion holder = minion;
        holder.removeOpenInventory(event.getInventory());
    }

    private final void sendFail(Player player) {
        switch (Config.Companion.UPGRADE_FAIL()) {
            case "title": {
                player.closeInventory();
                player.sendTitle(StringUtils.formatToString(Messages.Companion.UPGRADE_FAIL(), new TagResolver[0]), "", 10, 70, 20);
                break;
            }
            case "subtitle": {
                player.closeInventory();
                player.sendTitle("", StringUtils.formatToString(Messages.Companion.UPGRADE_FAIL(), new TagResolver[0]), 10, 70, 20);
                break;
            }
            case "actionbar": {
                player.closeInventory();
                BaseComponent[] baseComponentArray = TextComponent.fromLegacyText((String)StringUtils.formatToString(Messages.Companion.UPGRADE_FAIL(), new TagResolver[0]));
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, Arrays.copyOf(baseComponentArray, baseComponentArray.length));
                break;
            }
            default: {
                player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.UPGRADE_FAIL(), new TagResolver[0]));
            }
        }
    }

    private static final void onInventoryClickEvent$lambda$5(Minion $minion) {
        AxMinionsPlugin.Companion.getDataHandler().saveMinion($minion);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Material> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Material.values()));
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

