/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.listeners;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.AxMinionsAPI;
import com.artillexstudios.axminions.api.events.MinionKillEntityEvent;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.warnings.Warnings;
import com.artillexstudios.axminions.integrations.stacker.RoseStackerIntegration;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axminions.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axminions.nms.NMSHandler;
import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.stack.StackedEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/artillexstudios/axminions/listeners/MinionDamageListener;", "Lorg/bukkit/event/Listener;", "()V", "random", "Ljava/util/Random;", "onEntityDamageByEntityEvent", "", "event", "Lorg/bukkit/event/entity/EntityDamageByEntityEvent;", "onEntityDamageByEntityEvente", "onMinionKillEntityEvent", "Lcom/artillexstudios/axminions/api/events/MinionKillEntityEvent;", "common"})
@SourceDebugExtension(value={"SMAP\nMinionDamageListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinionDamageListener.kt\ncom/artillexstudios/axminions/listeners/MinionDamageListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n*L\n1#1,96:1\n800#2,11:97\n11#3,6:108\n*S KotlinDebug\n*F\n+ 1 MinionDamageListener.kt\ncom/artillexstudios/axminions/listeners/MinionDamageListener\n*L\n52#1:97,11\n52#1:108,6\n*E\n"})
public final class MinionDamageListener
implements Listener {
    @NotNull
    private final Random random = new Random();

    @EventHandler
    public final void onMinionKillEntityEvent(@NotNull MinionKillEntityEvent event) {
        Minion minion = event.getMinion();
        long entitySize = AxMinionsPlugin.Companion.getIntegrations().getStackerIntegration().getStackSize(event.getTarget());
        if (AxMinionsPlugin.Companion.getIntegrations().getStackerIntegration() instanceof RoseStackerIntegration && entitySize > 1L) {
            long amountToKill;
            double chance = minion.getType().getDouble("chance-kill-stacked-amount", minion.getLevel());
            long amount = minion.getType().getLong("stacked-amount", minion.getLevel());
            StackedEntity stackedEntity = RoseStackerAPI.getInstance().getStackedEntity(event.getTarget());
            Intrinsics.checkNotNull((Object)stackedEntity);
            StackedEntity stackedEntity2 = stackedEntity;
            long l = amountToKill = entitySize > amount ? amount : entitySize;
            if (this.random.nextDouble() <= chance) {
                Intrinsics.checkNotNull((Object)amountToKill, (String)"null cannot be cast to non-null type kotlin.Number");
                stackedEntity2.killPartialStack(null, (int)amountToKill);
                minion.setActions(minion.getActionAmount() + (amountToKill - 1L));
            }
        } else {
            event.getMinion().setActions(event.getMinion().getActionAmount() + entitySize);
        }
        double coerced = RangesKt.coerceIn((double)(event.getMinion().getStorage() + (double)((long)ThreadLocalRandom.current().nextInt(1, 4) * entitySize)), (double)0.0, (double)event.getMinion().getType().getLong("storage", event.getMinion().getLevel()));
        event.getMinion().setStorage(coerced);
        Scheduler.get().runLaterAt(event.getTarget().getLocation(), arg_0 -> MinionDamageListener.onMinionKillEntityEvent$lambda$1(event, arg_0), 2L);
    }

    @EventHandler
    public final void onEntityDamageByEntityEvent(@NotNull EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && Intrinsics.areEqual((Object)event.getDamager().getUniqueId(), (Object)NMSHandler.Companion.get().getAnimalUUID()) && event.getFinalDamage() > ((LivingEntity)entity).getHealth()) {
            Minion minion = NMSHandler.Companion.get().getMinion();
            if (minion == null) {
                return;
            }
            Bukkit.getPluginManager().callEvent((Event)new MinionKillEntityEvent(minion, (LivingEntity)entity));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public final void onEntityDamageByEntityEvente(@NotNull EntityDamageByEntityEvent event) {
        if (!Intrinsics.areEqual((Object)event.getDamager().getUniqueId(), (Object)NMSHandler.Companion.get().getAnimalUUID())) {
            return;
        }
        if (event.getEntity() instanceof Player) {
            event.setCancelled(true);
            event.setDamage(0.0);
            return;
        }
        event.setCancelled(false);
    }

    /*
     * WARNING - void declaration
     */
    private static final void onMinionKillEntityEvent$lambda$1(MinionKillEntityEvent $event, ScheduledTask task) {
        int n;
        IntRange indices$iv;
        int i$iv;
        void $this$filterIsInstanceTo$iv$iv;
        World world = $event.getTarget().getLocation().getWorld();
        Intrinsics.checkNotNull((Object)world);
        Iterable $this$filterIsInstance$iv = world.getNearbyEntities($event.getTarget().getLocation(), 4.0, 4.0, 4.0);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Item)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$fastFor$iv = (List)destination$iv$iv;
        boolean $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)$this$fastFor$iv)).getFirst()) <= (n = indices$iv.getLast())) {
            while (true) {
                Item item = (Item)$this$fastFor$iv.get(i$iv);
                boolean bl = false;
                Inventory inventory = $event.getMinion().getLinkedInventory();
                boolean bl2 = inventory != null ? inventory.firstEmpty() == -1 : false;
                if (bl2) {
                    Warnings.CONTAINER_FULL.display($event.getMinion());
                    return;
                }
                long amount = AxMinionsPlugin.Companion.getIntegrations().getStackerIntegration().getStackSize(item);
                ItemStack stack = item.getItemStack();
                stack.setAmount((int)amount);
                if ($event.getMinion().addWithRemaining(stack) != null) {
                    HashMap<Integer, ItemStack> map;
                    if (map.isEmpty() || stack.getAmount() <= 0) {
                        item.remove();
                    } else {
                        AxMinionsAPI.Companion.getINSTANCE().getIntegrations().getStackerIntegration().setStackSize(item, stack.getAmount());
                    }
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
    }
}

