/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.util;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.lamp.util.Primitives;
import java.util.HashMap;
import java.util.Map;

public final class ClassMap<V>
extends HashMap<Class<?>, V> {
    public boolean add(Class<?> type, V value) {
        Class<?> wrapped = Primitives.wrap(type);
        if (this.containsKey(wrapped)) {
            return false;
        }
        this.put(wrapped, value);
        return false;
    }

    public V getFlexibleOrDefault(@NotNull Class<?> key, V def) {
        V value = this.getFlexible(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public V getFlexible(@NotNull Class<?> key) {
        Object v = this.get(key = Primitives.wrap(key));
        if (v != null) {
            return v;
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!((Class)entry.getKey()).isAssignableFrom(key)) continue;
            v = entry.getValue();
            break;
        }
        this.put(key, v);
        return v;
    }
}

