/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.process;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.lamp.command.CommandParameter;
import com.artillexstudios.axminions.libs.lamp.process.BuiltInNamingStrategies;
import java.util.Locale;

@FunctionalInterface
public interface ParameterNamingStrategy {
    @NotNull
    public String getName(@NotNull CommandParameter var1);

    public static ParameterNamingStrategy identity() {
        return parameter -> parameter.getJavaParameter().getName();
    }

    public static ParameterNamingStrategy lowerCaseWithSeparator(String separator) {
        return parameter -> BuiltInNamingStrategies.separateCamelCase(parameter.getName(), separator).toLowerCase(Locale.ENGLISH);
    }

    public static ParameterNamingStrategy lowerCaseWithSpace() {
        return ParameterNamingStrategy.lowerCaseWithSeparator(" ");
    }

    public static ParameterNamingStrategy upperCamelCase() {
        return parameter -> BuiltInNamingStrategies.upperCaseFirstLetter(parameter.getName());
    }

    public static ParameterNamingStrategy upperCamelCaseWithSpace() {
        return ParameterNamingStrategy.upperCamelCaseWithSeparator(" ");
    }

    public static ParameterNamingStrategy upperCamelCaseWithSeparator(String separator) {
        return parameter -> BuiltInNamingStrategies.upperCaseFirstLetter(BuiltInNamingStrategies.separateCamelCase(parameter.getName(), separator));
    }
}

