/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.locales;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.lamp.util.Preconditions;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Locales {
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale SPANISH = new Locale("es");
    public static final Locale DUTCH = new Locale("nl");
    public static final Locale DANISH = new Locale("da");
    public static final Locale CZECH = new Locale("cs");
    public static final Locale GREEK = new Locale("el");
    public static final Locale LATIN = new Locale("la");
    public static final Locale BULGARIAN = new Locale("bg");
    public static final Locale AFRIKAANS = new Locale("af");
    public static final Locale HINDI = new Locale("hi");
    public static final Locale HEBREW = new Locale("he");
    public static final Locale POLISH = new Locale("pl");
    public static final Locale PORTUGUESE = new Locale("pt");
    public static final Locale FINNISH = new Locale("fi");
    public static final Locale SWEDISH = new Locale("sv");
    public static final Locale RUSSIAN = new Locale("ru");
    public static final Locale ROMANIAN = new Locale("ro");
    public static final Locale VIETNAMESE = new Locale("vi");
    public static final Locale THAI = new Locale("th");
    public static final Locale TURKISH = new Locale("tr");
    public static final Locale UKRANIAN = new Locale("uk");
    public static final Locale ARABIC = new Locale("ar");
    public static final Locale WELSH = new Locale("cy");
    public static final Locale NORWEGIAN_BOKMAAL = new Locale("nb");
    public static final Locale NORWEGIAN_NYNORSK = new Locale("nn");
    public static final Locale HUNGARIAN = new Locale("hu");
    private static final Map<String, Locale> LOCALES;

    public static Locale get(@NotNull String language) {
        Preconditions.notNull(language, "language");
        return LOCALES.get(language);
    }

    public static Iterable<Locale> getLocales() {
        return LOCALES.values();
    }

    private Locales() {
        throw new AssertionError((Object)"You should not be attempting to instantiate this class.");
    }

    static {
        HashMap<String, Locale> locales = new HashMap<String, Locale>();
        for (Field field : Locales.class.getDeclaredFields()) {
            if (field.getType() != Locale.class) continue;
            try {
                Locale locale = (Locale)field.get(null);
                locales.putIfAbsent(locale.getLanguage(), locale);
                locales.put(locale.toString(), locale);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        LOCALES = Collections.unmodifiableMap(locales);
    }
}

