/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.ktx.call;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.annotations.Unmodifiable;
import com.artillexstudios.axminions.libs.lamp.core.reflect.MethodCaller;
import com.artillexstudios.axminions.libs.lamp.ktx.call.CallableMethod;
import com.artillexstudios.axminions.libs.lamp.ktx.call.DefaultFunctionFinder;
import com.artillexstudios.axminions.libs.lamp.ktx.call.KotlinConstants;
import com.artillexstudios.axminions.libs.lamp.ktx.call.KotlinFunction;
import com.artillexstudios.axminions.libs.lamp.ktx.call.KotlinSingletons;
import com.artillexstudios.axminions.libs.lamp.util.Preconditions;
import com.artillexstudios.axminions.libs.lamp.util.Suppliers;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

final class KotlinFunctionImpl
implements KotlinFunction {
    private final Supplier<@Unmodifiable Map<String, Parameter>> byName = Suppliers.lazy(() -> {
        HashMap<String, Parameter> byName = new HashMap<String, Parameter>();
        for (Parameter parameter : this.getParameters()) {
            byName.put(parameter.getName(), parameter);
        }
        return Collections.unmodifiableMap(byName);
    });
    private final CallableMethod mainMethod;
    private final Supplier<@Nullable CallableMethod> defaultMethod;
    private final @Unmodifiable List<Parameter> parameters;

    public KotlinFunctionImpl(Method mainMethod) {
        MethodCaller mainCaller = KotlinSingletons.getCallerForNonDefault(mainMethod);
        this.parameters = Arrays.asList(mainMethod.getParameters());
        this.mainMethod = CallableMethod.of(mainMethod, mainCaller);
        this.defaultMethod = Suppliers.lazy(() -> DefaultFunctionFinder.findDefaultFunction(mainMethod));
    }

    @Override
    @NotNull
    public CallableMethod getMethod() {
        return this.mainMethod;
    }

    @Override
    @Nullable
    public CallableMethod getDefaultSyntheticMethod() {
        return this.defaultMethod.get();
    }

    @Override
    public boolean isSuspend() {
        Parameter lastParameter = com.artillexstudios.axminions.libs.lamp.util.Collections.getOrNull(this.parameters, this.parameters.size() - 1);
        return lastParameter != null && lastParameter.getType() == KotlinConstants.continuation();
    }

    @Override
    public <T> T call(@Nullable Object instance, @NotNull List<Object> arguments, @NotNull Function<Parameter, Boolean> isOptional) {
        Map<Parameter, Object> callArgs = this.mapArgsToParams(i -> com.artillexstudios.axminions.libs.lamp.util.Collections.getOrNull(arguments, (int)i));
        return this.callByParameters(instance, callArgs, isOptional);
    }

    @Override
    public <T> T callByIndices(@Nullable Object instance, @NotNull Map<Integer, Object> arguments, @NotNull Function<Parameter, Boolean> isOptional) {
        Map<Parameter, Object> callArgs = this.mapArgsToParams(arguments::get);
        return this.callByParameters(instance, callArgs, isOptional);
    }

    @Override
    public <T> T callByNames(@Nullable Object instance, @NotNull Map<String, Object> arguments, @NotNull Function<Parameter, Boolean> isOptional) {
        return this.callByParameters(instance, com.artillexstudios.axminions.libs.lamp.util.Collections.mapKeys(arguments, this::getParameter), isOptional);
    }

    @Override
    public <T> T callByParameters(@Nullable Object instance, @NotNull Map<Parameter, Object> arguments, @NotNull Function<Parameter, Boolean> isOptional) {
        Preconditions.checkCallableStatic(instance, this.mainMethod.getMethod());
        ArrayList<Object> args = new ArrayList<Object>();
        int mask = 0;
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        int index = 0;
        boolean anyOptional = false;
        for (Parameter parameter : this.parameters) {
            Object providedArg;
            if (index != 0 && index % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            if ((providedArg = arguments.get(parameter)) != null) {
                args.add(providedArg);
            } else if (isOptional.apply(parameter).booleanValue()) {
                mask |= 1 << index % 32;
                args.add(KotlinConstants.defaultPrimitiveValue(parameter.getType()));
                anyOptional = true;
            } else if (parameter.isVarArgs()) {
                args.add(Array.newInstance(parameter.getType(), 0));
            } else {
                throw new IllegalArgumentException("No argument provided for a required parameter: " + parameter + ".");
            }
            ++index;
        }
        if (!anyOptional) {
            return (T)this.mainMethod.getCaller().call(instance, args.toArray());
        }
        CallableMethod defaultMethod = this.defaultMethod.get();
        if (defaultMethod == null) {
            throw new IllegalArgumentException("Unable to invoke function with default parameters. \nThis may happen because you have an @Optional non-null primitive type (e.g. Int) with no default value using @Default or a Kotlin-default value.\nEither mark it as nullable, add a default value (@Optional param: Type = ...), or use @Default");
        }
        masks.add(mask);
        args.addAll(masks);
        args.add(null);
        return (T)defaultMethod.getCaller().call(instance, args.toArray());
    }

    @NotNull
    private Map<Parameter, Object> mapArgsToParams(@NotNull Function<Integer, Object> map) {
        HashMap<Parameter, Object> callArgs = new HashMap<Parameter, Object>();
        for (int i = 0; i < this.parameters.size(); ++i) {
            Parameter parameter = this.parameters.get(i);
            callArgs.put(parameter, map.apply(i));
        }
        return callArgs;
    }

    @Override
    public @Unmodifiable @NotNull List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public @Unmodifiable @NotNull Map<String, Parameter> getParametersByName() {
        return this.byName.get();
    }

    @Override
    @NotNull
    public Parameter getParameter(@NotNull String name) {
        Parameter parameter = this.getParametersByName().get(name);
        if (parameter == null) {
            throw new IllegalArgumentException("No such parameter: '" + name + "'. Available parameters: " + this.getParametersByName().keySet());
        }
        return parameter;
    }

    @Override
    @NotNull
    public Parameter getParameter(int index) {
        return this.parameters.get(index);
    }
}

