/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.lamp.CommandHandler;
import com.artillexstudios.axminions.libs.lamp.annotation.Description;
import com.artillexstudios.axminions.libs.lamp.annotation.dynamic.AnnotationReplacer;
import com.artillexstudios.axminions.libs.lamp.annotation.dynamic.Annotations;
import com.artillexstudios.axminions.libs.lamp.util.Collections;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LocalesAnnotationReplacer
implements AnnotationReplacer<Description> {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("#\\{(?<key>.*)}");
    private final CommandHandler handler;

    public LocalesAnnotationReplacer(CommandHandler handler) {
        this.handler = handler;
    }

    @Override
    @Nullable
    public Collection<Annotation> replaceAnnotations(@NotNull AnnotatedElement element, @NotNull Description annotation) {
        Matcher matcher = LOCALE_PATTERN.matcher(annotation.value());
        if (matcher.matches()) {
            String key = matcher.group("key");
            return Collections.listOf(Annotations.create(Description.class, "value", this.handler.getTranslator().get(key)));
        }
        return null;
    }
}

