/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.lamp.annotation.CaseSensitive;
import com.artillexstudios.axminions.libs.lamp.command.CommandParameter;
import com.artillexstudios.axminions.libs.lamp.exception.EnumNotFoundException;
import com.artillexstudios.axminions.libs.lamp.process.ValueResolver;
import com.artillexstudios.axminions.libs.lamp.process.ValueResolverFactory;
import java.util.HashMap;

enum EnumResolverFactory implements ValueResolverFactory
{
    INSTANCE;


    @Override
    @Nullable
    public ValueResolver<?> create(@NotNull CommandParameter parameter) {
        Class<?> type = parameter.getType();
        if (!type.isEnum()) {
            return null;
        }
        Class<Enum> enumType = type.asSubclass(Enum.class);
        HashMap<String, Enum> values = new HashMap<String, Enum>();
        boolean caseSensitive = parameter.hasAnnotation(CaseSensitive.class);
        for (Enum enumConstant : enumType.getEnumConstants()) {
            if (caseSensitive) {
                values.put(enumConstant.name(), enumConstant);
                continue;
            }
            values.put(enumConstant.name().toLowerCase(), enumConstant);
        }
        return context -> {
            String value = context.pop();
            Enum v = (Enum)values.get(caseSensitive ? value : value.toLowerCase());
            if (v == null) {
                throw new EnumNotFoundException(parameter, value);
            }
            return v;
        };
    }
}

