/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.lamp.annotation.Dependency;
import com.artillexstudios.axminions.libs.lamp.command.CommandParameter;
import com.artillexstudios.axminions.libs.lamp.process.ContextResolver;
import com.artillexstudios.axminions.libs.lamp.process.ContextResolverFactory;
import java.util.function.Supplier;

enum DependencyResolverFactory implements ContextResolverFactory
{
    INSTANCE;


    @Override
    @Nullable
    public ContextResolver<?> create(@NotNull CommandParameter parameter) {
        if (!parameter.hasAnnotation(Dependency.class)) {
            return null;
        }
        Supplier<?> value = parameter.getCommandHandler().getDependency(parameter.getType());
        if (value == null) {
            throw new IllegalArgumentException("Unable to resolve dependency for parameter " + parameter.getName() + " in " + parameter.getDeclaringCommand().getPath().toRealString());
        }
        return context -> value.get();
    }
}

