/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Unmodifiable;
import com.artillexstudios.axminions.libs.lamp.annotation.Cooldown;
import com.artillexstudios.axminions.libs.lamp.command.CommandActor;
import com.artillexstudios.axminions.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axminions.libs.lamp.exception.CooldownException;
import com.artillexstudios.axminions.libs.lamp.process.CommandCondition;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

enum CooldownCondition implements CommandCondition
{
    INSTANCE;

    private static final ScheduledExecutorService COOLDOWN_POOL;
    private final Map<UUID, Map<Integer, Long>> cooldowns = new ConcurrentHashMap<UUID, Map<Integer, Long>>();

    @Override
    public void test(@NotNull CommandActor actor, @NotNull ExecutableCommand command, @NotNull @Unmodifiable List<String> arguments) {
        Cooldown cooldown = command.getAnnotation(Cooldown.class);
        if (cooldown == null || cooldown.value() == 0L) {
            return;
        }
        UUID uuid = actor.getUniqueId();
        Map<Integer, Long> spans = this.get(uuid);
        Long created = spans.get(command.getId());
        if (created == null) {
            spans.put(command.getId(), System.currentTimeMillis());
            COOLDOWN_POOL.schedule(() -> (Long)spans.remove(command.getId()), cooldown.value(), cooldown.unit());
            return;
        }
        long passed = System.currentTimeMillis() - created;
        long left = cooldown.unit().toMillis(cooldown.value()) - passed;
        if (left > 0L && left < 1000L) {
            left = 1000L;
        }
        throw new CooldownException(left);
    }

    private Map<Integer, Long> get(@NotNull UUID uuid) {
        return this.cooldowns.computeIfAbsent(uuid, u -> new ConcurrentHashMap());
    }

    static {
        COOLDOWN_POOL = Executors.newSingleThreadScheduledExecutor();
    }
}

