/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.lamp.CommandHandler;
import com.artillexstudios.axminions.libs.lamp.annotation.Command;
import com.artillexstudios.axminions.libs.lamp.annotation.Default;
import com.artillexstudios.axminions.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axminions.libs.lamp.annotation.Description;
import com.artillexstudios.axminions.libs.lamp.annotation.Flag;
import com.artillexstudios.axminions.libs.lamp.annotation.SecretCommand;
import com.artillexstudios.axminions.libs.lamp.annotation.Single;
import com.artillexstudios.axminions.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axminions.libs.lamp.annotation.Switch;
import com.artillexstudios.axminions.libs.lamp.annotation.Usage;
import com.artillexstudios.axminions.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axminions.libs.lamp.command.CommandParameter;
import com.artillexstudios.axminions.libs.lamp.command.CommandPermission;
import com.artillexstudios.axminions.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axminions.libs.lamp.core.AnnotationReader;
import com.artillexstudios.axminions.libs.lamp.core.BaseCommandCategory;
import com.artillexstudios.axminions.libs.lamp.core.BaseCommandHandler;
import com.artillexstudios.axminions.libs.lamp.core.BaseCommandParameter;
import com.artillexstudios.axminions.libs.lamp.core.CommandExecutable;
import com.artillexstudios.axminions.libs.lamp.core.CommandPath;
import com.artillexstudios.axminions.libs.lamp.core.CompletionStageResponseHandler;
import com.artillexstudios.axminions.libs.lamp.core.OptionalResponseHandler;
import com.artillexstudios.axminions.libs.lamp.core.Resolver;
import com.artillexstudios.axminions.libs.lamp.core.SupplierResponseHandler;
import com.artillexstudios.axminions.libs.lamp.core.reflect.MethodCaller;
import com.artillexstudios.axminions.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axminions.libs.lamp.orphan.OrphanRegistry;
import com.artillexstudios.axminions.libs.lamp.process.PermissionReader;
import com.artillexstudios.axminions.libs.lamp.process.ResponseHandler;
import com.artillexstudios.axminions.libs.lamp.util.Collections;
import com.artillexstudios.axminions.libs.lamp.util.Preconditions;
import com.artillexstudios.axminions.libs.lamp.util.Primitives;
import com.artillexstudios.axminions.libs.lamp.util.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CommandParser {
    private static final char INHERIT_PARENT_PATH = '~';
    private static final String S_INHERIT_PARENT_PATH = "~";
    static final ResponseHandler<?> VOID_HANDLER = (response, actor, command) -> {};
    private static final AtomicInteger COMMAND_ID = new AtomicInteger();

    private CommandParser() {
    }

    public static void parse(@NotNull BaseCommandHandler handler, @NotNull OrphanRegistry orphan) {
        OrphanCommand instance = orphan.getHandler();
        Class<?> type = instance.getClass();
        CommandParser.parse(handler, type, orphan);
    }

    public static void parse(@NotNull BaseCommandHandler handler, @NotNull Object boundTarget) {
        Class<?> type = boundTarget instanceof Class ? (Class<?>)boundTarget : boundTarget.getClass();
        CommandParser.parse(handler, type, boundTarget);
    }

    public static void parse(@NotNull BaseCommandHandler handler, @NotNull Class<?> container, @NotNull Object boundTarget) {
        Map<CommandPath, BaseCommandCategory> categories = handler.categories;
        for (Method method : CommandParser.getAllMethods(container)) {
            AnnotationReader reader = AnnotationReader.create(handler, method);
            Object invokeTarget = boundTarget;
            if (reader.shouldDismiss()) continue;
            if (boundTarget instanceof OrphanRegistry) {
                CommandParser.insertCommandPath((OrphanRegistry)boundTarget, reader);
                invokeTarget = ((OrphanRegistry)invokeTarget).getHandler();
            }
            reader.distributeAnnotations();
            reader.replaceAnnotations(handler);
            List<CommandPath> paths = CommandParser.getCommandPath(container, method, reader);
            MethodCaller.BoundMethodCaller caller = handler.getMethodCallerFactory().createFor(method).bindTo(invokeTarget);
            int id = COMMAND_ID.getAndIncrement();
            String[] defPaths = reader.get(DefaultFor.class, DefaultFor::value);
            List<CommandPath> defaultPaths = defPaths == null ? java.util.Collections.emptyList() : CommandParser.parseDefaultPaths(defPaths, container, method, reader);
            boolean isDefault = !defaultPaths.isEmpty();
            for (CommandPath defaultPath : defaultPaths) {
                for (BaseCommandCategory category : CommandParser.generateCategoriesForPath(handler, true, defaultPath)) {
                    categories.putIfAbsent(category.path, category);
                }
            }
            paths.forEach(path -> {
                for (BaseCommandCategory category : CommandParser.generateCategoriesForPath(handler, isDefault, path)) {
                    categories.putIfAbsent(category.path, category);
                }
                HashSet<CommandPath> defaultPathsAndNormalPath = new HashSet<CommandPath>();
                defaultPathsAndNormalPath.add((CommandPath)path);
                defaultPathsAndNormalPath.addAll(defaultPaths);
                for (CommandPath p : defaultPathsAndNormalPath) {
                    boolean registerAsDefault = defaultPaths.contains(p);
                    CommandExecutable executable = new CommandExecutable();
                    if (!registerAsDefault) {
                        categories.remove(p);
                    }
                    executable.name = p.getLast();
                    executable.id = id;
                    executable.handler = handler;
                    executable.description = reader.get(Description.class, Description::value);
                    executable.path = p;
                    executable.method = method;
                    executable.reader = reader;
                    executable.secret = reader.contains(SecretCommand.class);
                    executable.methodCaller = caller;
                    if (registerAsDefault) {
                        executable.parent((BaseCommandCategory)categories.get(p), true);
                    } else {
                        executable.parent((BaseCommandCategory)categories.get(p.getCategoryPath()), false);
                    }
                    executable.responseHandler = CommandParser.getResponseHandler(handler, method.getGenericReturnType());
                    executable.parameters = CommandParser.getParameters(handler, method, executable);
                    executable.resolveableParameters = executable.parameters.stream().filter(c2 -> c2.getCommandIndex() != -1).collect(Collectors.toMap(CommandParameter::getCommandIndex, c2 -> c2));
                    executable.usage = reader.get(Usage.class, Usage::value, () -> CommandParser.generateUsage(executable));
                    if (registerAsDefault) continue;
                    CommandParser.putOrError(handler.executables, p, executable, "A command with path '" + p.toRealString() + "' already exists!");
                }
            });
        }
    }

    private static void insertCommandPath(OrphanRegistry boundTarget, AnnotationReader reader) {
        List<CommandPath> paths = boundTarget.getParentPaths();
        final String[] pathsArray = (String[])paths.stream().map(CommandPath::toRealString).toArray(String[]::new);
        reader.add(new Command(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return Command.class;
            }

            @Override
            public String[] value() {
                return pathsArray;
            }
        });
    }

    private static Set<Method> getAllMethods(Class<?> c2) {
        HashSet<Method> methods = new HashSet<Method>();
        for (Class<?> current = c2; current != null && current != Object.class; current = current.getSuperclass()) {
            java.util.Collections.addAll(methods, current.getDeclaredMethods());
        }
        return methods;
    }

    private static String generateUsage(@NotNull ExecutableCommand command) {
        StringJoiner joiner = new StringJoiner(" ");
        CommandHandler handler = command.getCommandHandler();
        for (CommandParameter parameter : command.getValueParameters().values()) {
            if (!parameter.getResolver().mutatesArguments()) continue;
            if (parameter.isSwitch()) {
                joiner.add("[" + handler.getSwitchPrefix() + parameter.getSwitchName() + "]");
                continue;
            }
            if (parameter.isFlag()) {
                joiner.add("[" + handler.getFlagPrefix() + parameter.getFlagName() + " <value>]");
                continue;
            }
            if (parameter.isOptional()) {
                joiner.add("[" + parameter.getName() + "]");
                continue;
            }
            joiner.add("<" + parameter.getName() + ">");
        }
        return joiner.toString();
    }

    @NotNull
    private static ResponseHandler<?> getResponseHandler(BaseCommandHandler handler, Type genericType) {
        Class<?> rawType = Primitives.getRawType(genericType);
        if (CompletionStage.class.isAssignableFrom(rawType)) {
            ResponseHandler<Object> delegateHandler = CommandParser.getResponseHandler(handler, CommandParser.getInsideGeneric(genericType));
            return new CompletionStageResponseHandler(handler, delegateHandler);
        }
        if (Optional.class.isAssignableFrom(rawType)) {
            ResponseHandler<Object> delegateHandler = CommandParser.getResponseHandler(handler, CommandParser.getInsideGeneric(genericType));
            return new OptionalResponseHandler(delegateHandler);
        }
        if (Supplier.class.isAssignableFrom(rawType)) {
            ResponseHandler<Object> delegateHandler = CommandParser.getResponseHandler(handler, CommandParser.getInsideGeneric(genericType));
            return new SupplierResponseHandler(delegateHandler);
        }
        return handler.responseHandlers.getFlexibleOrDefault(rawType, VOID_HANDLER);
    }

    private static Type getInsideGeneric(Type genericType) {
        try {
            return ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        catch (ClassCastException e) {
            return Object.class;
        }
    }

    private static Set<BaseCommandCategory> generateCategoriesForPath(CommandHandler handler, boolean isDefault, @NotNull CommandPath path) {
        if (path.size() == 1 && !isDefault) {
            return java.util.Collections.emptySet();
        }
        String parent = path.getParent();
        HashSet<BaseCommandCategory> categories = new HashSet<BaseCommandCategory>();
        BaseCommandCategory root = new BaseCommandCategory();
        root.handler = handler;
        root.path = CommandPath.get(parent);
        root.name = parent;
        categories.add(root);
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(parent);
        for (String subcommand : path.getSubcommandPath()) {
            pathList.add(subcommand);
            BaseCommandCategory cat = new BaseCommandCategory();
            cat.handler = handler;
            cat.path = CommandPath.get(pathList);
            cat.name = cat.path.getName();
            categories.add(cat);
        }
        return categories;
    }

    private static List<CommandParameter> getParameters(@NotNull BaseCommandHandler handler, @NotNull Method method, @NotNull CommandExecutable command) {
        ArrayList<BaseCommandParameter> parameters = new ArrayList<BaseCommandParameter>();
        Parameter[] methodParameters = method.getParameters();
        int cIndex = 0;
        for (int i = 0; i < methodParameters.length; ++i) {
            Parameter javaParameter = methodParameters[i];
            AnnotationReader paramAnns = AnnotationReader.create(handler, javaParameter);
            ArrayList validators = new ArrayList(handler.validators.getFlexibleOrDefault(javaParameter.getType(), java.util.Collections.emptyList()));
            String[] defaultValue = paramAnns.get(Default.class, Default::value);
            if (defaultValue == null || defaultValue.length == 0) {
                defaultValue = null;
            }
            BaseCommandParameter param = new BaseCommandParameter(paramAnns.get(Description.class, Description::value), i, defaultValue == null ? java.util.Collections.emptyList() : java.util.Collections.unmodifiableList(Arrays.asList(defaultValue)), i == methodParameters.length - 1 && !paramAnns.contains(Single.class), paramAnns.contains(com.artillexstudios.axminions.libs.lamp.annotation.Optional.class) || paramAnns.contains(Default.class), command, javaParameter, paramAnns.get(Switch.class), paramAnns.get(Flag.class), java.util.Collections.unmodifiableList(validators));
            String overriddenName = Strings.getOverriddenName(javaParameter);
            String string = param.name = overriddenName == null ? javaParameter.getName() : overriddenName;
            if (overriddenName == null) {
                overriddenName = handler.parameterNamingStrategy.getName(param);
                Objects.requireNonNull(overriddenName, "ParameterNamingStrategy.getName() returned null for parameter '" + javaParameter.getName() + "' in '" + method + "'!");
            }
            param.name = overriddenName;
            for (PermissionReader reader : handler.getPermissionReaders()) {
                CommandPermission permission = reader.getPermission(param);
                if (permission == null) continue;
                param.permission = permission;
                break;
            }
            if (param.isSwitch() && Primitives.wrap(param.getType()) != Boolean.class) {
                throw new IllegalStateException("Switch parameter " + javaParameter + " at " + method + " must be of boolean type!");
            }
            Resolver resolver = param.getType() == ArgumentStack.class ? new Resolver(context -> ArgumentStack.copyExact(context.input()), null) : handler.getResolver(param);
            if (resolver == null) {
                throw new IllegalStateException("Unable to find a resolver for parameter type " + javaParameter.getType());
            }
            param.resolver = resolver;
            if (resolver.mutatesArguments()) {
                param.cindex = cIndex++;
            }
            param.suggestionProvider = handler.autoCompleter.getProvider(param);
            parameters.add(param);
        }
        return java.util.Collections.unmodifiableList(parameters);
    }

    private static List<CommandPath> getCommandPath(@NotNull Class<?> container, @NotNull Method method, @NotNull AnnotationReader reader) {
        DefaultFor defaultFor = reader.get(DefaultFor.class);
        if (defaultFor != null) {
            return CommandParser.parseDefaultPaths(defaultFor.value(), container, method, reader);
        }
        return CommandParser.parseCommandAnnotations(container, method, reader);
    }

    @NotNull
    private static List<CommandPath> parseDefaultPaths(String[] path, @NotNull Class<?> container, @NotNull Method method, @NotNull AnnotationReader reader) {
        return Arrays.stream(path).flatMap(defaultPath -> {
            if (defaultPath.indexOf(126) != -1) {
                return CommandParser.parseCommandAnnotations(container, method, reader).stream().map(CommandPath::toRealString).map(v -> defaultPath.replace(S_INHERIT_PARENT_PATH, (CharSequence)v)).map(CommandPath::parse);
            }
            return Stream.of(CommandPath.parse(defaultPath));
        }).collect(Collectors.toList());
    }

    private static List<CommandPath> parseCommandAnnotations(@NotNull Class<?> container, @NotNull Method method, @NotNull AnnotationReader reader) {
        ArrayList<CommandPath> paths = new ArrayList<CommandPath>();
        ArrayList commands = new ArrayList();
        ArrayList subcommands = new ArrayList();
        Command commandAnnotation = reader.get(Command.class, "Method " + method.getName() + " does not have a parent command! You might have forgotten one of the following:\n- @Command on the method or class\n- implement OrphanCommand");
        Preconditions.notEmpty(commandAnnotation.value(), "@Command#value() cannot be an empty array!");
        java.util.Collections.addAll(commands, commandAnnotation.value());
        ArrayList parentSubcommandAliases = new ArrayList();
        for (Class<?> topClass : CommandParser.getTopClasses(container)) {
            Subcommand ps = topClass.getAnnotation(Subcommand.class);
            if (ps == null) continue;
            java.util.Collections.addAll(parentSubcommandAliases, ps.value());
        }
        Subcommand subcommandAnnotation = reader.get(Subcommand.class);
        if (subcommandAnnotation != null) {
            java.util.Collections.addAll(subcommands, subcommandAnnotation.value());
        }
        for (String command : commands) {
            if (!subcommands.isEmpty()) {
                for (String subcommand : subcommands) {
                    ArrayList<String> path = new ArrayList<String>(Strings.splitBySpace(command));
                    parentSubcommandAliases.forEach(subcommandAlias -> path.addAll(Strings.splitBySpace(subcommandAlias)));
                    path.addAll(Strings.splitBySpace(subcommand));
                    paths.add(CommandPath.get(path));
                }
                continue;
            }
            paths.add(CommandPath.parse(command));
        }
        return paths;
    }

    private static List<Class<?>> getTopClasses(Class<?> c2) {
        List<Class<?>> classes = Collections.listOf(c2);
        Class<?> enclosingClass = c2.getEnclosingClass();
        while (c2.getEnclosingClass() != null) {
            c2 = enclosingClass;
            classes.add(c2);
        }
        java.util.Collections.reverse(classes);
        return classes;
    }

    private static <K, V> void putOrError(Map<K, V> map, K key, V value, String err) {
        if (map.containsKey(key)) {
            throw new IllegalStateException(err);
        }
        map.put(key, value);
    }
}

