/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.annotations.Range;
import com.artillexstudios.axminions.libs.annotations.Unmodifiable;
import com.artillexstudios.axminions.libs.lamp.CommandHandler;
import com.artillexstudios.axminions.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axminions.libs.lamp.command.CommandActor;
import com.artillexstudios.axminions.libs.lamp.command.CommandCategory;
import com.artillexstudios.axminions.libs.lamp.command.CommandParameter;
import com.artillexstudios.axminions.libs.lamp.command.CommandPermission;
import com.artillexstudios.axminions.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axminions.libs.lamp.core.AnnotationReader;
import com.artillexstudios.axminions.libs.lamp.core.BaseCommandCategory;
import com.artillexstudios.axminions.libs.lamp.core.CommandParser;
import com.artillexstudios.axminions.libs.lamp.core.CommandPath;
import com.artillexstudios.axminions.libs.lamp.core.reflect.MethodCaller;
import com.artillexstudios.axminions.libs.lamp.process.ResponseHandler;
import com.artillexstudios.axminions.libs.lamp.util.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class CommandExecutable
implements ExecutableCommand {
    CommandHandler handler;
    boolean permissionSet = false;
    int id;
    CommandPath path;
    String name;
    String usage;
    String description;
    Method method;
    AnnotationReader reader;
    boolean secret;
    MethodCaller.BoundMethodCaller methodCaller;
    BaseCommandCategory parent;
    ResponseHandler responseHandler = CommandParser.VOID_HANDLER;
    private CommandPermission permission = CommandPermission.ALWAYS_TRUE;
    @Unmodifiable List<CommandParameter> parameters;
    @Unmodifiable Map<Integer, CommandParameter> resolveableParameters;

    CommandExecutable() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getUsage() {
        return this.usage;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public CommandPath getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public CommandCategory getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public @Unmodifiable List<CommandParameter> getParameters() {
        return this.parameters;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<Integer, CommandParameter> getValueParameters() {
        return this.resolveableParameters;
    }

    @Override
    @NotNull
    public CommandPermission getPermission() {
        return this.permission;
    }

    @Override
    @NotNull
    public CommandHandler getCommandHandler() {
        return this.handler;
    }

    @Override
    @NotNull
    public <T> ResponseHandler<T> getResponseHandler() {
        return this.responseHandler;
    }

    @Override
    public void execute(@NotNull CommandActor actor, @Nullable Collection<String> input) {
        Preconditions.notNull(actor, "actor");
        ArgumentStack arguments = ArgumentStack.copyExact(this.path.path);
        if (input != null) {
            arguments.addAll(input);
        }
        this.getCommandHandler().dispatch(actor, arguments);
    }

    @Override
    public void execute(@NotNull CommandActor actor, String ... input) {
        Preconditions.notNull(actor, "actor");
        ArgumentStack arguments = ArgumentStack.copyExact(this.path.path);
        if (input != null) {
            Collections.addAll(arguments, input);
        }
        this.getCommandHandler().dispatch(actor, arguments);
    }

    @Override
    public boolean isSecret() {
        return this.secret;
    }

    @Override
    public <A extends Annotation> A getAnnotation(@NotNull Class<A> annotation) {
        return this.reader.get(annotation);
    }

    @Override
    public boolean hasAnnotation(@NotNull Class<? extends Annotation> annotation) {
        return this.reader.contains(annotation);
    }

    public void parent(BaseCommandCategory cat, boolean isDefault) {
        this.parent = cat;
        if (cat != null) {
            if (isDefault) {
                if (cat.defaultAction != null && cat.defaultAction.method != this.method) {
                    throw new IllegalArgumentException("Category '" + cat.getPath().toRealString() + "' has more than one default action! (" + cat.defaultAction.method.toGenericString() + " and " + this.method.toGenericString() + ")");
                }
                cat.defaultAction = this;
            } else {
                cat.commands.put(this.path, this);
            }
        }
    }

    public void setPermission(@NotNull CommandPermission permission) {
        Preconditions.notNull(permission, "permission");
        this.permission = permission;
    }

    public String toString() {
        return "ExecutableCommand{path=" + this.path + ", name='" + this.name + '\'' + '}';
    }

    @Override
    public int compareTo(@NotNull ExecutableCommand o) {
        return this.path.compareTo(o.getPath());
    }
}

