/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.annotations.UnmodifiableView;
import com.artillexstudios.axminions.libs.lamp.CommandHandler;
import com.artillexstudios.axminions.libs.lamp.command.CommandActor;
import com.artillexstudios.axminions.libs.lamp.command.CommandCategory;
import com.artillexstudios.axminions.libs.lamp.command.CommandPermission;
import com.artillexstudios.axminions.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axminions.libs.lamp.core.CommandExecutable;
import com.artillexstudios.axminions.libs.lamp.core.CommandPath;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class BaseCommandCategory
implements CommandCategory {
    CommandPath path;
    String name;
    @Nullable
    BaseCommandCategory parent;
    @Nullable
    CommandExecutable defaultAction;
    CommandHandler handler;
    final Map<CommandPath, ExecutableCommand> commands = new HashMap<CommandPath, ExecutableCommand>();
    final Map<CommandPath, BaseCommandCategory> categories = new HashMap<CommandPath, BaseCommandCategory>();
    final CommandPermission permission = new CategoryPermission();
    private final Map<CommandPath, CommandCategory> unmodifiableCategories = Collections.unmodifiableMap(this.categories);
    private final Map<CommandPath, ExecutableCommand> unmodifiableCommands = Collections.unmodifiableMap(this.commands);

    BaseCommandCategory() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CommandPath getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public CommandHandler getCommandHandler() {
        return this.handler;
    }

    @Override
    @Nullable
    public CommandCategory getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public ExecutableCommand getDefaultAction() {
        return this.defaultAction;
    }

    @Override
    @NotNull
    public CommandPermission getPermission() {
        return this.permission;
    }

    @Override
    public boolean isSecret() {
        for (ExecutableCommand executableCommand : this.commands.values()) {
            if (executableCommand.isSecret()) continue;
            return false;
        }
        for (CommandCategory commandCategory : this.categories.values()) {
            if (commandCategory.isSecret()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.defaultAction == null && this.commands.isEmpty() && this.categories.isEmpty();
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<CommandPath, CommandCategory> getCategories() {
        return this.unmodifiableCategories;
    }

    @Override
    @NotNull
    public @UnmodifiableView Map<CommandPath, ExecutableCommand> getCommands() {
        return this.unmodifiableCommands;
    }

    public String toString() {
        return "CommandCategory{path=" + this.path + ", name='" + this.name + "'}";
    }

    public void parent(BaseCommandCategory cat) {
        this.parent = cat;
        if (cat != null) {
            cat.categories.put(this.path, this);
        }
    }

    @Override
    public int compareTo(@NotNull CommandCategory o) {
        return this.path.compareTo(o.getPath());
    }

    private class CategoryPermission
    implements CommandPermission {
        private CategoryPermission() {
        }

        @Override
        public boolean canExecute(@NotNull CommandActor actor) {
            for (ExecutableCommand executableCommand : BaseCommandCategory.this.commands.values()) {
                if (!executableCommand.getPermission().canExecute(actor)) continue;
                return true;
            }
            for (CommandCategory commandCategory : BaseCommandCategory.this.categories.values()) {
                if (!commandCategory.getPermission().canExecute(actor)) continue;
                return true;
            }
            if (BaseCommandCategory.this.defaultAction == null) {
                return false;
            }
            return BaseCommandCategory.this.defaultAction.hasPermission(actor);
        }
    }
}

