/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.bukkit.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.lamp.autocomplete.SuggestionProvider;
import com.artillexstudios.axminions.libs.lamp.autocomplete.SuggestionProviderFactory;
import com.artillexstudios.axminions.libs.lamp.bukkit.BukkitCommandActor;
import com.artillexstudios.axminions.libs.lamp.bukkit.EntitySelector;
import com.artillexstudios.axminions.libs.lamp.bukkit.core.BukkitHandler;
import com.artillexstudios.axminions.libs.lamp.bukkit.exception.InvalidPlayerException;
import com.artillexstudios.axminions.libs.lamp.bukkit.exception.MalformedEntitySelectorException;
import com.artillexstudios.axminions.libs.lamp.command.CommandActor;
import com.artillexstudios.axminions.libs.lamp.command.CommandParameter;
import com.artillexstudios.axminions.libs.lamp.exception.CommandErrorException;
import com.artillexstudios.axminions.libs.lamp.process.ValueResolver;
import com.artillexstudios.axminions.libs.lamp.process.ValueResolverFactory;
import com.artillexstudios.axminions.libs.lamp.util.Preconditions;
import com.artillexstudios.axminions.libs.lamp.util.Primitives;
import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public enum EntitySelectorResolver implements ValueResolverFactory
{
    INSTANCE;

    private boolean supportComplexSelectors;

    private EntitySelectorResolver() {
        try {
            Bukkit.getServer().selectEntities((CommandSender)Bukkit.getConsoleSender(), "@a");
            this.supportComplexSelectors = false;
        }
        catch (Throwable t) {
            this.supportComplexSelectors = false;
        }
    }

    @Override
    @Nullable
    public ValueResolver<?> create(@NotNull CommandParameter parameter) {
        if (EntitySelector.class.isAssignableFrom(parameter.getType())) {
            Class entityType = (Class)Primitives.getInsideGeneric(parameter.getFullType(), Entity.class);
            if (Player.class.isAssignableFrom(entityType)) {
                return this::resolvePlayerSelector;
            }
            return context -> {
                String selector = context.pop();
                try {
                    BukkitCommandActor actor = (BukkitCommandActor)context.actor();
                    ArrayList<Entity> c2 = new ArrayList<Entity>(Bukkit.getServer().selectEntities(actor.getSender(), selector));
                    c2.removeIf(obj -> !entityType.isInstance(obj));
                    return new EntitySelectorImpl(c2);
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedEntitySelectorException((CommandActor)context.actor(), selector, e.getCause().getMessage());
                }
                catch (NoSuchMethodError e) {
                    throw new CommandErrorException("Entity selectors on legacy versions are not supported yet!", new Object[0]);
                }
            };
        }
        return null;
    }

    private EntitySelector<Player> resolvePlayerSelector(ValueResolver.ValueResolverContext context) {
        String selector = context.pop().toLowerCase();
        try {
            BukkitCommandActor bActor = (BukkitCommandActor)context.actor();
            if (this.supportComplexSelectors) {
                List coll = Bukkit.getServer().selectEntities(bActor.getSender(), selector).stream().filter(c2 -> c2 instanceof Player).map(Player.class::cast).collect(Collectors.toList());
                return new EntitySelectorImpl<Player>(coll);
            }
            ArrayList<Player> coll = new ArrayList<Player>();
            Player[] players = Bukkit.getOnlinePlayers().toArray(new Player[0]);
            switch (selector) {
                case "@r": {
                    coll.add(players[ThreadLocalRandom.current().nextInt(players.length)]);
                    return new EntitySelectorImpl<Player>(coll);
                }
                case "@a": {
                    Collections.addAll(coll, players);
                    return new EntitySelectorImpl<Player>(coll);
                }
                case "@s": 
                case "@p": {
                    coll.add(bActor.requirePlayer());
                    return new EntitySelectorImpl<Player>(coll);
                }
            }
            Player player = Bukkit.getPlayer((String)selector);
            if (player == null) {
                throw new InvalidPlayerException(context.parameter(), selector);
            }
            coll.add(player);
            return new EntitySelectorImpl<Player>(coll);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedEntitySelectorException((CommandActor)context.actor(), selector, e.getCause().getMessage());
        }
    }

    public boolean supportsComplexSelectors() {
        return this.supportComplexSelectors;
    }

    public static enum SelectorSuggestionFactory implements SuggestionProviderFactory
    {
        INSTANCE;

        private boolean supportComplexSelectors;

        private SelectorSuggestionFactory() {
            try {
                Bukkit.getServer().selectEntities((CommandSender)Bukkit.getConsoleSender(), "@a");
                this.supportComplexSelectors = true;
            }
            catch (Throwable t) {
                this.supportComplexSelectors = false;
            }
        }

        @Override
        @Nullable
        public SuggestionProvider createSuggestionProvider(@NotNull CommandParameter parameter) {
            if (parameter.getType().isAssignableFrom(EntitySelector.class)) {
                Class<? extends Entity> type = BukkitHandler.getSelectedEntity(parameter.getFullType());
                if (Player.class.isAssignableFrom(type) && !this.supportComplexSelectors) {
                    return SuggestionProvider.of("@a", "@p", "@r", "@s").compose(parameter.getCommandHandler().getAutoCompleter().getSuggestionProvider("players"));
                }
                if (!INSTANCE.supportComplexSelectors) {
                    return SuggestionProvider.EMPTY;
                }
            }
            return null;
        }
    }

    private static class EntitySelectorImpl<E extends Entity>
    extends ForwardingList<E>
    implements EntitySelector<E> {
        private final List<E> entities;

        public EntitySelectorImpl(List<E> entities) {
            this.entities = entities;
        }

        protected List<E> delegate() {
            return this.entities;
        }

        @Override
        public boolean containsExactly(Entity ... entities) {
            Preconditions.notNull(entities, "entities");
            if (entities.length != this.entities.size()) {
                return false;
            }
            HashSet set = new HashSet(entities.length);
            Collections.addAll(set, entities);
            return set.containsAll(this.entities);
        }
    }
}

