/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.bukkit.core;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.lamp.bukkit.core.BukkitActor;
import com.artillexstudios.axminions.libs.lamp.bukkit.core.BukkitHandler;
import com.artillexstudios.axminions.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axminions.libs.lamp.command.CommandActor;
import com.artillexstudios.axminions.libs.lamp.exception.ArgumentParseException;
import com.artillexstudios.axminions.libs.lamp.util.Strings;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public final class BukkitCommandExecutor
implements TabExecutor {
    private final BukkitHandler handler;

    public BukkitCommandExecutor(BukkitHandler handler) {
        this.handler = handler;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        BukkitActor actor = new BukkitActor(sender, this.handler);
        try {
            ArgumentStack arguments = ArgumentStack.parse(args);
            arguments.addFirst(Strings.stripNamespace(command.getName()));
            this.handler.dispatch((CommandActor)actor, arguments);
        }
        catch (Throwable t) {
            this.handler.getExceptionHandler().handleException(t, actor);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        try {
            BukkitActor actor = new BukkitActor(sender, this.handler);
            ArgumentStack arguments = ArgumentStack.parseForAutoCompletion(args);
            arguments.addFirst(Strings.stripNamespace(command.getName()));
            return this.handler.getAutoCompleter().complete((CommandActor)actor, arguments);
        }
        catch (ArgumentParseException e) {
            return Collections.emptyList();
        }
    }
}

