/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axminions.libs.lamp.bukkit.brigadier.Commodore;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.lang.reflect.Method;
import org.bukkit.command.Command;
import org.bukkit.plugin.Plugin;

final class PaperLifecycleEvents
extends Commodore {
    private final RootCommandNode<CommandSourceStack> root = new RootCommandNode();
    private static final Method GET_LIFECYCLE_MANAGER;

    public PaperLifecycleEvents(@NotNull BukkitCommandHandler handler) {
        PaperLifecycleEvents.getLifecycleManager(handler.getPlugin()).registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            for (CommandNode node : this.root.getChildren()) {
                ((Commands)event.registrar()).register((LiteralCommandNode)node);
            }
        });
    }

    @Override
    void register(Command command, LiteralCommandNode<?> node) {
        this.root.addChild(node);
    }

    @Override
    void register(LiteralCommandNode<?> node) {
        this.root.addChild(node);
    }

    private static LifecycleEventManager<Plugin> getLifecycleManager(Plugin plugin) {
        if (GET_LIFECYCLE_MANAGER == null) {
            throw new IllegalArgumentException("getLifecycleManager is not available.");
        }
        return (LifecycleEventManager)GET_LIFECYCLE_MANAGER.invoke((Object)plugin, new Object[0]);
    }

    public static void ensureSetup() {
    }

    static {
        Method getLifecycleManager;
        try {
            getLifecycleManager = Plugin.class.getDeclaredMethod("getLifecycleManager", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            getLifecycleManager = null;
        }
        GET_LIFECYCLE_MANAGER = getLifecycleManager;
    }
}

