/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.lamp.autocomplete;

import com.artillexstudios.axminions.libs.annotations.Contract;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.lamp.command.CommandActor;
import com.artillexstudios.axminions.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axminions.libs.lamp.util.Collections;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public interface SuggestionProvider {
    public static final SuggestionProvider EMPTY = (args, sender, command) -> java.util.Collections.emptyList();

    @NotNull
    public Collection<String> getSuggestions(@NotNull List<String> var1, @NotNull CommandActor var2, @NotNull ExecutableCommand var3) throws Throwable;

    @Contract(value="null -> this; !null -> new")
    default public SuggestionProvider compose(@Nullable SuggestionProvider other) {
        if (other == null) {
            return this;
        }
        if (this == EMPTY && other == EMPTY) {
            return EMPTY;
        }
        if (other == EMPTY) {
            return this;
        }
        if (this == EMPTY) {
            return other;
        }
        return (args, sender, command) -> {
            HashSet<String> completions = new HashSet<String>(other.getSuggestions(args, sender, command));
            completions.addAll(this.getSuggestions(args, sender, command));
            return completions;
        };
    }

    public static SuggestionProvider of(@Nullable Collection<String> suggestions) {
        if (suggestions == null) {
            return EMPTY;
        }
        return (args, sender, command) -> suggestions;
    }

    public static SuggestionProvider of(String ... suggestions) {
        if (suggestions == null) {
            return EMPTY;
        }
        List<String> values = Collections.listOf(suggestions);
        return (args, sender, command) -> values;
    }

    public static SuggestionProvider of(@NotNull Supplier<Collection<String>> supplier) {
        return (args, sender, command) -> (Collection)supplier.get();
    }

    public static <T> SuggestionProvider map(@NotNull Supplier<Collection<T>> values, Function<T, String> function) {
        return (args, sender, command) -> ((Collection)values.get()).stream().map(function).collect(Collectors.toList());
    }
}

