/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.axapi.packet.wrapper.serverbound;

import com.artillexstudios.axminions.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axminions.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axminions.libs.axapi.packet.PacketType;
import com.artillexstudios.axminions.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axminions.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axminions.libs.axapi.utils.Version;
import com.artillexstudios.axminions.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axminions.libs.axapi.utils.logging.LogUtils;
import com.artillexstudios.axminions.libs.axapi.utils.position.BlockPosition;
import java.util.Arrays;

public final class ServerboundSignUpdateWrapper
extends PacketWrapper {
    private BlockPosition position;
    private boolean frontText;
    private String[] lines;

    public ServerboundSignUpdateWrapper(PacketEvent event) {
        super(event);
    }

    public BlockPosition position() {
        return this.position;
    }

    public void position(BlockPosition position) {
        this.position = position.immutable();
    }

    public boolean frontText() {
        return this.frontText;
    }

    public void frontText(boolean frontText) {
        this.frontText = frontText;
    }

    public String[] lines() {
        return this.lines;
    }

    public void lines(String[] lines) {
        this.lines = lines;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        out.writeBlockPos(this.position);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_1)) {
            out.writeBoolean(this.frontText);
        }
        for (int i = 0; i < 4; ++i) {
            out.writeUTF(this.lines[i]);
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.position = buf.readBlockPosition();
        this.frontText = Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_20_1) ? buf.readBoolean() : true;
        this.lines = new String[4];
        for (int i = 0; i < 4; ++i) {
            this.lines[i] = buf.readUTF(384);
        }
        if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
            LogUtils.debug("Read lines from sign: {}", (Object)Arrays.toString(this.lines));
        }
    }

    @Override
    public PacketType packetType() {
        return ServerboundPacketTypes.SIGN_UPDATE;
    }
}

