/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.axapi.packet;

import com.artillexstudios.axminions.libs.axapi.packet.PacketType;
import com.artillexstudios.axminions.libs.axapi.utils.Version;
import com.artillexstudios.axminions.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axminions.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;

public final class ServerboundPacketTypes {
    private static final Int2ObjectMap<PacketType> PACKET_TYPES = new Int2ObjectOpenHashMap();
    private static final Object2IntArrayMap<PacketType> REVERSE_PACKET_TYPES = new Object2IntArrayMap();
    public static final PacketType ACCEPT_TELEPORT = new PacketType("ACCEPT_TELEPORT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType BLOCK_ENTITY_TAG_QUERY = new PacketType("BLOCK_ENTITY_TAG_QUERY", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType BUNDLE_ITEM_SELECT = new PacketType("BUNDLE_ITEM_SELECT", Version.v1_21_2, Version.FUTURE_RELEASE);
    public static final PacketType CHANGE_DIFFICULTY = new PacketType("CHANGE_DIFFICULTY", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CHANGE_GAMEMODE = new PacketType("CHANGE_GAMEMODE", Version.v1_21_5, Version.FUTURE_RELEASE);
    public static final PacketType CHAT_ACK = new PacketType("CHAT_ACK", Version.v1_19, Version.FUTURE_RELEASE);
    public static final PacketType CHAT_COMMAND = new PacketType("CHAT_COMMAND", Version.v1_19, Version.FUTURE_RELEASE);
    public static final PacketType CHAT_COMMAND_SIGNED = new PacketType("CHAT_COMMAND_SIGNED", Version.v1_20_4, Version.FUTURE_RELEASE);
    public static final PacketType CHAT = new PacketType("CHAT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CHUNK_BATCH_RECEIVE = new PacketType("CHUNK_BATCH_RECEIVE", Version.v1_20_2, Version.FUTURE_RELEASE);
    public static final PacketType CHAT_PREVIEW = new PacketType("CHAT_PREVIEW", Version.v1_19, Version.v1_19);
    public static final PacketType COMMAND = new PacketType("COMMAND", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CLIENT_TICK_END = new PacketType("CLIENT_TICK_END", Version.v1_21_2, Version.FUTURE_RELEASE);
    public static final PacketType CLIENT_INFORMATION = new PacketType("CLIENT_INFORMATION", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType COMMAND_SUGGESTIONS = new PacketType("COMMAND_SUGGESTIONS", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CONFIGURATION_ACKNOWLEDGED = new PacketType("CONFIGURATION_ACKNOWLEDGED", Version.v1_20_2, Version.FUTURE_RELEASE);
    public static final PacketType CONTAINER_BUTTON_CLICK = new PacketType("CONTAINER_BUTTON_CLICK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CONTAINER_CLICK = new PacketType("CONTAINER_CLICK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CONTAINER_CLOSE = new PacketType("CONTAINER_CLOSE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CONTAINER_SLOT_STATE_CHANGED = new PacketType("CONTAINER_SLOT_STATE_CHANGED", Version.v1_20_3, Version.FUTURE_RELEASE);
    public static final PacketType COOKIE_RESPONSE = new PacketType("COOKIE_RESPONSE", Version.v1_20_4, Version.FUTURE_RELEASE);
    public static final PacketType CUSTOM_PAYLOAD = new PacketType("CUSTOM_PAYLOAD", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType DEBUG_SAMPLE_SUBSCRIPTION = new PacketType("DEBUG_SAMPLE_SUBSCRIPTION", Version.v1_20_4, Version.v1_21_6);
    public static final PacketType DEBUG_SUBSCRIPTION_REQUEST = new PacketType("DEBUG_SUBSCRIPTION_REQUEST", Version.v1_21_7, Version.FUTURE_RELEASE);
    public static final PacketType EDIT_BOOK = new PacketType("EDIT_BOOK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType ENTITY_TAG_QUERY = new PacketType("ENTITY_TAG_QUERY", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType INTERACT = new PacketType("INTERACT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType JIGSAW_GENERATE = new PacketType("JIGSAW_GENERATE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType KEEPALIVE = new PacketType("KEEPALIVE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType LOCK_DIFFICULTY = new PacketType("LOCK_DIFFICULTY", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType MOVE_PLAYER_POS = new PacketType("MOVE_PLAYER_POS", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType MOVE_PLAYER_POS_ROT = new PacketType("MOVE_PLAYER_POS_ROT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType MOVE_PLAYER_ROT = new PacketType("MOVE_PLAYER_ROT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType MOVE_PLAYER_STATUS = new PacketType("MOVE_PLAYER_STATUS", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType MOVE_VEHICLE = new PacketType("MOVE_VEHICLE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PADDLE_BOAT = new PacketType("PADDLE_BOAT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PICK_ITEM = new PacketType("PICK_ITEM", Version.v1_18, Version.v1_21_2);
    public static final PacketType PICK_ITEM_FROM_BLOCK = new PacketType("PICK_ITEM_FROM_BLOCK", Version.v1_21_3, Version.FUTURE_RELEASE);
    public static final PacketType PICK_ITEM_FROM_ENTITY = new PacketType("PICK_ITEM_FROM_ENTITY", Version.v1_21_3, Version.FUTURE_RELEASE);
    public static final PacketType PING_REQUEST = new PacketType("PING_REQUEST", Version.v1_20_2, Version.FUTURE_RELEASE);
    public static final PacketType PLACE_RECIPE = new PacketType("PLACE_RECIPE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PLAYER_ABILITIES = new PacketType("PLAYER_ABILITIES", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PLAYER_ACTION = new PacketType("PLAYER_ACTION", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PLAYER_COMMAND = new PacketType("PLAYER_COMMAND", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PLAYER_INPUT = new PacketType("PLAYER_INPUT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType PLAYER_LOADED = new PacketType("PLAYER_LOADED", Version.v1_21_3, Version.FUTURE_RELEASE);
    public static final PacketType PONG = new PacketType("PONG", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CHAT_SESSION_UPDATE = new PacketType("CHAT_SESSION_UPDATE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType RECIPE_BOOK_CHANGE_SETTINGS = new PacketType("RECIPE_BOOK_CHANGE_SETTINGS", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType RECIPE_BOOK_SEEN_RECIPE = new PacketType("RECIPE_BOOK_SEEN_RECIPE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType RENAME_ITEM = new PacketType("RENAME_ITEM", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType RESOURCE_PACK = new PacketType("RESOURCE_PACK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SEEN_ADVANCEMENTS = new PacketType("SEEN_ADVANCEMENTS", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SELECT_TRADE = new PacketType("SELECT_TRADE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_BEACON = new PacketType("SET_BEACON", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_CARRIED_ITEM = new PacketType("SET_CARRIED_ITEM", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_COMMAND_BLOCK = new PacketType("SET_COMMAND_BLOCK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_COMMAND_MINECART = new PacketType("SET_COMMAND_MINECART", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_CREATIVE_MODE_SLOT = new PacketType("SET_CREATIVE_MODE_SLOT", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_JIGSAW_BLOCK = new PacketType("SET_JIGSAW_BLOCK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_STRUCTURE_BLOCK = new PacketType("SET_STRUCTURE_BLOCK", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SET_TEST_BLOCK = new PacketType("SET_TEST_BLOCK", Version.v1_21_4, Version.FUTURE_RELEASE);
    public static final PacketType SIGN_UPDATE = new PacketType("SIGN_UPDATE", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType SWING = new PacketType("SWING", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType TELEPORT_TO_ENTITY = new PacketType("TELEPORT_TO_ENTITY", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType TEST_INSTANCE_BLOCK_ACTION = new PacketType("TEST_INSTANCE_BLOCK_ACTION", Version.v1_21_4, Version.FUTURE_RELEASE);
    public static final PacketType USE_ITEM_ON = new PacketType("USE_ITEM_ON", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType USE_ITEM = new PacketType("USE_ITEM", Version.v1_18, Version.FUTURE_RELEASE);
    public static final PacketType CUSTOM_CLICK_ACTION = new PacketType("CUSTOM_CLICK_ACTION", Version.v1_21_5, Version.FUTURE_RELEASE);

    public static void init() {
        ServerboundPacketTypes.register(ACCEPT_TELEPORT);
        ServerboundPacketTypes.register(BLOCK_ENTITY_TAG_QUERY);
        ServerboundPacketTypes.register(BUNDLE_ITEM_SELECT);
        ServerboundPacketTypes.register(CHANGE_DIFFICULTY);
        ServerboundPacketTypes.register(CHANGE_GAMEMODE);
        ServerboundPacketTypes.register(CHAT_ACK);
        ServerboundPacketTypes.register(CHAT_COMMAND);
        ServerboundPacketTypes.register(CHAT_COMMAND_SIGNED);
        ServerboundPacketTypes.register(CHAT);
        if (Version.getServerVersion().isNewerThanOrEqualTo(Version.v1_19_3)) {
            ServerboundPacketTypes.register(CHAT_SESSION_UPDATE);
        }
        ServerboundPacketTypes.register(CHUNK_BATCH_RECEIVE);
        ServerboundPacketTypes.register(CHAT_PREVIEW);
        ServerboundPacketTypes.register(COMMAND);
        ServerboundPacketTypes.register(CLIENT_TICK_END);
        ServerboundPacketTypes.register(CLIENT_INFORMATION);
        ServerboundPacketTypes.register(COMMAND_SUGGESTIONS);
        ServerboundPacketTypes.register(CONFIGURATION_ACKNOWLEDGED);
        ServerboundPacketTypes.register(CONTAINER_BUTTON_CLICK);
        ServerboundPacketTypes.register(CONTAINER_CLICK);
        ServerboundPacketTypes.register(CONTAINER_CLOSE);
        ServerboundPacketTypes.register(CONTAINER_SLOT_STATE_CHANGED);
        ServerboundPacketTypes.register(COOKIE_RESPONSE);
        ServerboundPacketTypes.register(CUSTOM_PAYLOAD);
        ServerboundPacketTypes.register(DEBUG_SAMPLE_SUBSCRIPTION);
        ServerboundPacketTypes.register(DEBUG_SUBSCRIPTION_REQUEST);
        ServerboundPacketTypes.register(EDIT_BOOK);
        ServerboundPacketTypes.register(ENTITY_TAG_QUERY);
        ServerboundPacketTypes.register(INTERACT);
        ServerboundPacketTypes.register(JIGSAW_GENERATE);
        ServerboundPacketTypes.register(KEEPALIVE);
        ServerboundPacketTypes.register(LOCK_DIFFICULTY);
        ServerboundPacketTypes.register(MOVE_PLAYER_POS);
        ServerboundPacketTypes.register(MOVE_PLAYER_POS_ROT);
        ServerboundPacketTypes.register(MOVE_PLAYER_ROT);
        ServerboundPacketTypes.register(MOVE_PLAYER_STATUS);
        ServerboundPacketTypes.register(MOVE_VEHICLE);
        ServerboundPacketTypes.register(PADDLE_BOAT);
        ServerboundPacketTypes.register(PICK_ITEM);
        ServerboundPacketTypes.register(PICK_ITEM_FROM_BLOCK);
        ServerboundPacketTypes.register(PICK_ITEM_FROM_ENTITY);
        ServerboundPacketTypes.register(PING_REQUEST);
        ServerboundPacketTypes.register(PLACE_RECIPE);
        ServerboundPacketTypes.register(PLAYER_ABILITIES);
        ServerboundPacketTypes.register(PLAYER_ACTION);
        ServerboundPacketTypes.register(PLAYER_COMMAND);
        ServerboundPacketTypes.register(PLAYER_INPUT);
        ServerboundPacketTypes.register(PLAYER_LOADED);
        ServerboundPacketTypes.register(PONG);
        if (Version.getServerVersion().isOlderThan(Version.v1_19_3)) {
            ServerboundPacketTypes.register(CHAT_SESSION_UPDATE);
        }
        ServerboundPacketTypes.register(RECIPE_BOOK_CHANGE_SETTINGS);
        ServerboundPacketTypes.register(RECIPE_BOOK_SEEN_RECIPE);
        ServerboundPacketTypes.register(RENAME_ITEM);
        ServerboundPacketTypes.register(RESOURCE_PACK);
        ServerboundPacketTypes.register(SEEN_ADVANCEMENTS);
        ServerboundPacketTypes.register(SELECT_TRADE);
        ServerboundPacketTypes.register(SET_BEACON);
        ServerboundPacketTypes.register(SET_CARRIED_ITEM);
        ServerboundPacketTypes.register(SET_COMMAND_BLOCK);
        ServerboundPacketTypes.register(SET_COMMAND_MINECART);
        ServerboundPacketTypes.register(SET_CREATIVE_MODE_SLOT);
        ServerboundPacketTypes.register(SET_JIGSAW_BLOCK);
        ServerboundPacketTypes.register(SET_STRUCTURE_BLOCK);
        ServerboundPacketTypes.register(SET_TEST_BLOCK);
        ServerboundPacketTypes.register(SIGN_UPDATE);
        ServerboundPacketTypes.register(SWING);
        ServerboundPacketTypes.register(TELEPORT_TO_ENTITY);
        ServerboundPacketTypes.register(TEST_INSTANCE_BLOCK_ACTION);
        ServerboundPacketTypes.register(USE_ITEM_ON);
        ServerboundPacketTypes.register(USE_ITEM);
        ServerboundPacketTypes.register(CUSTOM_CLICK_ACTION);
    }

    public static void register(PacketType packetType) {
        if (Version.getServerVersion().isNewerThanOrEqualTo(packetType.from()) && Version.getServerVersion().isOlderThanOrEqualTo(packetType.to())) {
            if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                LogUtils.debug("Registering serverbound packet: {}", (Object)packetType);
            }
            int size = PACKET_TYPES.size();
            PACKET_TYPES.put(size, (Object)packetType);
            REVERSE_PACKET_TYPES.put((Object)packetType, size);
        } else if (((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
            LogUtils.debug("Did not register serverbound packet: {}", (Object)packetType);
        }
    }

    public static PacketType forPacketId(int id) {
        return (PacketType)PACKET_TYPES.get(id);
    }

    public static int forPacketType(PacketType type) {
        return REVERSE_PACKET_TYPES.getOrDefault((Object)type, -1);
    }
}

