/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.axapi.metrics.collectors.implementation;

import com.artillexstudios.axminions.libs.axapi.metrics.collectors.MetricsCollector;
import com.artillexstudios.axminions.libs.axapi.utils.logging.LogUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Method;

public final class CPUModelMetricsCollector
implements MetricsCollector {
    private String cpuModel;

    public CPUModelMetricsCollector(Object systemInfo) {
        try {
            Method hardwareInfoGetter = Class.forName("oshi.SystemInfo").getDeclaredMethod("getHardware", new Class[0]);
            Object hardwareInfo = hardwareInfoGetter.invoke(systemInfo, new Object[0]);
            Method processorGetter = Class.forName("oshi.hardware.HardwareAbstractionLayer").getDeclaredMethod("getProcessor", new Class[0]);
            Object centralProcessingUnit = processorGetter.invoke(hardwareInfo, new Object[0]);
            Method processorIdentifierGetter = Class.forName("oshi.hardware.CentralProcessor").getDeclaredMethod("getProcessorIdentifier", new Class[0]);
            Object processorIdentifier = processorIdentifierGetter.invoke(centralProcessingUnit, new Object[0]);
            Method processorNameGetter = Class.forName("oshi.hardware.CentralProcessor$ProcessorIdentifier").getDeclaredMethod("getName", new Class[0]);
            Method vendorNameGetter = Class.forName("oshi.hardware.CentralProcessor$ProcessorIdentifier").getDeclaredMethod("getVendor", new Class[0]);
            this.cpuModel = String.valueOf(processorNameGetter.invoke(processorIdentifier, new Object[0])) + "|" + String.valueOf(vendorNameGetter.invoke(processorIdentifier, new Object[0]));
        }
        catch (Exception exception) {
            LogUtils.error("Failed to load CPU model!", new Object[0]);
        }
    }

    @Override
    public void collect(JsonArray data) {
        if (this.cpuModel == null) {
            return;
        }
        JsonObject object = new JsonObject();
        object.addProperty("@type", "cpu-model");
        object.addProperty("cpu-model", this.cpuModel);
        data.add((JsonElement)object);
    }
}

