/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.axapi.libs.yamlassist.types;

import com.artillexstudios.axminions.libs.axapi.libs.snakeyaml.error.YAMLException;
import com.artillexstudios.axminions.libs.axapi.libs.yamlassist.SyntaxError;
import com.artillexstudios.axminions.libs.axapi.libs.yamlassist.YamlAssist;
import com.artillexstudios.axminions.libs.axapi.libs.yamlassist.types.InvalidLine;
import java.util.ArrayList;
import java.util.List;

public class MissingQuote
extends SyntaxError {
    @Override
    public List<String> getSuggestions(YAMLException exception, List<String> fileLines) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int lineNumber = 1; lineNumber <= fileLines.size(); ++lineNumber) {
            String suggestion;
            String text = fileLines.get(lineNumber - 1);
            if (!YamlAssist.getError(InvalidLine.class).isLineValid(text) || this.removeIndent(text).startsWith("#") || (suggestion = this.checkElement(this.getValue(text), lineNumber)) == null) continue;
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private String checkElement(String value, int lineNumber) {
        String result = this.checkElement(value, lineNumber, "'");
        if (result != null) {
            return result;
        }
        result = this.checkElement(value, lineNumber, "\"");
        if (result != null) {
            return result;
        }
        return null;
    }

    private String checkElement(String value, int lineNumber, String c) {
        if (value.equals(c)) {
            return "Add " + c + " at the end of line " + lineNumber + " to finish empty value";
        }
        if (value.startsWith(c) && !value.endsWith(c)) {
            if (this.getCharCount(value, c.charAt(0)) == 2) {
                int i;
                for (i = value.length() - 2; i > 0 && value.charAt(i) != c.charAt(0); --i) {
                }
                if (i > 0) {
                    return "Remove extra text \"" + value.substring(i + 1) + "\" after ending " + c + " in line " + lineNumber;
                }
            }
            return "Add " + c + " at the end of line " + lineNumber;
        }
        if (value.endsWith(c) && !value.startsWith(c)) {
            return "Add " + c + " at the beginning of value at line " + lineNumber;
        }
        if (value.endsWith(c + c) && !value.equals(c + c)) {
            return "Remove one " + c + " from the end of line " + lineNumber;
        }
        return null;
    }

    private int getCharCount(String string, char c) {
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }
}

