/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.axapi.database;

import com.artillexstudios.axminions.libs.axapi.database.AsyncRunnableQuery;
import com.artillexstudios.axminions.libs.axapi.database.DatabaseHandler;
import com.artillexstudios.axminions.libs.axapi.database.ResultHandler;
import com.artillexstudios.axminions.libs.axapi.database.RunnableQuery;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class DatabaseQuery<T> {
    private final DatabaseHandler handler;
    private final ResultHandler<T> resultHandler;
    private final String sql;

    public DatabaseQuery(DatabaseHandler handler, ResultHandler<T> resultHandler, String sql) {
        this.handler = handler;
        this.resultHandler = resultHandler;
        this.sql = sql;
    }

    public void execute(Object ... parameters) {
        this.create().execute(parameters);
    }

    public RunnableQuery<T> create() {
        return new RunnableQuery<T>(this.handler::transformer, this.handler::connection, this.resultHandler, this.sql);
    }

    public AsyncRunnableQuery<T> createAsync() {
        return new AsyncRunnableQuery<T>(Executors::newVirtualThreadPerTaskExecutor, this.create());
    }

    public AsyncRunnableQuery<T> createAsync(ExecutorService service) {
        return new AsyncRunnableQuery<T>(() -> service, this.create());
    }

    public AsyncRunnableQuery<T> createAsync(Executor executor) {
        return new AsyncRunnableQuery<T>(() -> executor, this.create());
    }
}

