/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.libs.axapi.config.service.implementation;

import com.artillexstudios.axminions.libs.axapi.config.service.Writer;
import com.artillexstudios.axminions.libs.axapi.utils.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class FileCreator {
    private final Writer writer;

    public FileCreator(Writer writer) {
        this.writer = writer;
    }

    public boolean create(Path path, InputStream defaults) {
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                LogUtils.error("Failed to load file at {}! File is a directory!", path);
                try {
                    Files.delete(path);
                }
                catch (IOException exception) {
                    LogUtils.error("An unexpected error occurred while deleting directory which should have been a file!", exception);
                    return false;
                }
            }
        } else {
            try {
                if (defaults != null) {
                    this.writer.write(path, new String(defaults.readAllBytes(), StandardCharsets.UTF_8));
                } else {
                    this.writer.write(path, null);
                }
            }
            catch (IOException exception) {
                LogUtils.error("Failed to read bytes from defaults stream!", new Object[0]);
                return false;
            }
        }
        return true;
    }
}

