/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.integrations.stacker;

import com.artillexstudios.axminions.api.integrations.types.StackerIntegration;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.bgsoftware.wildstacker.api.WildStackerAPI;
import com.bgsoftware.wildstacker.api.objects.StackedEntity;
import com.bgsoftware.wildstacker.api.objects.StackedItem;
import kotlin.Metadata;
import org.bukkit.Location;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/artillexstudios/axminions/integrations/stacker/WildStackerIntegration;", "Lcom/artillexstudios/axminions/api/integrations/types/StackerIntegration;", "()V", "dropItemAt", "", "itemStack", "Lorg/bukkit/inventory/ItemStack;", "amount", "", "location", "Lorg/bukkit/Location;", "getStackSize", "", "item", "Lorg/bukkit/entity/Item;", "entity", "Lorg/bukkit/entity/LivingEntity;", "register", "setStackSize", "common"})
public final class WildStackerIntegration
implements StackerIntegration {
    @Override
    public long getStackSize(@NotNull LivingEntity entity) {
        StackedEntity stackedEntity = WildStackerAPI.getStackedEntity((LivingEntity)entity);
        return stackedEntity != null ? (long)stackedEntity.getStackAmount() : 1L;
    }

    @Override
    public long getStackSize(@NotNull Item item) {
        StackedItem stackedItem = WildStackerAPI.getStackedItem((Item)item);
        return stackedItem != null ? (long)stackedItem.getStackAmount() : 1L;
    }

    @Override
    public void setStackSize(@NotNull Item item, int amount) {
        StackedItem stackedItem = WildStackerAPI.getStackedItem((Item)item);
        if (stackedItem != null) {
            stackedItem.setStackAmount(amount, true);
        } else {
            item.getItemStack().setAmount(amount);
        }
    }

    @Override
    public void dropItemAt(@NotNull ItemStack itemStack, int amount, @NotNull Location location) {
        WildStackerAPI.getWildStacker().getSystemManager().spawnItemWithAmount(location, itemStack, amount);
    }

    @Override
    public void register() {
    }
}

