/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.integrations.economy;

import com.artillexstudios.axminions.api.integrations.types.EconomyIntegration;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/artillexstudios/axminions/integrations/economy/VaultIntegration;", "Lcom/artillexstudios/axminions/api/integrations/types/EconomyIntegration;", "()V", "economy", "Lnet/milkbowl/vault/economy/Economy;", "getBalance", "", "player", "Lorg/bukkit/OfflinePlayer;", "giveBalance", "", "amount", "register", "takeBalance", "common"})
public final class VaultIntegration
implements EconomyIntegration {
    private Economy economy;

    @Override
    public double getBalance(@NotNull OfflinePlayer player) {
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        return economy.getBalance(player);
    }

    @Override
    public void giveBalance(@NotNull OfflinePlayer player, double amount) {
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        economy.depositPlayer(player, amount);
    }

    @Override
    public void takeBalance(@NotNull OfflinePlayer player, double amount) {
        Economy economy = this.economy;
        if (economy == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"economy");
            economy = null;
        }
        economy.withdrawPlayer(player, amount);
    }

    @Override
    public void register() {
        RegisteredServiceProvider registeredServiceProvider = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return;
        }
        RegisteredServiceProvider rsp = registeredServiceProvider;
        this.economy = (Economy)rsp.getProvider();
    }
}

