/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.converter;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.minions.Direction;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.minions.miniontype.MinionTypes;
import com.artillexstudios.axminions.converter.Converter;
import com.artillexstudios.axminions.libs.axapi.serializers.Serializers;
import com.artillexstudios.axminions.libs.axapi.utils.StringUtils;
import com.artillexstudios.axminions.minions.Minion;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/artillexstudios/axminions/converter/LitMinionsConverter;", "Lcom/artillexstudios/axminions/converter/Converter;", "()V", "connection", "Ljava/sql/Connection;", "convert", "", "common"})
public final class LitMinionsConverter
implements Converter {
    private Connection connection;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convert() {
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("<#33FF33>[AxMinions-Converter] <white>Converting from <green>LitMinions...", new TagResolver[0]));
        String url = "jdbc:sqlite:plugins/LitMinions/minions.db";
        try {
            Connection connection = DriverManager.getConnection(url);
            if (connection == null) {
                return;
            }
            this.connection = connection;
        }
        catch (Exception exception) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("<#33FF33>[AxMinions-Converter] <#FF0000>FAILED! Database not found, or corrupted!", new TagResolver[0]));
            return;
        }
        int skipped = 0;
        int loaded = 0;
        Connection connection = this.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
            connection = null;
        }
        AutoCloseable autoCloseable = connection;
        Throwable throwable = null;
        try {
            Connection it = (Connection)autoCloseable;
            boolean bl = false;
            Connection connection2 = this.connection;
            if (connection2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"connection");
                connection2 = null;
            }
            AutoCloseable autoCloseable2 = connection2.prepareStatement("SELECT * FROM `minions_data`");
            Throwable throwable2 = null;
            try {
                PreparedStatement preparedStatement = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                AutoCloseable autoCloseable3 = preparedStatement.executeQuery();
                Throwable throwable3 = null;
                try {
                    ResultSet resultSet = (ResultSet)autoCloseable3;
                    boolean bl3 = false;
                    while (resultSet.next()) {
                        MinionType type;
                        Location location = Serializers.LOCATION.deserialize(resultSet.getString("minionworld") + ";" + resultSet.getString("minionx") + ";" + resultSet.getString("miniony") + ";" + resultSet.getString("minionz") + ";0;0");
                        String string = resultSet.getString("minionface").toUpperCase(Locale.ENGLISH);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                        Direction direction = Direction.valueOf(string);
                        int level = resultSet.getInt("level");
                        String string2 = resultSet.getString("miniontype").toLowerCase(Locale.ENGLISH);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        if (MinionTypes.valueOf(string2) == null) continue;
                        UUID uuid = UUID.fromString(resultSet.getString("owner"));
                        double storage = resultSet.getDouble("exp");
                        long statistics = resultSet.getLong("stat");
                        String chest = resultSet.getString("chestworld") + ";" + resultSet.getString("chestx") + ";" + resultSet.getString("chesty") + ";" + resultSet.getString("chestz") + ";0;0";
                        Location chestLocation = null;
                        if (resultSet.getString("chestworld") == null) {
                            chestLocation = Serializers.LOCATION.deserialize(chest);
                        }
                        if (location.getWorld() == null || chestLocation != null && chestLocation.getWorld() == null || AxMinionsPlugin.Companion.getDataHandler().isMinion(location)) {
                            ++skipped;
                            continue;
                        }
                        ++loaded;
                        int locationId = AxMinionsPlugin.Companion.getDataHandler().getLocationID(location);
                        int chestLocationId = chestLocation != null ? AxMinionsPlugin.Companion.getDataHandler().getLocationID(chestLocation) : 0;
                        Minion minion = new Minion(location, uuid, Bukkit.getOfflinePlayer((UUID)uuid), type, level, new ItemStack(Material.AIR), chestLocation, direction, statistics, storage, locationId, chestLocationId, 0L);
                        minion.setTicking(true);
                        AxMinionsPlugin.Companion.getDataHandler().saveMinion(minion);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("<#33FF33>[AxMinions-Converter] <white>Converting done! Loaded: " + loaded + " minion, skipped: " + skipped + " minion!", new TagResolver[0]));
    }
}

