/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.commands;

import com.artillexstudios.axminions.AxMinionsPlugin;
import com.artillexstudios.axminions.api.AxMinionsAPI;
import com.artillexstudios.axminions.api.config.Config;
import com.artillexstudios.axminions.api.config.Messages;
import com.artillexstudios.axminions.api.data.DataHandler;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.minions.miniontype.MinionType;
import com.artillexstudios.axminions.api.minions.miniontype.MinionTypes;
import com.artillexstudios.axminions.converter.LitMinionsConverter;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axminions.libs.axapi.utils.StringUtils;
import com.artillexstudios.axminions.libs.lamp.annotation.AutoComplete;
import com.artillexstudios.axminions.libs.lamp.annotation.Command;
import com.artillexstudios.axminions.libs.lamp.annotation.Default;
import com.artillexstudios.axminions.libs.lamp.annotation.Description;
import com.artillexstudios.axminions.libs.lamp.annotation.Range;
import com.artillexstudios.axminions.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axminions.libs.lamp.bukkit.annotation.CommandPermission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@Command(value={"axminions", "minion", "minions"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0007J*\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00062\b\b\u0001\u0010\u0012\u001a\u00020\nH\u0007J4\u0010\u0013\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\n2\b\b\u0001\u0010\u0012\u001a\u00020\nH\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u001b"}, d2={"Lcom/artillexstudios/axminions/commands/AxMinionsCommand;", "", "()V", "add", "", "player", "Lorg/bukkit/entity/Player;", "id", "", "charge", "", "convert", "sender", "Lorg/bukkit/command/CommandSender;", "extraSlot", "commandSender", "offlinePlayer", "Lorg/bukkit/OfflinePlayer;", "amount", "give", "receiver", "minionType", "Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "level", "reload", "reset", "stats", "common"})
@SourceDebugExtension(value={"SMAP\nAxMinionsCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxMinionsCommand.kt\ncom/artillexstudios/axminions/commands/AxMinionsCommand\n+ 2 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,150:1\n19#2,2:151\n21#2,2:154\n23#2:157\n11#2,6:158\n11#2,6:164\n11#2,6:170\n1855#3:153\n1856#3:156\n*S KotlinDebug\n*F\n+ 1 AxMinionsCommand.kt\ncom/artillexstudios/axminions/commands/AxMinionsCommand\n*L\n73#1:151,2\n73#1:154,2\n73#1:157\n77#1:158,6\n107#1:164,6\n129#1:170,6\n73#1:153\n73#1:156\n*E\n"})
public final class AxMinionsCommand {
    @Subcommand(value={"give"})
    @CommandPermission(value="axminions.command.give")
    @Description(value="Give a minion to a player")
    @AutoComplete(value="* @minionTypes * *")
    public final void give(@NotNull CommandSender sender, @NotNull Player receiver, @NotNull MinionType minionType, @Default(value={"1"}) int level, @Default(value={"1"}) @Range(min=1.0, max=64.0) int amount) {
        ItemStack item = MinionType.getItem$default(minionType, level, 0L, 0L, 6, null);
        item.setAmount(amount);
        ItemStack[] itemStackArray = new ItemStack[]{item};
        receiver.getInventory().addItem(itemStackArray);
    }

    @Subcommand(value={"fuel give"})
    @CommandPermission(value="axminions.command.fuel.give")
    public final void give(@NotNull CommandSender sender, @NotNull String id, @NotNull Player receiver, @Default(value={"1"}) int amount) {
        ItemStack item = ItemBuilder.create(Config.Companion.CHARGE_ITEMS().getSection(id)).get();
        item.setAmount(amount);
        ItemStack[] itemStackArray = new ItemStack[]{item};
        receiver.getInventory().addItem(itemStackArray);
    }

    @Subcommand(value={"fuel add"})
    @CommandPermission(value="axminions.command.fuel.add")
    public final void add(@NotNull Player player, @NotNull String id, int charge) {
        Map<Object, Object> item = ItemBuilder.create(player.getInventory().getItemInMainHand()).serialize(true);
        Integer n = charge;
        item.put("charge", n);
        AxMinionsPlugin.Companion.getConfig().getConfig().set("charge.items." + id, item);
        AxMinionsPlugin.Companion.getConfig().getConfig().save();
    }

    /*
     * WARNING - void declaration
     */
    @Subcommand(value={"reload"})
    @CommandPermission(value="axminions.command.reload")
    @Description(value="Reload the configurations of the plugin")
    public final void reload(@NotNull CommandSender sender) {
        int n;
        IntRange indices$iv;
        int i$iv;
        long start = System.currentTimeMillis();
        AxMinionsPlugin.Companion.getConfig().reload();
        AxMinionsPlugin.Companion.getMessages().reload();
        Object $this$fastFor$iv = MinionTypes.getMinionTypes();
        boolean $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty()) {
            Iterable $this$forEach$iv$iv = $this$fastFor$iv.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                void v;
                Map.Entry it$iv = (Map.Entry)element$iv$iv;
                boolean bl = false;
                MinionType minionType = (MinionType)it$iv.getValue();
                String cfr_ignored_0 = (String)it$iv.getKey();
                boolean bl2 = false;
                v.getConfig().reload();
            }
        }
        $this$fastFor$iv = AxMinionsAPI.Companion.getINSTANCE().getMinions();
        $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)((Collection)$this$fastFor$iv))).getFirst()) <= (n = indices$iv.getLast())) {
            while (true) {
                Minion it = (Minion)$this$fastFor$iv.get(i$iv);
                boolean bl = false;
                it.markDirty();
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        AxMinionsPlugin.Companion.getIntegrations().reload();
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("time", String.valueOf(System.currentTimeMillis() - start))};
        sender.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.RELOAD_SUCCESS(), tagResolverArray));
    }

    @Subcommand(value={"convert"})
    @CommandPermission(value="axminions.command.convert")
    @Description(value="Convert from a different plugin")
    public final void convert(@NotNull CommandSender sender) {
        LitMinionsConverter converter = new LitMinionsConverter();
        converter.convert();
    }

    @Subcommand(value={"stats", "statistics"})
    @CommandPermission(value="axminions.command.statistics")
    @Description(value="Get statistics of plugin")
    public final void stats(@NotNull CommandSender sender) {
        int n;
        IntRange indices$iv;
        int i$iv;
        List<Minion> minions = AxMinionsAPI.Companion.getINSTANCE().getMinions();
        int loaded = 0;
        int total = minions.size();
        List<Minion> $this$fastFor$iv = minions;
        boolean $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)$this$fastFor$iv)).getFirst()) <= (n = indices$iv.getLast())) {
            while (true) {
                Minion it = $this$fastFor$iv.get(i$iv);
                boolean bl = false;
                if (it.isTicking()) {
                    ++loaded;
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("ticking", String.valueOf(loaded)), Placeholder.unparsed("not-ticking", String.valueOf(total - loaded)), Placeholder.unparsed("total", String.valueOf(total))};
        sender.sendMessage(StringUtils.formatToString(Messages.Companion.STATISTICS(), tagResolverArray));
    }

    @Subcommand(value={"reset"})
    @CommandPermission(value="axminions.command.reset")
    public final void reset(@NotNull CommandSender sender, @NotNull OfflinePlayer offlinePlayer) {
        List<Minion> minions = AxMinionsAPI.Companion.getINSTANCE().getMinions();
        UUID ownerUUID = offlinePlayer.getUniqueId();
        AxMinionsPlugin.Companion.getDataQueue().submit(() -> AxMinionsCommand.reset$lambda$4(minions, sender, offlinePlayer, ownerUUID));
    }

    @Subcommand(value={"extraslot"})
    @CommandPermission(value="axminions.command.extraslot")
    public final void extraSlot(@NotNull CommandSender commandSender, @NotNull OfflinePlayer offlinePlayer, int amount) {
        AxMinionsPlugin.Companion.getDataQueue().submit(() -> AxMinionsCommand.extraSlot$lambda$5(offlinePlayer, amount, commandSender));
    }

    private static final void reset$lambda$4(List $minions, CommandSender $sender, OfflinePlayer $offlinePlayer, UUID $ownerUUID) {
        int n;
        IntRange indices$iv;
        int i$iv;
        List $this$fastFor$iv = $minions;
        boolean $i$f$fastFor = false;
        if (!$this$fastFor$iv.isEmpty() && (i$iv = (indices$iv = CollectionsKt.getIndices((Collection)$this$fastFor$iv)).getFirst()) <= (n = indices$iv.getLast())) {
            while (true) {
                Minion it = (Minion)$this$fastFor$iv.get(i$iv);
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getOwnerUUID(), (Object)$ownerUUID)) {
                    it.remove();
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        String string = Messages.Companion.PREFIX() + Messages.Companion.RESET();
        TagResolver[] tagResolverArray = new TagResolver[1];
        String string2 = $offlinePlayer.getName();
        if (string2 == null) {
            string2 = "---";
        }
        tagResolverArray[0] = Placeholder.unparsed("player", string2);
        $sender.sendMessage(StringUtils.formatToString(string, tagResolverArray));
    }

    private static final void extraSlot$lambda$5(OfflinePlayer $offlinePlayer, int $amount, CommandSender $commandSender) {
        block2: {
            int original = AxMinionsPlugin.Companion.getDataHandler().getExtraSlots($offlinePlayer.getUniqueId());
            DataHandler dataHandler = AxMinionsPlugin.Companion.getDataHandler();
            UUID uUID = $offlinePlayer.getUniqueId();
            String string = $offlinePlayer.getName();
            if (string == null) {
                string = "---";
            }
            dataHandler.addUser(uUID, string);
            AxMinionsPlugin.Companion.getDataHandler().addExtraSlot($offlinePlayer.getUniqueId(), $amount);
            String string2 = Messages.Companion.PREFIX() + Messages.Companion.SLOT_GIVE();
            TagResolver[] tagResolverArray = new TagResolver[2];
            String string3 = $offlinePlayer.getName();
            if (string3 == null) {
                string3 = "???";
            }
            tagResolverArray[0] = Placeholder.unparsed("player", string3);
            tagResolverArray[1] = Placeholder.unparsed("amount", String.valueOf($amount));
            $commandSender.sendMessage(StringUtils.formatToString(string2, tagResolverArray));
            Player player = $offlinePlayer.getPlayer();
            if (player == null) break block2;
            TagResolver[] tagResolverArray2 = new TagResolver[]{Placeholder.unparsed("amount", String.valueOf($amount)), Placeholder.unparsed("from", String.valueOf(original)), Placeholder.unparsed("to", String.valueOf(original + $amount))};
            player.sendMessage(StringUtils.formatToString(Messages.Companion.PREFIX() + Messages.Companion.SLOT_RECEIVE(), tagResolverArray2));
        }
    }
}

