/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.api.utils;

import com.artillexstudios.axminions.api.config.Config;
import com.artillexstudios.axminions.api.config.Messages;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/artillexstudios/axminions/api/utils/TimeUtils;", "", "()V", "format", "", "time", "", "api"})
public final class TimeUtils {
    @NotNull
    public static final TimeUtils INSTANCE = new TimeUtils();

    private TimeUtils() {
    }

    @NotNull
    public final String format(long time) {
        if (time < 0L) {
            return "---";
        }
        Duration remainingTime = Duration.ofMillis(time);
        long total = remainingTime.getSeconds();
        long days = total / (long)86400;
        long hours = total % (long)86400 / (long)3600;
        long minutes = total % (long)3600 / (long)60;
        long seconds = total % (long)60;
        switch (Config.Companion.TIMER_FORMAT()) {
            case 1: {
                if (days > 0L) {
                    String string = "%02d:%02d:%02d:%02d";
                    Object[] objectArray = new Object[]{days, hours, minutes, seconds};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
                if (hours > 0L) {
                    String string = "%02d:%02d:%02d";
                    Object[] objectArray = new Object[]{hours, minutes, seconds};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    return string3;
                }
                String string = "%02d:%02d";
                Object[] objectArray = new Object[]{minutes, seconds};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                return string4;
            }
            case 2: {
                if (days > 0L) {
                    return days + Messages.Companion.TIME_DAY();
                }
                if (hours > 0L) {
                    return hours + Messages.Companion.TIME_HOUR();
                }
                if (minutes > 0L) {
                    return minutes + Messages.Companion.TIME_MINUTE();
                }
                return seconds + Messages.Companion.TIME_SECOND();
            }
        }
        if (days > 0L) {
            Object[] objectArray = new Object[]{days, hours, minutes, seconds};
            return String.format("%02d" + Messages.Companion.TIME_DAY() + " %02d" + Messages.Companion.TIME_HOUR() + " %02d" + Messages.Companion.TIME_MINUTE() + " %02d" + Messages.Companion.TIME_SECOND(), objectArray);
        }
        if (hours > 0L) {
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            return String.format("%02d" + Messages.Companion.TIME_HOUR() + " %02d" + Messages.Companion.TIME_MINUTE() + " %02d" + Messages.Companion.TIME_SECOND(), objectArray);
        }
        Object[] objectArray = new Object[]{minutes, seconds};
        return String.format("%02d" + Messages.Companion.TIME_MINUTE() + " %02d" + Messages.Companion.TIME_SECOND(), objectArray);
    }
}

