/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.api.utils;

import com.artillexstudios.axminions.api.utils.RangesKt;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import java.util.ArrayList;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.math.MathKt;
import kotlin.ranges.ClosedRange;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ0\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00062\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/artillexstudios/axminions/api/utils/LocationUtils;", "", "()V", "getAllBlocksFacing", "Ljava/util/ArrayList;", "Lorg/bukkit/Location;", "Lkotlin/collections/ArrayList;", "location", "radius", "", "face", "Lorg/bukkit/block/BlockFace;", "getAllBlocksInRadius", "filterEmpty", "", "api"})
public final class LocationUtils {
    @NotNull
    public static final LocationUtils INSTANCE = new LocationUtils();

    private LocationUtils() {
    }

    @JvmStatic
    @NotNull
    public static final ArrayList<Location> getAllBlocksInRadius(@NotNull Location location, double radius, boolean filterEmpty) {
        ArrayList<Location> blocks = new ArrayList<Location>((int)((double)2 * radius * radius * radius));
        int blockX = location.getBlockX();
        int blockY = location.getBlockY();
        int blockZ = location.getBlockZ();
        Iterable<Double> rangeX = RangesKt.step((ClosedRange<Double>)((ClosedRange)kotlin.ranges.RangesKt.rangeTo((double)((double)blockX - radius), (double)((double)blockX + radius))), 1.0);
        Iterable<Double> rangeY = RangesKt.step((ClosedRange<Double>)((ClosedRange)kotlin.ranges.RangesKt.rangeTo((double)((double)blockY - radius), (double)((double)blockY + radius))), 1.0);
        Iterable<Double> rangeZ = RangesKt.step((ClosedRange<Double>)((ClosedRange)kotlin.ranges.RangesKt.rangeTo((double)((double)blockZ - radius), (double)((double)blockZ + radius))), 1.0);
        double radiusSquared = radius * radius;
        double smallRadiusSquared = (radius - 1.0) * (radius - 1.0);
        Iterator<Double> iterator = rangeX.iterator();
        while (iterator.hasNext()) {
            double x = ((Number)iterator.next()).doubleValue();
            Iterator<Double> iterator2 = rangeY.iterator();
            while (iterator2.hasNext()) {
                double y = ((Number)iterator2.next()).doubleValue();
                Iterator<Double> iterator3 = rangeZ.iterator();
                while (iterator3.hasNext()) {
                    double z = ((Number)iterator3.next()).doubleValue();
                    double distance = ((double)blockX - x) * ((double)blockX - x) + ((double)blockZ - z) * ((double)blockZ - z) + ((double)blockY - y) * ((double)blockY - y);
                    if (!(distance < radiusSquared) || filterEmpty && distance < smallRadiusSquared) continue;
                    blocks.add(new Location(location.getWorld(), x, y, z));
                }
            }
        }
        return blocks;
    }

    @NotNull
    public final ArrayList<Location> getAllBlocksFacing(@NotNull Location location, double radius, @NotNull BlockFace face) {
        ArrayList<Location> blocks = new ArrayList<Location>((int)radius);
        int modX = face.getModX();
        int modZ = face.getModZ();
        int i = 1;
        int n = MathKt.roundToInt((double)radius);
        if (i <= n) {
            while (true) {
                blocks.add(location.clone().add((double)i * (double)modX, 0.0, (double)i * (double)modZ));
                if (i == n) break;
                ++i;
            }
        }
        return blocks;
    }
}

