/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axminions.api.minions.miniontype;

import com.artillexstudios.axminions.api.AxMinionsAPI;
import com.artillexstudios.axminions.api.config.Config;
import com.artillexstudios.axminions.api.minions.Minion;
import com.artillexstudios.axminions.api.utils.Keys;
import com.artillexstudios.axminions.libs.annotations.NotNull;
import com.artillexstudios.axminions.libs.annotations.Nullable;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axminions.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axminions.libs.axapi.utils.ItemBuilder;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ=\u0010\u0012\u001a\u0004\u0018\u0001H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u0001H\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001b\u001a\u00020\u000bJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020!J\u0016\u0010#\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010$\u001a\u00020\u0003J\u0018\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010'\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020/2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u00101\u001a\u00020/2\u0006\u0010,\u001a\u00020-H&J\u0010\u00102\u001a\u00020\b2\u0006\u0010,\u001a\u00020-H\u0016J\u000e\u00103\u001a\u00020/2\u0006\u0010,\u001a\u00020-R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/artillexstudios/axminions/api/minions/miniontype/MinionType;", "", "name", "", "defaults", "Ljava/io/InputStream;", "(Ljava/lang/String;Ljava/io/InputStream;)V", "autoUpdateConfig", "", "(Ljava/lang/String;Ljava/io/InputStream;Z)V", "config", "Lcom/artillexstudios/axminions/libs/axapi/config/Config;", "faces", "", "Lorg/bukkit/block/BlockFace;", "getFaces", "()[Lorg/bukkit/block/BlockFace;", "[Lorg/bukkit/block/BlockFace;", "get", "T", "key", "level", "", "defaultValue", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;ILjava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "getConfig", "getDouble", "", "getItem", "Lorg/bukkit/inventory/ItemStack;", "actions", "", "charge", "getLong", "getName", "getSection", "Lcom/artillexstudios/axminions/libs/axapi/libs/boostedyaml/block/implementation/Section;", "getString", "hasChestOnSide", "block", "Lorg/bukkit/block/Block;", "hasReachedMaxLevel", "minion", "Lcom/artillexstudios/axminions/api/minions/Minion;", "load", "", "onToolDirty", "run", "shouldRun", "tick", "api"})
@SourceDebugExtension(value={"SMAP\nMinionType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MinionType.kt\ncom/artillexstudios/axminions/api/minions/miniontype/MinionType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Collections.kt\ncom/artillexstudios/axminions/api/utils/CollectionsKt\n*L\n1#1,141:1\n1855#2,2:142\n4#3,5:144\n*S KotlinDebug\n*F\n+ 1 MinionType.kt\ncom/artillexstudios/axminions/api/minions/miniontype/MinionType\n*L\n112#1:142,2\n130#1:144,5\n*E\n"})
public abstract class MinionType {
    @NotNull
    private final String name;
    @NotNull
    private final InputStream defaults;
    private final boolean autoUpdateConfig;
    @NotNull
    private final BlockFace[] faces;
    private com.artillexstudios.axminions.libs.axapi.config.Config config;

    public MinionType(@NotNull String name, @NotNull InputStream defaults, boolean autoUpdateConfig) {
        this.name = name;
        this.defaults = defaults;
        this.autoUpdateConfig = autoUpdateConfig;
        BlockFace[] blockFaceArray = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST};
        this.faces = blockFaceArray;
    }

    @NotNull
    public final BlockFace[] getFaces() {
        return this.faces;
    }

    public MinionType(@NotNull String name, @NotNull InputStream defaults) {
        this(name, defaults, false);
    }

    public final void load() {
        this.config = !this.autoUpdateConfig ? new com.artillexstudios.axminions.libs.axapi.config.Config(new File(AxMinionsAPI.Companion.getINSTANCE().getAxMinionsDataFolder(), "/minions/" + this.name + ".yml"), this.defaults, GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.DEFAULT, DumperSettings.DEFAULT, UpdaterSettings.DEFAULT) : new com.artillexstudios.axminions.libs.axapi.config.Config(new File(AxMinionsAPI.Companion.getINSTANCE().getAxMinionsDataFolder(), "/minions/" + this.name + ".yml"), this.defaults, GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setVersioning(new BasicVersioning("config-version")).build());
        AxMinionsAPI.Companion.getINSTANCE().getDataHandler().insertType(this);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public void onToolDirty(@NotNull Minion minion) {
    }

    public boolean shouldRun(@NotNull Minion minion) {
        return true;
    }

    public final void tick(@NotNull Minion minion) {
        if (!Config.Companion.WORK_WHEN_OWNER_OFFLINE() && !minion.isOwnerOnline()) {
            return;
        }
        if (!this.shouldRun(minion)) {
            return;
        }
        minion.resetAnimation();
        this.run(minion);
    }

    @NotNull
    public final ItemStack getItem(int level, long actions, long charge) {
        com.artillexstudios.axminions.libs.axapi.config.Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("level", String.valueOf(level)), Placeholder.unparsed("actions", String.valueOf(actions))};
        ItemBuilder builder = ItemBuilder.create(config.getSection("item"), tagResolverArray);
        ItemStack item = builder.clonedGet();
        ItemMeta itemMeta = item.getItemMeta();
        Intrinsics.checkNotNull((Object)itemMeta);
        ItemMeta meta = itemMeta;
        meta.getPersistentDataContainer().set(Keys.MINION_TYPE, PersistentDataType.STRING, (Object)this.name);
        meta.getPersistentDataContainer().set(Keys.LEVEL, PersistentDataType.INTEGER, (Object)level);
        meta.getPersistentDataContainer().set(Keys.STATISTICS, PersistentDataType.LONG, (Object)actions);
        meta.getPersistentDataContainer().set(Keys.CHARGE, PersistentDataType.LONG, (Object)charge);
        item.setItemMeta(meta);
        return item;
    }

    public static /* synthetic */ ItemStack getItem$default(MinionType minionType, int n, long l, long l2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getItem");
        }
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        return minionType.getItem(n, l, l2);
    }

    @NotNull
    public final com.artillexstudios.axminions.libs.axapi.config.Config getConfig() {
        com.artillexstudios.axminions.libs.axapi.config.Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        return config;
    }

    @NotNull
    public final String getString(@NotNull String key, int level) {
        String string = this.get(key, level, "---", String.class);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    public final double getDouble(@NotNull String key, int level) {
        Double d = this.get(key, level, 0.0, Double.TYPE);
        Intrinsics.checkNotNull((Object)d);
        return ((Number)d).doubleValue();
    }

    public final long getLong(@NotNull String key, int level) {
        Long l = this.get(key, level, 0L, Long.TYPE);
        Intrinsics.checkNotNull((Object)l);
        return ((Number)l).longValue();
    }

    @Nullable
    public final Section getSection(@NotNull String key, int level) {
        return this.get(key, level, null, Section.class);
    }

    private final <T> T get(String key, int level, T defaultValue, Class<T> clazz) {
        T n = null;
        n = defaultValue;
        com.artillexstudios.axminions.libs.axapi.config.Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        Iterable $this$forEach$iv = config.getSection("upgrades").getRoutesAsStrings(false);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (Integer.parseInt(it) > level) {
                return n;
            }
            com.artillexstudios.axminions.libs.axapi.config.Config config2 = this.config;
            if (config2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                config2 = null;
            }
            if (config2.getBackingDocument().getAsOptional("upgrades." + it + "." + key, clazz).isEmpty()) continue;
            com.artillexstudios.axminions.libs.axapi.config.Config config3 = this.config;
            if (config3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"config");
                config3 = null;
            }
            n = config3.get("upgrades." + it + "." + key);
        }
        return n;
    }

    public final boolean hasReachedMaxLevel(@NotNull Minion minion) {
        com.artillexstudios.axminions.libs.axapi.config.Config config = this.config;
        if (config == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            config = null;
        }
        return !config.getBackingDocument().isSection("upgrades." + (minion.getLevel() + 1));
    }

    public final boolean hasChestOnSide(@NotNull Block block) {
        int n;
        Object[] $this$fastFor$iv = this.faces;
        boolean $i$f$fastFor = false;
        IntRange indices$iv = ArraysKt.getIndices((Object[])$this$fastFor$iv);
        int i$iv = indices$iv.getFirst();
        if (i$iv <= (n = indices$iv.getLast())) {
            while (true) {
                Object it = $this$fastFor$iv[i$iv];
                boolean bl = false;
                if (block.getRelative((BlockFace)it).getType() == Material.CHEST) {
                    return true;
                }
                if (i$iv == n) break;
                ++i$iv;
            }
        }
        return false;
    }

    public abstract void run(@NotNull Minion var1);
}

