/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.commands.core;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import revxrsal.commands.autocomplete.SuggestionProvider;
import revxrsal.commands.autocomplete.SuggestionProviderFactory;
import revxrsal.commands.command.CommandParameter;

enum EnumSuggestionProviderFactory implements SuggestionProviderFactory
{
    INSTANCE;

    private static final int MAX_ENUMS_SIZE = 64;

    @Override
    @Nullable
    public SuggestionProvider createSuggestionProvider(@NotNull CommandParameter parameter) {
        if (!parameter.getType().isEnum()) {
            return null;
        }
        Class<Enum> enumType = parameter.getType().asSubclass(Enum.class);
        Enum[] enums = enumType.getEnumConstants();
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int i = 0; i < enums.length && i < 63; ++i) {
            suggestions.add(enums[i].name().toLowerCase());
        }
        return SuggestionProvider.of(suggestions);
    }
}

