/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.utils;

import com.artillexstudios.axmines.AxMinesPlugin;
import com.artillexstudios.axmines.mines.Mine;
import java.time.Duration;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/artillexstudios/axmines/utils/TimeUtils;", "", "()V", "format", "", "time", "", "mine", "Lcom/artillexstudios/axmines/mines/Mine;", "AxMines"})
public final class TimeUtils {
    @NotNull
    public static final TimeUtils INSTANCE = new TimeUtils();

    private TimeUtils() {
    }

    @NotNull
    public final String format(long time, @NotNull Mine mine) {
        if (time < 0L) {
            return "---";
        }
        Duration remainingTime = Duration.ofMillis(time);
        long total = remainingTime.getSeconds();
        long days = total / (long)86400;
        long hours = total % (long)86400 / (long)3600;
        long minutes = total % (long)3600 / (long)60;
        long seconds = total % (long)60;
        switch (mine.getConfig().TIMER_FORMAT) {
            case 1: {
                if (days > 0L) {
                    String string = "%02d:%02d:%02d:%02d";
                    Object[] objectArray = new Object[]{days, hours, minutes, seconds};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
                if (hours > 0L) {
                    String string = "%02d:%02d:%02d";
                    Object[] objectArray = new Object[]{hours, minutes, seconds};
                    String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    return string3;
                }
                String string = "%02d:%02d";
                Object[] objectArray = new Object[]{minutes, seconds};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
                return string4;
            }
            case 2: {
                if (days > 0L) {
                    return days + AxMinesPlugin.Companion.getMESSAGES().DAY;
                }
                if (hours > 0L) {
                    return hours + AxMinesPlugin.Companion.getMESSAGES().HOUR;
                }
                if (minutes > 0L) {
                    return minutes + AxMinesPlugin.Companion.getMESSAGES().MINUTE;
                }
                return seconds + AxMinesPlugin.Companion.getMESSAGES().SECOND;
            }
        }
        if (days > 0L) {
            Object[] objectArray = new Object[]{days, hours, minutes, seconds};
            return String.format("%02d" + AxMinesPlugin.Companion.getMESSAGES().DAY + " %02d" + AxMinesPlugin.Companion.getMESSAGES().HOUR + " %02d" + AxMinesPlugin.Companion.getMESSAGES().MINUTE + " %02d" + AxMinesPlugin.Companion.getMESSAGES().SECOND, objectArray);
        }
        if (hours > 0L) {
            Object[] objectArray = new Object[]{hours, minutes, seconds};
            return String.format("%02d" + AxMinesPlugin.Companion.getMESSAGES().HOUR + " %02d" + AxMinesPlugin.Companion.getMESSAGES().MINUTE + " %02d" + AxMinesPlugin.Companion.getMESSAGES().SECOND, objectArray);
        }
        Object[] objectArray = new Object[]{minutes, seconds};
        return String.format("%02d" + AxMinesPlugin.Companion.getMESSAGES().MINUTE + " %02d" + AxMinesPlugin.Companion.getMESSAGES().SECOND, objectArray);
    }
}

