/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.utils;

import com.artillexstudios.axmines.AxMinesPlugin;
import com.artillexstudios.axmines.libs.axapi.libs.yamlassist.YamlAssist;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ2\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/artillexstudios/axmines/utils/FileUtils;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "PLUGIN_DIRECTORY", "Ljava/nio/file/Path;", "copyFromResource", "", "path", "", "extractFile", "Ljava/io/File;", "clazz", "Ljava/lang/Class;", "filename", "copiedName", "outDir", "replace", "", "getSuggestions", "file", "logger", "AxMines"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    @NotNull
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    @JvmField
    @NotNull
    public static final Path PLUGIN_DIRECTORY = AxMinesPlugin.Companion.getINSTANCE().getDataFolder().toPath();

    private FileUtils() {
    }

    @JvmStatic
    public static final boolean getSuggestions(@NotNull File file, @NotNull Logger logger) {
        List<String> suggestions = YamlAssist.getSuggestions(file);
        if (suggestions.isEmpty()) {
            return true;
        }
        logger.error("Can't load yaml file: {}", (Object)file.toPath());
        logger.error("Possible solutions:");
        for (String suggestion : suggestions) {
            logger.error(" - {}", (Object)suggestion);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File extractFile(@NotNull Class<?> clazz, @NotNull String filename, @NotNull String copiedName, @NotNull Path outDir, boolean replace) {
        try {
            Closeable closeable = clazz.getResourceAsStream("/" + filename);
            Throwable throwable = null;
            try {
                InputStream in = (InputStream)closeable;
                boolean bl = false;
                if (in == null) {
                    Exception exception = new RuntimeException("Could not read file from jar! (" + filename + ")");
                    LOGGER.error("Could not find file {} in the plugin's assets!", (Object)filename, (Object)exception);
                    throw new RuntimeException(exception);
                }
                Path path = outDir.resolve(copiedName);
                if (!Files.exists(path, new LinkOption[0]) || replace) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(in, path, copyOptionArray);
                    File file = path.toFile();
                    return file;
                }
                File file = path.toFile();
                return file;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exception) {
            LOGGER.error("An unexpected error occurred while extracting file {} from plugin's assets!", (Object)filename, (Object)exception);
            throw new RuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void copyFromResource(@NotNull String path) {
        try {
            Closeable closeable = new ZipFile(((Object)((Object)AxMinesPlugin.Companion.getINSTANCE())).getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
            Throwable throwable = null;
            try {
                ZipFile zip = (ZipFile)closeable;
                boolean bl = false;
                Iterator<? extends ZipEntry> it = zip.entries().asIterator();
                while (it.hasNext()) {
                    ZipEntry entry = it.next();
                    if (!StringsKt.startsWith$default((String)entry.getName(), (String)(path + "/"), (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)entry.getName(), (String)".yaml", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)entry.getName(), (String)".yml", (boolean)false, (int)2, null)) continue;
                    InputStream resource = AxMinesPlugin.Companion.getINSTANCE().getResource(entry.getName());
                    if (resource == null) {
                        LOGGER.error("Could not find file {} in plugin's assets!", (Object)entry.getName());
                        continue;
                    }
                    Files.copy(resource, PLUGIN_DIRECTORY.resolve(entry.getName()), new CopyOption[0]);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exception) {
            LOGGER.error("An unexpected error occurred while extracting directory {} from plugin's assets!", (Object)path, (Object)exception);
        }
    }
}

