/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.selection;

import com.artillexstudios.axmines.AxMinesPlugin;
import com.artillexstudios.axmines.libs.axapi.serializers.Serializers;
import com.artillexstudios.axmines.libs.axapi.utils.StringUtils;
import com.artillexstudios.axmines.selection.Selection;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/artillexstudios/axmines/selection/SelectionWand;", "", "()V", "key", "Lorg/bukkit/NamespacedKey;", "selections", "Ljava/util/WeakHashMap;", "Lorg/bukkit/entity/Player;", "Lcom/artillexstudios/axmines/selection/Selection;", "getSelection", "player", "getWand", "Lorg/bukkit/inventory/ItemStack;", "isWand", "", "itemStack", "select", "", "location", "Lorg/bukkit/Location;", "first", "AxMines"})
public final class SelectionWand {
    @NotNull
    public static final SelectionWand INSTANCE = new SelectionWand();
    @NotNull
    private static final NamespacedKey key = new NamespacedKey((Plugin)AxMinesPlugin.Companion.getINSTANCE(), "selection_wand");
    @NotNull
    private static final WeakHashMap<Player, Selection> selections = new WeakHashMap();

    private SelectionWand() {
    }

    public final boolean isWand(@NotNull ItemStack itemStack) {
        if (itemStack.getType().isAir()) {
            return false;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return false;
        }
        ItemMeta meta = itemMeta;
        return meta.getPersistentDataContainer().has(key, PersistentDataType.BYTE);
    }

    @NotNull
    public final ItemStack getWand() {
        ItemStack item = new ItemStack(Material.GOLDEN_AXE);
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return item;
        }
        ItemMeta meta = itemMeta;
        meta.setDisplayName(StringUtils.formatToString("<#00AAFF><b>Selection wand", new TagResolver[0]));
        Object[] objectArray = new String[]{"", StringUtils.formatToString("<#00AAFF><b>Left click", new TagResolver[0]), StringUtils.formatToString(" <gray>- Select position #1", new TagResolver[0]), "", StringUtils.formatToString("<#00AAFF><b>Right click", new TagResolver[0]), StringUtils.formatToString(" <gray>- Select position #2", new TagResolver[0])};
        meta.setLore(CollectionsKt.listOf((Object[])objectArray));
        meta.addEnchant(Enchantment.ARROW_DAMAGE, 1, true);
        objectArray = new ItemFlag[]{ItemFlag.HIDE_ENCHANTS};
        meta.addItemFlags((ItemFlag[])objectArray);
        meta.getPersistentDataContainer().set(key, PersistentDataType.BYTE, (Object)0);
        item.setItemMeta(meta);
        return item;
    }

    public final void select(@NotNull Player player, @NotNull Location location, boolean first) {
        Selection selection;
        Selection selection2 = selections.get(player);
        if (selection2 == null) {
            selection2 = selection = new Selection(null, null, 3, null);
        }
        if (first) {
            if (Intrinsics.areEqual((Object)location, (Object)selection.getPosition1())) {
                return;
            }
            player.setCooldown(player.getInventory().getItemInMainHand().getType(), 5);
            selection.setPosition1(location);
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("location", Serializers.LOCATION.serialize(location))};
            player.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().SELECTION_POS1, tagResolverArray));
        } else {
            if (Intrinsics.areEqual((Object)location, (Object)selection.getPosition2())) {
                return;
            }
            player.setCooldown(player.getInventory().getItemInMainHand().getType(), 5);
            selection.setPosition2(location);
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("location", Serializers.LOCATION.serialize(location))};
            player.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().SELECTION_POS2, tagResolverArray));
        }
        ((Map)selections).put(player, selection);
    }

    @Nullable
    public final Selection getSelection(@NotNull Player player) {
        return selections.get(player);
    }
}

