/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.mines.editor;

import com.artillexstudios.axmines.AxMinesPlugin;
import com.artillexstudios.axmines.config.impl.MineConfig;
import com.artillexstudios.axmines.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axmines.libs.axapi.utils.StringUtils;
import com.artillexstudios.axmines.mines.Mine;
import com.artillexstudios.axmines.mines.editor.MineContentsEditor;
import com.artillexstudios.axmines.mines.editor.MineRewardsEditor;
import com.artillexstudios.axmines.mines.editor.MinesEditor;
import com.artillexstudios.axmines.utils.TimeUtils;
import dev.triumphteam.gui.builder.gui.SimpleBuilder;
import dev.triumphteam.gui.components.util.GuiFiller;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Material;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/artillexstudios/axmines/mines/editor/MineEditor;", "", "mine", "Lcom/artillexstudios/axmines/mines/Mine;", "player", "Lorg/bukkit/entity/Player;", "(Lcom/artillexstudios/axmines/mines/Mine;Lorg/bukkit/entity/Player;)V", "getMine", "()Lcom/artillexstudios/axmines/mines/Mine;", "getPlayer", "()Lorg/bukkit/entity/Player;", "open", "", "AxMines"})
public final class MineEditor {
    @NotNull
    private final Mine mine;
    @NotNull
    private final Player player;

    public MineEditor(@NotNull Mine mine, @NotNull Player player) {
        this.mine = mine;
        this.player = player;
    }

    @NotNull
    public final Mine getMine() {
        return this.mine;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final void open() {
        Gui gui = ((SimpleBuilder)((SimpleBuilder)((SimpleBuilder)Gui.gui().disableAllInteractions()).title((Component)MiniMessage.miniMessage().deserialize("<color:#00AAFF>Mines editor"))).rows(5)).create();
        new GuiFiller(gui).fillBorder(new GuiItem(new ItemStack(Material.GRAY_STAINED_GLASS_PANE)));
        gui.setItem(36, new GuiItem(ItemBuilder.create(Material.TIPPED_ARROW).setName("<color:#00AAFF>Go back").get(), arg_0 -> MineEditor.open$lambda$0(this, arg_0)));
        Object[] objectArray = new String[]{"", "<gray>> <color:#00AAFF>Current name: <white><name>", "", "<color:#00AAFF>Click to edit!"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new TagResolver[]{Placeholder.parsed("name", this.mine.getConfig().DISPLAY_NAME)};
        ItemStack displayName = ItemBuilder.create(new ItemStack(Material.NAME_TAG)).setName("<color:#00AAFF><bold>Display name").setLore((List<String>)list, (TagResolver[])objectArray).get();
        Object[] objectArray2 = new String[]{"", "<color:#00AAFF>Click to edit!"};
        ItemStack contents = ItemBuilder.create(new ItemStack(Material.EMERALD_BLOCK)).setName("<color:#00AAFF><bold>Contents").setLore(CollectionsKt.listOf((Object[])objectArray2)).get();
        Object[] objectArray3 = new String[]{"", "<gray>> <color:#00AAFF>Current value: <white><value>", "", " <gray>- <white>0: <color:#00AAFF>Top block at player's location", " <gray>- <white>1: <color:#00AAFF>Teleport location", " <gray>- <white>Other: <color:#00AAFF>No teleport", "", "<color:#00FF00>Left click to increase!", "<color:#FF0000>Right click to decrease!"};
        List list2 = CollectionsKt.listOf((Object[])objectArray3);
        objectArray3 = new TagResolver[]{Placeholder.unparsed("value", String.valueOf(this.mine.getConfig().TELEPORT_ON_RESET))};
        ItemStack teleportOnReset = ItemBuilder.create(new ItemStack(Material.ENDER_PEARL)).setName("<color:#00AAFF><bold>Teleport on reset").setLore((List<String>)list2, (TagResolver[])objectArray3).get();
        Object[] objectArray4 = new String[]{"", "<gray>> <color:#00AAFF>Current value: <white><value>", "", "<color:#00AAFF>Click to toggle!"};
        List list3 = CollectionsKt.listOf((Object[])objectArray4);
        objectArray4 = new TagResolver[]{Placeholder.unparsed("value", String.valueOf(this.mine.getConfig().ACTION_BAR_ENABLED))};
        ItemStack actionBarEnabled = ItemBuilder.create(new ItemStack(Material.STONE_BUTTON)).setName("<color:#00AAFF><bold>Action bar enabled").setLore((List<String>)list3, (TagResolver[])objectArray4).get();
        Object[] objectArray5 = new String[]{"", "<gray>> <color:#00AAFF>Current value: <white><value>", "", "<color:#00FF00>Left click to increase! (Shift for +10)", "<color:#FF0000>Right click to decrease! (Shift for -10)"};
        List list4 = CollectionsKt.listOf((Object[])objectArray5);
        objectArray5 = new TagResolver[]{Placeholder.unparsed("value", String.valueOf(this.mine.getConfig().ACTION_BAR_RANGE))};
        ItemStack actionBarRange = ItemBuilder.create(new ItemStack(Material.LEAD)).setName("<color:#00AAFF><bold>Action bar range").setLore((List<String>)list4, (TagResolver[])objectArray5).get();
        Object[] objectArray6 = new String[]{"", "<gray>> <color:#00AAFF>Current value: <white><value>", "", " <gray>- <white>0: <color:#00AAFF>Whole world", " <gray>- <white>-1: <color:#00AAFF>All worlds", " <gray>- <white>-2: <color:#00AAFF>Silent", " <gray>- <white>< -2: <color:#00AAFF>Same as not negative", " <gray>- <white>>= 1: <color:#00AAFF>broadcast in range", "", "<color:#00FF00>Left click to increase! (Shift for +10)", "<color:#FF0000>Right click to decrease! (Shift for -10)"};
        List list5 = CollectionsKt.listOf((Object[])objectArray6);
        objectArray6 = new TagResolver[]{Placeholder.unparsed("value", String.valueOf(this.mine.getConfig().BROADCAST_RESET))};
        ItemStack broadcastReset = ItemBuilder.create(new ItemStack(Material.OAK_BUTTON)).setName("<color:#00AAFF><bold>Broadcast reset").setLore((List<String>)list5, (TagResolver[])objectArray6).get();
        Object[] objectArray7 = new String[]{"", "<gray>> <color:#00AAFF>Current value: <white><value> ticks <gray>(<time> formatted)", "", "<gray>20 ticks = 1 second", "", "<color:#00AAFF>Click to edit"};
        List list6 = CollectionsKt.listOf((Object[])objectArray7);
        objectArray7 = new TagResolver[]{Placeholder.unparsed("value", String.valueOf(this.mine.getConfig().RESET_TICKS)), Placeholder.unparsed("time", TimeUtils.INSTANCE.format(this.mine.getConfig().RESET_TICKS / (long)20 * (long)1000, this.mine))};
        ItemStack resetTicks = ItemBuilder.create(new ItemStack(Material.CHEST)).setName("<color:#00AAFF><bold>Reset ticks").setLore((List<String>)list6, (TagResolver[])objectArray7).get();
        Object[] objectArray8 = new String[]{"", "<gray>> <color:#00AAFF>Current value: <white><value>%", "", "<color:#00FF00>Left click to increase! (Shift for +10)", "<color:#FF0000>Right click to decrease! (Shift for -10)"};
        List list7 = CollectionsKt.listOf((Object[])objectArray8);
        objectArray8 = new TagResolver[]{Placeholder.unparsed("value", String.valueOf(this.mine.getConfig().RESET_PERCENT))};
        ItemStack resetPercent = ItemBuilder.create(new ItemStack(Material.ANVIL)).setName("<color:#00AAFF><bold>Reset percent").setLore((List<String>)list7, (TagResolver[])objectArray8).get();
        Object[] objectArray9 = new String[]{"", "<color:#00AAFF>Click to edit!"};
        ItemStack rewards = ItemBuilder.create(new ItemStack(Material.CHEST)).setName("<color:#00AAFF><bold>Rewards").setLore(CollectionsKt.listOf((Object[])objectArray9)).get();
        objectArray9 = new GuiItem[]{new GuiItem(displayName, arg_0 -> MineEditor.open$lambda$1(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(contents, arg_0 -> MineEditor.open$lambda$2(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(teleportOnReset, arg_0 -> MineEditor.open$lambda$3(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(actionBarEnabled, arg_0 -> MineEditor.open$lambda$4(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(actionBarRange, arg_0 -> MineEditor.open$lambda$5(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(broadcastReset, arg_0 -> MineEditor.open$lambda$6(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(resetTicks, arg_0 -> MineEditor.open$lambda$7(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(resetPercent, arg_0 -> MineEditor.open$lambda$8(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        objectArray9 = new GuiItem[]{new GuiItem(rewards, arg_0 -> MineEditor.open$lambda$9(this, arg_0))};
        gui.addItem((GuiItem[])objectArray9);
        gui.setCloseGuiAction(arg_0 -> MineEditor.open$lambda$10(this, arg_0));
        gui.open((HumanEntity)this.player);
    }

    private static final void open$lambda$0(MineEditor this$0, InventoryClickEvent it) {
        new MinesEditor(this$0.player).open();
    }

    private static final void open$lambda$1(MineEditor this$0, InventoryClickEvent event) {
        event.getWhoClicked().closeInventory();
        ConversationFactory factory = new ConversationFactory((Plugin)AxMinesPlugin.Companion.getINSTANCE());
        StringPrompt prompt2 = new StringPrompt(this$0){
            final /* synthetic */ MineEditor this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext context) {
                return StringUtils.formatToString("<color:#00FF00>Please type the new displayname of this mine!", new TagResolver[0]);
            }

            @Nullable
            public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                if (input == null) {
                    return StringPrompt.END_OF_CONVERSATION;
                }
                this.this$0.getMine().getConfig().DISPLAY_NAME = input;
                this.this$0.getMine().getConfig().getConfig().set("display-name", this.this$0.getMine().getConfig().DISPLAY_NAME);
                this.this$0.open();
                return StringPrompt.END_OF_CONVERSATION;
            }

            @NotNull
            public Object clone() {
                return super.clone();
            }
        };
        factory.withFirstPrompt((Prompt)prompt2);
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull((Object)humanEntity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        factory.buildConversation((Conversable)((Player)humanEntity)).begin();
    }

    private static final void open$lambda$2(MineEditor this$0, InventoryClickEvent inventoryClickEvent) {
        new MineContentsEditor(this$0.mine, this$0.player).open();
    }

    private static final void open$lambda$3(MineEditor this$0, InventoryClickEvent event) {
        if (event.isLeftClick()) {
            MineConfig mineConfig = this$0.mine.getConfig();
            int n = mineConfig.TELEPORT_ON_RESET;
            mineConfig.TELEPORT_ON_RESET = n + 1;
        } else {
            MineConfig mineConfig = this$0.mine.getConfig();
            int n = mineConfig.TELEPORT_ON_RESET;
            mineConfig.TELEPORT_ON_RESET = n + -1;
        }
        this$0.mine.getConfig().getConfig().set("teleport-on-reset", this$0.mine.getConfig().TELEPORT_ON_RESET);
        this$0.open();
    }

    private static final void open$lambda$4(MineEditor this$0, InventoryClickEvent inventoryClickEvent) {
        this$0.mine.getConfig().ACTION_BAR_ENABLED = !this$0.mine.getConfig().ACTION_BAR_ENABLED;
        this$0.mine.getConfig().getConfig().set("actionbar.enabled", this$0.mine.getConfig().ACTION_BAR_ENABLED);
        this$0.open();
    }

    private static final void open$lambda$5(MineEditor this$0, InventoryClickEvent event) {
        if (event.isLeftClick()) {
            if (event.isShiftClick()) {
                MineConfig mineConfig = this$0.mine.getConfig();
                mineConfig.ACTION_BAR_RANGE += 10;
            } else {
                MineConfig mineConfig = this$0.mine.getConfig();
                int n = mineConfig.ACTION_BAR_RANGE;
                mineConfig.ACTION_BAR_RANGE = n + 1;
            }
        } else if (event.isShiftClick()) {
            MineConfig mineConfig = this$0.mine.getConfig();
            mineConfig.ACTION_BAR_RANGE -= 10;
        } else {
            MineConfig mineConfig = this$0.mine.getConfig();
            int n = mineConfig.ACTION_BAR_RANGE;
            mineConfig.ACTION_BAR_RANGE = n + -1;
        }
        this$0.mine.getConfig().getConfig().set("actionbar.range", this$0.mine.getConfig().ACTION_BAR_RANGE);
        this$0.open();
    }

    private static final void open$lambda$6(MineEditor this$0, InventoryClickEvent event) {
        if (event.isLeftClick()) {
            if (event.isShiftClick()) {
                MineConfig mineConfig = this$0.mine.getConfig();
                mineConfig.BROADCAST_RESET += 10;
            } else {
                MineConfig mineConfig = this$0.mine.getConfig();
                int n = mineConfig.BROADCAST_RESET;
                mineConfig.BROADCAST_RESET = n + 1;
            }
        } else if (event.isShiftClick()) {
            MineConfig mineConfig = this$0.mine.getConfig();
            mineConfig.BROADCAST_RESET -= 10;
        } else {
            MineConfig mineConfig = this$0.mine.getConfig();
            int n = mineConfig.BROADCAST_RESET;
            mineConfig.BROADCAST_RESET = n + -1;
        }
        this$0.mine.getConfig().getConfig().set("broadcast-reset", this$0.mine.getConfig().BROADCAST_RESET);
        this$0.open();
    }

    private static final void open$lambda$7(MineEditor this$0, InventoryClickEvent event) {
        event.getWhoClicked().closeInventory();
        ConversationFactory factory = new ConversationFactory((Plugin)AxMinesPlugin.Companion.getINSTANCE());
        StringPrompt prompt2 = new StringPrompt(this$0){
            final /* synthetic */ MineEditor this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public String getPromptText(@NotNull ConversationContext context) {
                return StringUtils.formatToString("<color:#00FF00>Please type how often the mine should reset in ticks! (1 second = 20 ticks)", new TagResolver[0]);
            }

            @Nullable
            public Prompt acceptInput(@NotNull ConversationContext context, @Nullable String input) {
                if (input == null) {
                    return StringPrompt.END_OF_CONVERSATION;
                }
                this.this$0.getMine().getConfig().RESET_TICKS = Long.parseLong(input);
                this.this$0.getMine().getConfig().getConfig().set("reset.ticks", this.this$0.getMine().getConfig().RESET_TICKS);
                this.this$0.open();
                return StringPrompt.END_OF_CONVERSATION;
            }

            @NotNull
            public Object clone() {
                return super.clone();
            }
        };
        factory.withFirstPrompt((Prompt)prompt2);
        HumanEntity humanEntity = event.getWhoClicked();
        Intrinsics.checkNotNull((Object)humanEntity, (String)"null cannot be cast to non-null type org.bukkit.entity.Player");
        factory.buildConversation((Conversable)((Player)humanEntity)).begin();
    }

    private static final void open$lambda$8(MineEditor this$0, InventoryClickEvent event) {
        if (event.isLeftClick()) {
            if (event.isShiftClick()) {
                MineConfig mineConfig = this$0.mine.getConfig();
                mineConfig.RESET_PERCENT += (double)10;
            } else {
                MineConfig mineConfig = this$0.mine.getConfig();
                double d = mineConfig.RESET_PERCENT;
                mineConfig.RESET_PERCENT = d + 1.0;
            }
        } else if (event.isShiftClick()) {
            MineConfig mineConfig = this$0.mine.getConfig();
            mineConfig.RESET_PERCENT -= (double)10;
        } else {
            MineConfig mineConfig = this$0.mine.getConfig();
            double d = mineConfig.RESET_PERCENT;
            mineConfig.RESET_PERCENT = d + -1.0;
        }
        this$0.mine.getConfig().getConfig().set("reset.percent", this$0.mine.getConfig().RESET_PERCENT);
        this$0.open();
    }

    private static final void open$lambda$9(MineEditor this$0, InventoryClickEvent it) {
        new MineRewardsEditor(this$0.mine, this$0.player).open();
    }

    private static final void open$lambda$10(MineEditor this$0, InventoryCloseEvent it) {
        this$0.mine.getConfig().getConfig().save();
        this$0.mine.reload(false);
    }
}

