/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.mines;

import com.artillexstudios.axmines.config.impl.Config;
import com.artillexstudios.axmines.config.impl.MineConfig;
import com.artillexstudios.axmines.libs.axapi.libs.math3.distribution.EnumeratedDistribution;
import com.artillexstudios.axmines.libs.axapi.libs.math3.random.RandomDataGenerator;
import com.artillexstudios.axmines.libs.axapi.libs.math3.util.Pair;
import com.artillexstudios.axmines.libs.axapi.scheduler.ScheduledTask;
import com.artillexstudios.axmines.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axmines.libs.axapi.selection.Cuboid;
import com.artillexstudios.axmines.libs.axapi.serializers.Serializers;
import com.artillexstudios.axmines.libs.axapi.utils.ActionBar;
import com.artillexstudios.axmines.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axmines.libs.axapi.utils.StringUtils;
import com.artillexstudios.axmines.mines.Mines;
import com.artillexstudios.axmines.mines.setter.BlockSetter;
import com.artillexstudios.axmines.mines.setter.BukkitBlockSetter;
import com.artillexstudios.axmines.mines.setter.FastBlockSetter;
import com.artillexstudios.axmines.mines.setter.ItemsAdderBukkitBlockSetter;
import com.artillexstudios.axmines.mines.setter.ItemsAdderFastBlockSetter;
import com.artillexstudios.axmines.mines.setter.OraxenBukkitBlockSetter;
import com.artillexstudios.axmines.mines.setter.OraxenFastBlockSetter;
import com.artillexstudios.axmines.utils.TimeUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\u0018\u0000 =2\u00020\u0001:\u0002=>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010-\u001a\u00020\u00052\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010/\u001a\u000200H\u0016J\u001e\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208J\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020$0:2\u0006\u00105\u001a\u000206J\u0010\u0010;\u001a\u0002022\b\b\u0002\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u0004\u001a\u0002022\b\b\u0002\u0010<\u001a\u00020\u0005J\u0006\u0010(\u001a\u000202R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\r\u00a8\u0006?"}, d2={"Lcom/artillexstudios/axmines/mines/Mine;", "", "file", "Ljava/io/File;", "reset", "", "(Ljava/io/File;Z)V", "actionBarTick", "", "<set-?>", "", "blocks", "getBlocks", "()D", "config", "Lcom/artillexstudios/axmines/config/impl/MineConfig;", "getConfig", "()Lcom/artillexstudios/axmines/config/impl/MineConfig;", "cuboid", "Lcom/artillexstudios/axmines/libs/axapi/selection/Cuboid;", "getCuboid", "()Lcom/artillexstudios/axapi/selection/Cuboid;", "setCuboid", "(Lcom/artillexstudios/axapi/selection/Cuboid;)V", "getFile", "()Ljava/io/File;", "name", "", "getName", "()Ljava/lang/String;", "placer", "Lcom/artillexstudios/axmines/mines/setter/BlockSetter;", "random", "Lcom/artillexstudios/axmines/libs/axapi/libs/math3/random/RandomDataGenerator;", "rewards", "Ljava/util/ArrayList;", "Lcom/artillexstudios/axmines/mines/Mine$Reward;", "Lkotlin/collections/ArrayList;", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tick", "getTick", "()J", "volume", "getVolume", "equals", "other", "hashCode", "", "onBlockBreak", "", "player", "Lorg/bukkit/entity/Player;", "block", "Lorg/bukkit/block/Block;", "event", "Lorg/bukkit/event/block/BlockBreakEvent;", "randomRewards", "", "reload", "silent", "Companion", "Reward", "AxMines"})
@SourceDebugExtension(value={"SMAP\nMine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mine.kt\ncom/artillexstudios/axmines/mines/Mine\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,476:1\n1855#2,2:477\n1855#2,2:479\n1855#2,2:481\n1855#2:485\n1855#2,2:486\n1855#2,2:488\n1856#2:490\n1855#2,2:497\n1855#2,2:499\n1855#2,2:501\n1855#2,2:503\n1855#2,2:505\n1855#2,2:507\n215#3,2:483\n215#3,2:491\n215#3,2:493\n215#3,2:495\n*S KotlinDebug\n*F\n+ 1 Mine.kt\ncom/artillexstudios/axmines/mines/Mine\n*L\n96#1:477,2\n125#1:479,2\n262#1:481,2\n319#1:485\n328#1:486,2\n336#1:488,2\n319#1:490\n163#1:497,2\n178#1:499,2\n188#1:501,2\n207#1:503,2\n233#1:505,2\n244#1:507,2\n307#1:483,2\n352#1:491,2\n376#1:493,2\n399#1:495,2\n*E\n"})
public final class Mine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File file;
    @NotNull
    private final String name;
    @NotNull
    private final MineConfig config;
    public Cuboid cuboid;
    private BlockSetter placer;
    private double volume;
    private double blocks;
    private long actionBarTick;
    private long tick;
    @NotNull
    private final ArrayList<Reward> rewards;
    @NotNull
    private final RandomDataGenerator random;
    @NotNull
    private final AtomicBoolean running;
    @NotNull
    private static final Logger LOGGER = LoggerFactory.getLogger(Mine.class);

    public Mine(@NotNull File file, boolean reset) {
        this.file = file;
        this.name = FilesKt.getNameWithoutExtension((File)this.file);
        this.config = new MineConfig("mines/" + this.file.getName());
        this.rewards = new ArrayList();
        this.random = new RandomDataGenerator();
        this.running = new AtomicBoolean(false);
        Mines.INSTANCE.register(this);
        this.reload(reset);
    }

    public /* synthetic */ Mine(File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(file, bl);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final MineConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final Cuboid getCuboid() {
        Cuboid cuboid = this.cuboid;
        if (cuboid != null) {
            return cuboid;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"cuboid");
        return null;
    }

    public final void setCuboid(@NotNull Cuboid cuboid) {
        this.cuboid = cuboid;
    }

    public final double getVolume() {
        return this.volume;
    }

    public final double getBlocks() {
        return this.blocks;
    }

    public final long getTick() {
        return this.tick;
    }

    public final void tick() {
        long l = this.tick;
        this.tick = l + 1L;
        l = this.actionBarTick;
        this.actionBarTick = l + 1L;
        if (this.tick >= this.config.RESET_TICKS) {
            Mine.reset$default(this, false, 1, null);
            this.tick = 0L;
        }
        if (this.config.ACTION_BAR_ENABLED && this.actionBarTick >= 10L) {
            this.actionBarTick = 0L;
            String string = this.config.ACTION_BAR;
            TagResolver[] tagResolverArray = new TagResolver[5];
            tagResolverArray[0] = Placeholder.parsed("notbroken", String.valueOf(this.blocks));
            tagResolverArray[1] = Placeholder.parsed("total", String.valueOf(this.volume));
            String string2 = "%.2f";
            Object[] objectArray = new Object[]{this.blocks / this.volume * 100.0};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            tagResolverArray[2] = Placeholder.parsed("percent", string3);
            string2 = "%.2f";
            objectArray = new Object[]{this.volume - this.blocks};
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            tagResolverArray[3] = Placeholder.parsed("blocksbroken", string4);
            tagResolverArray[4] = Placeholder.parsed("time", TimeUtils.INSTANCE.format((this.config.RESET_TICKS - this.tick) / (long)20 * (long)1000, this));
            Component formatted = StringUtils.format(string, tagResolverArray);
            ActionBar bar = new ActionBar(formatted);
            double x1 = this.getCuboid().getMaxX();
            double y1 = this.getCuboid().getMaxY();
            double z1 = this.getCuboid().getMaxZ();
            double x2 = this.getCuboid().getMinX();
            double y2 = this.getCuboid().getMinY();
            double z2 = this.getCuboid().getMinZ();
            Iterable $this$forEach$iv = this.getCuboid().getWorld().getPlayers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                Location location = it.getLocation();
                double x = location.getX();
                double y = location.getY();
                double z = location.getZ();
                double x0 = Math.min(x1, Math.max(x, x2));
                double y0 = Math.min(y1, Math.max(y, y2));
                double z0 = Math.min(z1, Math.max(z, z2));
                double distance = Math.pow(x - x0, 2.0) + Math.pow(y - y0, 2.0) + Math.pow(z - z0, 2.0);
                if (Config.DEBUG) {
                    LOGGER.info("Distance to " + this.name + " is " + distance + "!");
                }
                if (!(distance <= (double)(this.config.ACTION_BAR_RANGE * this.config.ACTION_BAR_RANGE))) continue;
                bar.send(it);
            }
        }
    }

    public final void onBlockBreak(@NotNull Player player, @NotNull Block block, @NotNull BlockBreakEvent event) {
        double d = this.blocks;
        this.blocks = d + -1.0;
        List<Reward> rewards = this.randomRewards(block);
        if (!((Collection)rewards).isEmpty()) {
            Iterable $this$forEach$iv = rewards;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Reward it = (Reward)element$iv;
                boolean bl = false;
                if (it.preventDrops()) {
                    event.setDropItems(false);
                }
                it.execute(player);
            }
        }
        double percent = this.blocks / this.volume * 100.0;
        if (Config.DEBUG) {
            LOGGER.info("A block was broken in mine " + this.name + "! Current percentage of not broken blocks: " + percent + " blocks: " + this.blocks + ", volume: " + this.volume);
        }
        if (percent < this.config.RESET_PERCENT) {
            Mine.reset$default(this, false, 1, null);
        }
    }

    public final void reset(boolean silent) {
        this.tick = 0L;
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        Ref.IntRef placed = new Ref.IntRef();
        long start = System.currentTimeMillis();
        BlockSetter blockSetter = this.placer;
        if (blockSetter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"placer");
            blockSetter = null;
        }
        blockSetter.fill(this.getCuboid(), arg_0 -> Mine.reset$lambda$9(placed, start, this, silent, arg_0));
    }

    public static /* synthetic */ void reset$default(Mine mine, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        mine.reset(bl);
    }

    @NotNull
    public final List<Reward> randomRewards(@NotNull Block block) {
        List list = new ArrayList();
        Iterable $this$forEach$iv = this.rewards;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Reward it = (Reward)element$iv;
            boolean bl = false;
            if (!it.test(block)) continue;
            double chance = it.chance() / (double)100;
            double random = this.random.nextUniform(0.0, 1.0);
            if (!(random <= chance)) continue;
            list.add(it);
        }
        return list;
    }

    public final void reload(boolean reset) {
        Map.Entry<Object, Object> entry;
        this.config.reload();
        Location corner1 = Serializers.LOCATION.deserialize(this.config.SELECTION_CORNER_1);
        Location corner2 = Serializers.LOCATION.deserialize(this.config.SELECTION_CORNER_2);
        if (corner1.getWorld() == null) {
            LOGGER.error("The world provided is null! Location: {}. Worlds: {}", (Object)this.config.SELECTION_CORNER_1, (Object)CollectionsKt.joinToString$default((Iterable)Bukkit.getWorlds(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            return;
        }
        this.setCuboid(new Cuboid(corner1.getWorld(), corner1.getBlockX(), corner2.getBlockX(), corner1.getBlockZ(), corner2.getBlockZ(), corner1.getBlockY(), corner2.getBlockY()));
        if (Config.DEBUG) {
            LOGGER.info("Reloaded config! " + corner1 + " " + corner2);
        }
        boolean oraxen = false;
        boolean itemsAdder = false;
        Mine $this$reload_u24lambda_u2412 = this;
        boolean bl = false;
        Map<Object, Object> $this$forEach$iv = $this$reload_u24lambda_u2412.config.CONTENTS;
        boolean $i$f$forEach = false;
        Map.Entry<Object, Object> entry2 = $this$forEach$iv.entrySet().iterator();
        while (entry2.hasNext()) {
            Map.Entry<Object, Object> element$iv;
            entry = element$iv = entry2.next();
            boolean bl2 = false;
            Object k = entry.getKey();
            if (StringsKt.contains((CharSequence)k.toString(), (CharSequence)"oraxen", (boolean)true)) {
                oraxen = true;
                break;
            }
            if (!StringsKt.contains((CharSequence)k.toString(), (CharSequence)"itemsadder", (boolean)true)) continue;
            itemsAdder = true;
            break;
        }
        this.rewards.clear();
        Iterable $this$forEach$iv2 = this.config.RANDOM_REWARDS;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Object v;
            List commands;
            List items;
            List blockTypes;
            Map it = (Map)element$iv;
            boolean bl3 = false;
            Object chance = it.get("chance");
            if (chance == null || !(chance instanceof Number)) {
                LOGGER.error("An error occurred while loading reward! No chance set!");
                continue;
            }
            Object object = it.get("blocks");
            if (object == null) {
                object = CollectionsKt.emptyList();
            }
            if (((entry = object) instanceof List ? (List)((Object)entry) : null) == null) continue;
            blockTypes = blockTypes;
            List blocks = new ArrayList();
            Iterable $this$forEach$iv3 = blockTypes;
            boolean $i$f$forEach3 = false;
            Iterator<Object> iterator = $this$forEach$iv3.iterator();
            while (iterator.hasNext()) {
                Material material;
                Object element$iv2 = iterator.next();
                String type = (String)element$iv2;
                boolean bl4 = false;
                String string = type.toUpperCase(Locale.ENGLISH);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                if (Material.matchMaterial((String)string) == null) continue;
                blocks.add(material);
            }
            Object object2 = it.get("items");
            if (object2 == null) {
                object2 = CollectionsKt.emptyList();
            }
            if (((iterator = object2) instanceof List ? (List)((Object)iterator) : null) == null) continue;
            items = items;
            List itemStacks = new ArrayList();
            Iterable $this$forEach$iv4 = items;
            boolean $i$f$forEach4 = false;
            Iterator<Object> iterator2 = $this$forEach$iv4.iterator();
            while (iterator2.hasNext()) {
                Object element$iv3 = iterator2.next();
                HashMap map = (HashMap)element$iv3;
                boolean bl5 = false;
                itemStacks.add(ItemBuilder.create(map).get());
            }
            Object object3 = it.get("commands");
            if (object3 == null) {
                object3 = CollectionsKt.emptyList();
            }
            if (((iterator2 = object3) instanceof List ? (List)((Object)iterator2) : null) == null) continue;
            commands = commands;
            if (Config.DEBUG) {
                LOGGER.info("Added new reward!");
            }
            Boolean bl6 = (v = it.get("prevent-drops")) instanceof Boolean ? (Boolean)v : null;
            boolean preventDrops = bl6 != null ? bl6 : false;
            this.rewards.add(new Reward(((Number)chance).doubleValue(), commands, itemStacks, blocks, preventDrops));
        }
        if (oraxen) {
            list = new ArrayList<Pair>(this.config.CONTENTS.size());
            $this$forEach$iv = this.config.CONTENTS;
            boolean $i$f$forEach22 = false;
            var9_17 = $this$forEach$iv.entrySet().iterator();
            while (var9_17.hasNext()) {
                Map.Entry<Object, Object> element$iv;
                entry2 = element$iv = var9_17.next();
                boolean bl7 = false;
                k = entry2.getKey();
                Object v = entry2.getValue();
                Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
                if (number == null) {
                    continue;
                }
                list.add(Pair.create((Object)k.toString(), (Object)number.doubleValue()));
            }
            if (list.isEmpty()) {
                LOGGER.error("No blocks set up!");
                return;
            }
            distribution = new EnumeratedDistribution((List)list);
            String string = this.config.SETTER.toLowerCase(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $i$f$forEach22 = string;
            this.placer = Intrinsics.areEqual((Object)$i$f$forEach22, (Object)"parallel") ? (BlockSetter)new OraxenFastBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<String>)distribution) : (Intrinsics.areEqual((Object)$i$f$forEach22, (Object)"fast") ? (BlockSetter)new OraxenFastBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<String>)distribution) : (BlockSetter)new OraxenBukkitBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<String>)distribution));
        } else if (itemsAdder) {
            list = new ArrayList(this.config.CONTENTS.size());
            $this$forEach$iv = this.config.CONTENTS;
            boolean $i$f$forEach5 = false;
            var9_17 = $this$forEach$iv.entrySet().iterator();
            while (var9_17.hasNext()) {
                Map.Entry<Object, Object> element$iv;
                entry2 = element$iv = var9_17.next();
                boolean bl8 = false;
                k = entry2.getKey();
                Object v = entry2.getValue();
                Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
                if (number == null) {
                    continue;
                }
                list.add(Pair.create((Object)k.toString(), (Object)number.doubleValue()));
            }
            if (list.isEmpty()) {
                LOGGER.error("No blocks set up!");
                return;
            }
            distribution = new EnumeratedDistribution((List)list);
            String string = this.config.SETTER.toLowerCase(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $i$f$forEach22 = string;
            this.placer = (Intrinsics.areEqual((Object)$i$f$forEach22, (Object)"parallel") ? true : Intrinsics.areEqual((Object)$i$f$forEach22, (Object)"fast")) ? (BlockSetter)new ItemsAdderFastBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<String>)distribution) : (BlockSetter)new ItemsAdderBukkitBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<String>)distribution);
        } else {
            list = new ArrayList(this.config.CONTENTS.size());
            $this$forEach$iv = this.config.CONTENTS;
            boolean $i$f$forEach6 = false;
            var9_17 = $this$forEach$iv.entrySet().iterator();
            while (var9_17.hasNext()) {
                Map.Entry<Object, Object> element$iv;
                entry2 = element$iv = var9_17.next();
                boolean bl9 = false;
                k = entry2.getKey();
                Object v = entry2.getValue();
                String string = k.toString().toUpperCase(Locale.ENGLISH);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                Material material = Material.matchMaterial((String)string);
                if (material == null || (material = material.createBlockData()) == null) continue;
                Number number = v instanceof Number ? (Number)((Number)v) : (Number)null;
                if (number == null) {
                    continue;
                }
                list.add(Pair.create((Object)material, (Object)number.doubleValue()));
            }
            if (list.isEmpty()) {
                LOGGER.error("No blocks set up!");
                return;
            }
            distribution = new EnumeratedDistribution((List)list);
            String string = this.config.SETTER.toLowerCase(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            $i$f$forEach22 = string;
            this.placer = (Intrinsics.areEqual((Object)$i$f$forEach22, (Object)"parallel") ? true : Intrinsics.areEqual((Object)$i$f$forEach22, (Object)"fast")) ? (BlockSetter)new FastBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<BlockData>)distribution) : (BlockSetter)new BukkitBlockSetter(this.getCuboid().getWorld(), (EnumeratedDistribution<BlockData>)distribution);
        }
        int width = Math.abs(this.getCuboid().getMaxX() - this.getCuboid().getMinX()) + 1;
        int length = Math.abs(this.getCuboid().getMaxZ() - this.getCuboid().getMinZ()) + 1;
        int height = Math.abs(this.getCuboid().getMaxY() - this.getCuboid().getMinY()) + 1;
        this.volume = width * length * height;
        if (Config.DEBUG) {
            LOGGER.info("Mine volume: " + this.volume + ". Width: " + width + ", length: " + length + ", height: " + height);
        }
        this.blocks = this.volume;
        if (reset) {
            Mine.reset$default(this, false, 1, null);
        }
    }

    public static /* synthetic */ void reload$default(Mine mine, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        mine.reload(bl);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Mine)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.file, (Object)((Mine)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private static final void reset$lambda$9$lambda$8(Mine this$0, boolean $silent, ScheduledTask scheduledTask) {
        Iterable $this$forEach$iv = this$0.config.RESET_COMMANDS;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String it = (String)element$iv2;
            boolean bl = false;
            Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)it);
        }
        int broadcast = this$0.config.BROADCAST_RESET;
        if ($silent) {
            broadcast = -2;
        }
        switch (broadcast) {
            case 0: {
                Object element$iv3;
                Object element$iv2;
                element$iv2 = new TagResolver[]{Placeholder.parsed("mine", this$0.config.DISPLAY_NAME)};
                String formatted = StringUtils.formatToString(this$0.config.PREFIX + this$0.config.RESET, element$iv2);
                Object $this$forEach$iv2 = this$0.getCuboid().getWorld().getPlayers();
                boolean $i$f$forEach2 = false;
                Iterator bl = $this$forEach$iv2.iterator();
                while (bl.hasNext()) {
                    element$iv3 = bl.next();
                    Player it = (Player)element$iv3;
                    boolean bl2 = false;
                    it.sendMessage(formatted);
                }
                break;
            }
            case -1: {
                Object element$iv3;
                Object $this$forEach$iv2 = new TagResolver[]{Placeholder.parsed("mine", this$0.config.DISPLAY_NAME)};
                String formatted = StringUtils.formatToString(this$0.config.PREFIX + this$0.config.RESET, (TagResolver[])$this$forEach$iv2);
                $this$forEach$iv2 = Bukkit.getOnlinePlayers();
                boolean $i$f$forEach3 = false;
                Iterator bl = $this$forEach$iv2.iterator();
                while (bl.hasNext()) {
                    element$iv3 = bl.next();
                    Player it = (Player)element$iv3;
                    boolean bl3 = false;
                    it.sendMessage(formatted);
                }
                break;
            }
            case -2: {
                break;
            }
            default: {
                Object $this$forEach$iv2 = new TagResolver[]{Placeholder.parsed("mine", this$0.config.DISPLAY_NAME)};
                String formatted = StringUtils.formatToString(this$0.config.PREFIX + this$0.config.RESET, (TagResolver[])$this$forEach$iv2);
                double x1 = this$0.getCuboid().getMaxX();
                double y1 = this$0.getCuboid().getMaxY();
                double z1 = this$0.getCuboid().getMaxZ();
                double x2 = this$0.getCuboid().getMinX();
                double y2 = this$0.getCuboid().getMinY();
                double z2 = this$0.getCuboid().getMinZ();
                Iterable $this$forEach$iv3 = this$0.getCuboid().getWorld().getPlayers();
                boolean $i$f$forEach4 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    Player it = (Player)element$iv;
                    boolean bl = false;
                    Location location = it.getLocation();
                    double x = location.getX();
                    double y = location.getY();
                    double z = location.getZ();
                    double x0 = Math.min(x1, Math.max(x, x2));
                    double y0 = Math.min(y1, Math.max(y, y2));
                    double z0 = Math.min(z1, Math.max(z, z2));
                    double distance = Math.pow(x - x0, 2.0) + Math.pow(y - y0, 2.0) + Math.pow(z - z0, 2.0);
                    if (Config.DEBUG) {
                        LOGGER.info("Distance to " + this$0.name + " is " + distance + "!");
                    }
                    if (!(distance <= (double)(this$0.config.BROADCAST_RESET * this$0.config.BROADCAST_RESET))) continue;
                    it.sendMessage(formatted);
                }
            }
        }
        switch (this$0.config.TELEPORT_ON_RESET) {
            case 0: {
                Iterable $this$forEach$iv4 = this$0.getCuboid().getWorld().getPlayers();
                boolean $i$f$forEach5 = false;
                for (Object element$iv : $this$forEach$iv4) {
                    Player it = (Player)element$iv;
                    boolean bl = false;
                    if (!this$0.getCuboid().contains(it.getLocation())) continue;
                    it.teleport(this$0.getCuboid().getWorld().getHighestBlockAt(it.getLocation()).getLocation().add(0.0, 1.0, 0.0));
                }
                break;
            }
            case 1: {
                Object element$iv3;
                Location tpLocation = Serializers.LOCATION.deserialize(this$0.config.TELEPORT_LOCATION);
                Iterable $this$forEach$iv5 = this$0.getCuboid().getWorld().getPlayers();
                boolean $i$f$forEach6 = false;
                for (Object element$iv3 : $this$forEach$iv5) {
                    Player it = (Player)element$iv3;
                    boolean bl = false;
                    if (!this$0.getCuboid().contains(it.getLocation())) continue;
                    it.teleport(tpLocation);
                }
                break;
            }
        }
    }

    private static final void reset$lambda$9(Ref.IntRef $placed, long $start, Mine this$0, boolean $silent, int it) {
        $placed.element = it;
        long took = System.currentTimeMillis() - $start;
        this$0.blocks = this$0.volume;
        if (Config.DEBUG) {
            LOGGER.info("Reset mine " + this$0.name + " and placed " + $placed.element + " blocks in " + took + " milliseconds!");
        }
        Scheduler.get().run(arg_0 -> Mine.reset$lambda$9$lambda$8(this$0, $silent, arg_0));
        this$0.running.set(false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/artillexstudios/axmines/mines/Mine$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "AxMines"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\fH\u00c6\u0003JM\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"J\t\u0010#\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0010\u00a8\u0006$"}, d2={"Lcom/artillexstudios/axmines/mines/Mine$Reward;", "Ljava/lang/Record;", "chance", "", "commands", "", "", "items", "Lorg/bukkit/inventory/ItemStack;", "blocks", "Lorg/bukkit/Material;", "preventDrops", "", "(DLjava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "()Ljava/util/List;", "()D", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "execute", "", "player", "Lorg/bukkit/entity/Player;", "hashCode", "", "test", "block", "Lorg/bukkit/block/Block;", "toString", "AxMines"})
    @SourceDebugExtension(value={"SMAP\nMine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Mine.kt\ncom/artillexstudios/axmines/mines/Mine$Reward\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,476:1\n1855#2,2:477\n1855#2,2:479\n*S KotlinDebug\n*F\n+ 1 Mine.kt\ncom/artillexstudios/axmines/mines/Mine$Reward\n*L\n462#1:477,2\n466#1:479,2\n*E\n"})
    public static final class Reward
    extends Record {
        private final double chance;
        @NotNull
        private final List<String> commands;
        @NotNull
        private final List<ItemStack> items;
        @NotNull
        private final List<Material> blocks;
        private final boolean preventDrops;

        public Reward(double chance, @NotNull List<String> commands, @NotNull List<? extends ItemStack> items, @NotNull List<? extends Material> blocks, boolean preventDrops) {
            this.chance = chance;
            this.commands = commands;
            this.items = items;
            this.blocks = blocks;
            this.preventDrops = preventDrops;
        }

        public final double chance() {
            return this.chance;
        }

        @NotNull
        public final List<String> commands() {
            return this.commands;
        }

        @NotNull
        public final List<ItemStack> items() {
            return this.items;
        }

        @NotNull
        public final List<Material> blocks() {
            return this.blocks;
        }

        public final boolean preventDrops() {
            return this.preventDrops;
        }

        public final void execute(@NotNull Player player) {
            String it;
            Iterable $this$forEach$iv = this.commands;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                boolean bl = false;
                Bukkit.dispatchCommand((CommandSender)((CommandSender)Bukkit.getConsoleSender()), (String)StringsKt.replace$default((String)it, (String)"<player>", (String)player.getName(), (boolean)false, (int)4, null));
            }
            $this$forEach$iv = this.items;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ItemStack)element$iv;
                boolean bl = false;
                ItemStack[] itemStackArray = new ItemStack[]{it};
                player.getInventory().addItem(itemStackArray);
            }
        }

        public final boolean test(@NotNull Block block) {
            return this.blocks.isEmpty() || this.blocks.contains(block.getType());
        }

        public final double component1() {
            return this.chance;
        }

        @NotNull
        public final List<String> component2() {
            return this.commands;
        }

        @NotNull
        public final List<ItemStack> component3() {
            return this.items;
        }

        @NotNull
        public final List<Material> component4() {
            return this.blocks;
        }

        public final boolean component5() {
            return this.preventDrops;
        }

        @NotNull
        public final Reward copy(double chance, @NotNull List<String> commands, @NotNull List<? extends ItemStack> items, @NotNull List<? extends Material> blocks, boolean preventDrops) {
            return new Reward(chance, commands, items, blocks, preventDrops);
        }

        public static /* synthetic */ Reward copy$default(Reward reward, double d, List list, List list2, List list3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                d = reward.chance;
            }
            if ((n & 2) != 0) {
                list = reward.commands;
            }
            if ((n & 4) != 0) {
                list2 = reward.items;
            }
            if ((n & 8) != 0) {
                list3 = reward.blocks;
            }
            if ((n & 0x10) != 0) {
                bl = reward.preventDrops;
            }
            return reward.copy(d, list, list2, list3, bl);
        }

        @Override
        @NotNull
        public String toString() {
            return "Reward(chance=" + this.chance + ", commands=" + this.commands + ", items=" + this.items + ", blocks=" + this.blocks + ", preventDrops=" + this.preventDrops + ")";
        }

        @Override
        public int hashCode() {
            int result = Double.hashCode(this.chance);
            result = result * 31 + ((Object)this.commands).hashCode();
            result = result * 31 + ((Object)this.items).hashCode();
            result = result * 31 + ((Object)this.blocks).hashCode();
            result = result * 31 + Boolean.hashCode(this.preventDrops);
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Reward)) {
                return false;
            }
            Reward reward = (Reward)other;
            if (Double.compare(this.chance, reward.chance) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual(this.commands, reward.commands)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.items, reward.items)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.blocks, reward.blocks)) {
                return false;
            }
            return this.preventDrops == reward.preventDrops;
        }
    }
}

