/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.packet.wrapper.clientbound;

import com.artillexstudios.axmines.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axmines.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axmines.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axmines.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axmines.libs.axapi.packet.PacketType;
import com.artillexstudios.axmines.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axmines.libs.axapi.utils.EquipmentSlot;
import com.artillexstudios.axmines.libs.axapi.utils.Pair;
import com.google.common.collect.Lists;
import java.util.List;

public final class ClientboundSetEquipmentWrapper
extends PacketWrapper {
    private int entityId;
    private List<Pair<EquipmentSlot, WrappedItemStack>> items;

    public ClientboundSetEquipmentWrapper(PacketEvent event) {
        super(event);
    }

    public ClientboundSetEquipmentWrapper(int entityId, List<Pair<EquipmentSlot, WrappedItemStack>> items) {
        this.entityId = entityId;
        this.items = items;
    }

    @Override
    public void write(FriendlyByteBuf out) {
        out.writeVarInt(this.entityId);
        int size = this.items.size();
        for (int i = 0; i < size; ++i) {
            Pair<EquipmentSlot, WrappedItemStack> slot = this.items.get(i);
            boolean last = i != size - 1;
            out.writeByte(last ? slot.first().ordinal() | 0xFFFFFF80 : slot.first().ordinal());
            out.writeItemStack(slot.second());
        }
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        byte _byte;
        this.entityId = buf.readVarInt();
        this.items = Lists.newArrayList();
        do {
            _byte = buf.readByte();
            EquipmentSlot slot = EquipmentSlot.values()[_byte & 0x7F];
            WrappedItemStack wrappedItemStack = buf.readItemStack();
            this.items.add(new Pair<EquipmentSlot, WrappedItemStack>(slot, wrappedItemStack));
        } while ((_byte & 0xFFFFFF80) != 0);
    }

    @Override
    public PacketType packetType() {
        return ClientboundPacketTypes.SET_EQUIPMENT;
    }

    public int entityId() {
        return this.entityId;
    }

    public void entityId(int entityId) {
        this.entityId = entityId;
        this.markDirty();
    }

    public List<Pair<EquipmentSlot, WrappedItemStack>> items() {
        return this.items;
    }

    public void items(List<Pair<EquipmentSlot, WrappedItemStack>> items) {
        this.items = items;
        this.markDirty();
    }
}

