/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.items.data;

import com.artillexstudios.axmines.libs.axapi.items.component.DataComponent;
import com.artillexstudios.axmines.libs.axapi.items.component.type.DyedColor;
import com.artillexstudios.axmines.libs.axapi.items.component.type.ProfileProperties;
import com.artillexstudios.axmines.libs.axapi.items.component.type.Unbreakable;
import com.artillexstudios.axmines.libs.axapi.utils.ComponentSerializer;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.potion.CraftPotionType;
import org.bukkit.craftbukkit.util.CraftMagicNumbers;
import org.bukkit.potion.PotionType;

public class DataComponentImpl
implements com.artillexstudios.axmines.libs.axapi.items.component.DataComponentImpl {
    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.nbt.CompoundTag> customData() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.nbt.CompoundTag>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.nbt.CompoundTag compoundTag) {
                ItemStack itemStack = (ItemStack)item;
                if (compoundTag == null || compoundTag.isEmpty()) {
                    itemStack.remove(DataComponents.CUSTOM_DATA);
                    return;
                }
                itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)((CompoundTag)compoundTag.getParent())));
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.nbt.CompoundTag get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return new com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.items.nbt.CompoundTag(((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)new CompoundTag()))).copyTag());
            }
        };
    }

    @Override
    public DataComponent<Integer> maxStackSize() {
        return new DataComponent<Integer>(this){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                if (integer == null || integer == 0) {
                    itemStack.remove(DataComponents.MAX_STACK_SIZE);
                    return;
                }
                itemStack.set(DataComponents.MAX_STACK_SIZE, (Object)integer);
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return (Integer)itemStack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)0);
            }
        };
    }

    @Override
    public DataComponent<Integer> maxDamage() {
        return new DataComponent<Integer>(this){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                if (integer == null || integer == 0) {
                    itemStack.remove(DataComponents.MAX_DAMAGE);
                    return;
                }
                itemStack.set(DataComponents.MAX_DAMAGE, (Object)integer);
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return (Integer)itemStack.getOrDefault(DataComponents.MAX_DAMAGE, (Object)0);
            }
        };
    }

    @Override
    public DataComponent<Integer> damage() {
        return new DataComponent<Integer>(this){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                if (integer == null || integer == 0) {
                    itemStack.remove(DataComponents.DAMAGE);
                    return;
                }
                itemStack.set(DataComponents.DAMAGE, (Object)integer);
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return (Integer)itemStack.getOrDefault(DataComponents.DAMAGE, (Object)0);
            }
        };
    }

    @Override
    public DataComponent<Unbreakable> unbreakable() {
        return new DataComponent<Unbreakable>(this){

            @Override
            public void apply(Object item, Unbreakable unbreakable) {
                ItemStack itemStack = (ItemStack)item;
                if (unbreakable == null) {
                    itemStack.remove(DataComponents.UNBREAKABLE);
                    return;
                }
                itemStack.set(DataComponents.UNBREAKABLE, (Object)Unit.INSTANCE);
            }

            @Override
            public Unbreakable get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                Unit vanilla = (Unit)itemStack.get(DataComponents.UNBREAKABLE);
                return new Unbreakable(true);
            }
        };
    }

    @Override
    public DataComponent<Component> customName() {
        return new DataComponent<Component>(this){

            @Override
            public void apply(Object item, Component component) {
                ItemStack itemStack = (ItemStack)item;
                if (component == null) {
                    itemStack.remove(DataComponents.CUSTOM_NAME);
                    return;
                }
                itemStack.set(DataComponents.CUSTOM_NAME, (Object)((net.minecraft.network.chat.Component)ComponentSerializer.INSTANCE.toVanilla(component)));
            }

            @Override
            public Component get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                net.minecraft.network.chat.Component component = (net.minecraft.network.chat.Component)itemStack.get(DataComponents.CUSTOM_NAME);
                return component == null ? Component.empty() : ComponentSerializer.INSTANCE.fromVanilla(component);
            }
        };
    }

    @Override
    public DataComponent<Component> itemName() {
        return new DataComponent<Component>(this){

            @Override
            public void apply(Object item, Component component) {
                ItemStack itemStack = (ItemStack)item;
                if (component == null) {
                    itemStack.remove(DataComponents.ITEM_NAME);
                    return;
                }
                itemStack.set(DataComponents.ITEM_NAME, (Object)((net.minecraft.network.chat.Component)ComponentSerializer.INSTANCE.toVanilla(component)));
            }

            @Override
            public Component get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                net.minecraft.network.chat.Component component = (net.minecraft.network.chat.Component)itemStack.get(DataComponents.ITEM_NAME);
                return component == null ? Component.empty() : ComponentSerializer.INSTANCE.fromVanilla(component);
            }
        };
    }

    @Override
    public DataComponent<Key> itemModel() {
        return new DataComponent<Key>(this){

            @Override
            public void apply(Object item, Key key) {
                ItemStack itemStack = (ItemStack)item;
                if (key == null) {
                    itemStack.remove(DataComponents.ITEM_MODEL);
                    return;
                }
                itemStack.set(DataComponents.ITEM_MODEL, (Object)Identifier.fromNamespaceAndPath((String)key.namespace(), (String)key.value()));
            }

            @Override
            public Key get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                Identifier resourceLocation = (Identifier)itemStack.get(DataComponents.ITEM_MODEL);
                return resourceLocation == null ? null : Key.key(resourceLocation.getNamespace(), resourceLocation.getPath());
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.ItemLore> lore() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.ItemLore>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.ItemLore itemLore) {
                ItemStack itemStack = (ItemStack)item;
                if (itemLore == null) {
                    itemStack.remove(DataComponents.LORE);
                    return;
                }
                itemStack.set(DataComponents.LORE, (Object)new ItemLore(ComponentSerializer.INSTANCE.toVanillaList(itemLore.lines()), ComponentSerializer.INSTANCE.toVanillaList(itemLore.styledLines())));
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.ItemLore get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                ItemLore lore = (ItemLore)itemStack.get(DataComponents.LORE);
                return new com.artillexstudios.axmines.libs.axapi.items.component.type.ItemLore(lore == null ? List.of() : ComponentSerializer.INSTANCE.fromVanillaList(new ArrayList<Object>(lore.lines())), lore == null ? List.of() : ComponentSerializer.INSTANCE.fromVanillaList(new ArrayList<Object>(lore.styledLines())));
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Rarity> rarity() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Rarity>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.Rarity rarity) {
                ItemStack itemStack = (ItemStack)item;
                if (rarity == null) {
                    itemStack.remove(DataComponents.RARITY);
                    return;
                }
                itemStack.set(DataComponents.RARITY, (Object)Rarity.valueOf((String)rarity.name()));
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.Rarity get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return com.artillexstudios.axmines.libs.axapi.items.component.type.Rarity.valueOf(((Rarity)itemStack.getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON)).name());
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments> enchantments() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments itemEnchantments) {
                ItemStack itemStack = (ItemStack)item;
                if (itemEnchantments == null) {
                    itemStack.remove(DataComponents.ENCHANTMENTS);
                    return;
                }
                ItemEnchantments.Mutable vanilla = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                for (Map.Entry<org.bukkit.enchantments.Enchantment, Integer> e : itemEnchantments.entrySet()) {
                    vanilla.set(CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)e.getKey()), e.getValue().intValue());
                }
                itemStack.set(DataComponents.ENCHANTMENTS, (Object)vanilla.toImmutable());
                TooltipDisplay display = (TooltipDisplay)itemStack.get(DataComponents.TOOLTIP_DISPLAY);
                if (display == null) {
                    display = TooltipDisplay.DEFAULT;
                }
                display = display.withHidden(DataComponents.ENCHANTMENTS, itemEnchantments.showInTooltip());
                itemStack.set(DataComponents.TOOLTIP_DISPLAY, (Object)display);
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                ItemEnchantments vanilla = (ItemEnchantments)itemStack.get(DataComponents.ENCHANTMENTS);
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                if (vanilla == null) {
                    return new com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments(enchants, true);
                }
                vanilla.entrySet().forEach(e -> enchants.put(CraftEnchantment.minecraftHolderToBukkit((Holder)((Holder)e.getKey())), e.getIntValue()));
                boolean shows = true;
                TooltipDisplay display = (TooltipDisplay)itemStack.get(DataComponents.TOOLTIP_DISPLAY);
                if (display != null) {
                    shows = display.shows(DataComponents.ENCHANTMENTS);
                }
                return new com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments(enchants, shows);
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.CustomModelData> customModelData() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.CustomModelData>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.CustomModelData modelData) {
                ItemStack itemStack = (ItemStack)item;
                if (modelData == null) {
                    itemStack.remove(DataComponents.CUSTOM_MODEL_DATA);
                    return;
                }
                itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(modelData.floats(), modelData.flags(), modelData.strings(), modelData.colors()));
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.CustomModelData get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                CustomModelData data = (CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA);
                if (data == null) {
                    return null;
                }
                return new com.artillexstudios.axmines.libs.axapi.items.component.type.CustomModelData(data.strings(), data.flags(), data.floats(), data.colors());
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit> hideAdditionalTooltip() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.Unit unit) {
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.Unit get(Object item) {
                return null;
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit> hideTooltip() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.Unit unit) {
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.Unit get(Object item) {
                return null;
            }
        };
    }

    @Override
    public DataComponent<Integer> repairCost() {
        return new DataComponent<Integer>(this){

            @Override
            public void apply(Object item, Integer integer) {
                ItemStack itemStack = (ItemStack)item;
                if (integer == null || integer == 0) {
                    itemStack.remove(DataComponents.REPAIR_COST);
                    return;
                }
                itemStack.set(DataComponents.REPAIR_COST, (Object)integer);
            }

            @Override
            public Integer get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return (Integer)itemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit> creativeSlotLock() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.Unit unit) {
                ItemStack itemStack = (ItemStack)item;
                if (unit == null) {
                    itemStack.remove(DataComponents.CREATIVE_SLOT_LOCK);
                    return;
                }
                itemStack.set(DataComponents.CREATIVE_SLOT_LOCK, (Object)Unit.INSTANCE);
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.Unit get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return itemStack.get(DataComponents.CREATIVE_SLOT_LOCK) == null ? null : com.artillexstudios.axmines.libs.axapi.items.component.type.Unit.INSTANCE;
            }
        };
    }

    @Override
    public DataComponent<Boolean> enchantmentGlintOverride() {
        return new DataComponent<Boolean>(this){

            @Override
            public void apply(Object item, Boolean glint) {
                ItemStack itemStack = (ItemStack)item;
                if (glint == null) {
                    itemStack.remove(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
                    return;
                }
                itemStack.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)glint);
            }

            @Override
            public Boolean get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return (Boolean)itemStack.getOrDefault(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit> intangibleProjectile() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.Unit>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.Unit unit) {
                ItemStack itemStack = (ItemStack)item;
                if (unit == null) {
                    itemStack.remove(DataComponents.INTANGIBLE_PROJECTILE);
                    return;
                }
                itemStack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.Unit get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return itemStack.get(DataComponents.INTANGIBLE_PROJECTILE) == null ? null : com.artillexstudios.axmines.libs.axapi.items.component.type.Unit.INSTANCE;
            }
        };
    }

    @Override
    public DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments> storedEnchantments() {
        return new DataComponent<com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments>(this){

            @Override
            public void apply(Object item, com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments itemEnchantments) {
                ItemStack itemStack = (ItemStack)item;
                if (itemEnchantments == null) {
                    itemStack.remove(DataComponents.STORED_ENCHANTMENTS);
                    return;
                }
                ItemEnchantments.Mutable vanilla = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                for (Map.Entry<org.bukkit.enchantments.Enchantment, Integer> e : itemEnchantments.entrySet()) {
                    vanilla.set(CraftEnchantment.bukkitToMinecraftHolder((org.bukkit.enchantments.Enchantment)e.getKey()), e.getValue().intValue());
                }
                itemStack.set(DataComponents.STORED_ENCHANTMENTS, (Object)vanilla.toImmutable());
                TooltipDisplay display = (TooltipDisplay)itemStack.get(DataComponents.TOOLTIP_DISPLAY);
                if (display == null) {
                    display = TooltipDisplay.DEFAULT;
                }
                display = display.withHidden(DataComponents.STORED_ENCHANTMENTS, itemEnchantments.showInTooltip());
                itemStack.set(DataComponents.TOOLTIP_DISPLAY, (Object)display);
            }

            @Override
            public com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                ItemEnchantments vanilla = (ItemEnchantments)itemStack.get(DataComponents.STORED_ENCHANTMENTS);
                HashMap<org.bukkit.enchantments.Enchantment, Integer> enchants = new HashMap<org.bukkit.enchantments.Enchantment, Integer>();
                if (vanilla == null) {
                    return new com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments(enchants, true);
                }
                vanilla.entrySet().forEach(e -> enchants.put(CraftEnchantment.minecraftHolderToBukkit((Holder)Holder.direct((Object)((Enchantment)((Holder)e.getKey()).value()))), e.getIntValue()));
                boolean shows = true;
                TooltipDisplay display = (TooltipDisplay)itemStack.get(DataComponents.TOOLTIP_DISPLAY);
                if (display != null) {
                    shows = display.shows(DataComponents.STORED_ENCHANTMENTS);
                }
                return new com.artillexstudios.axmines.libs.axapi.items.component.type.ItemEnchantments(enchants, shows);
            }
        };
    }

    @Override
    public DataComponent<ProfileProperties> profile() {
        return new DataComponent<ProfileProperties>(this){

            @Override
            public void apply(Object item, ProfileProperties profileProperties) {
                ItemStack itemStack = (ItemStack)item;
                if (profileProperties == null) {
                    itemStack.remove(DataComponents.PROFILE);
                    return;
                }
                HashMultimap propertyMap = HashMultimap.create();
                for (Map.Entry entry : profileProperties.properties().entries()) {
                    ProfileProperties.Property property = (ProfileProperties.Property)entry.getValue();
                    propertyMap.put((Object)((String)entry.getKey()), (Object)new Property(property.name(), property.value(), property.signature()));
                }
                GameProfile gameProfile = new GameProfile(profileProperties.uuid(), profileProperties.name(), new PropertyMap((Multimap)propertyMap));
                itemStack.set(DataComponents.PROFILE, (Object)ResolvableProfile.createResolved((GameProfile)gameProfile));
            }

            @Override
            public ProfileProperties get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                ResolvableProfile profile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
                if (profile == null) {
                    return new ProfileProperties(new UUID(0L, 0L), "---");
                }
                ProfileProperties profileProperties = new ProfileProperties(profile.partialProfile().id(), profile.name().orElse(""));
                profile.partialProfile().properties().forEach((k, v) -> profileProperties.put((String)k, new ProfileProperties.Property(v.name(), v.value(), v.signature())));
                return profileProperties;
            }
        };
    }

    @Override
    public DataComponent<Material> material() {
        return new DataComponent<Material>(this){

            @Override
            public void apply(Object item, Material material) {
                ItemStack itemStack = (ItemStack)item;
                DataComponentPatch patch = itemStack.getComponentsPatch();
                itemStack.setItem(CraftMagicNumbers.getItem((Material)material));
                itemStack.restorePatch(patch);
            }

            @Override
            public Material get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                return CraftMagicNumbers.getMaterial((Item)itemStack.getItem());
            }
        };
    }

    @Override
    public DataComponent<DyedColor> dyedColor() {
        return new DataComponent<DyedColor>(this){

            @Override
            public void apply(Object item, DyedColor dyedColor) {
                ItemStack itemStack = (ItemStack)item;
                if (dyedColor == null) {
                    itemStack.remove(DataComponents.DYED_COLOR);
                    return;
                }
                itemStack.set(DataComponents.DYED_COLOR, (Object)new DyedItemColor(dyedColor.rgb()));
                TooltipDisplay display = (TooltipDisplay)itemStack.get(DataComponents.TOOLTIP_DISPLAY);
                if (display == null) {
                    display = TooltipDisplay.DEFAULT;
                }
                display = display.withHidden(DataComponents.DYED_COLOR, dyedColor.showInTooltip());
                itemStack.set(DataComponents.TOOLTIP_DISPLAY, (Object)display);
            }

            @Override
            public DyedColor get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                DyedItemColor color = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR);
                boolean shows = true;
                TooltipDisplay display = (TooltipDisplay)itemStack.get(DataComponents.TOOLTIP_DISPLAY);
                if (display != null) {
                    shows = display.shows(DataComponents.DYED_COLOR);
                }
                return new DyedColor(color == null ? Color.fromRGB((int)0) : Color.fromRGB((int)color.rgb()), color == null ? true : shows);
            }
        };
    }

    @Override
    public DataComponent<PotionType> potionType() {
        return new DataComponent<PotionType>(this){

            @Override
            public void apply(Object item, PotionType potionType) {
                ItemStack itemStack = (ItemStack)item;
                if (potionType == null) {
                    itemStack.remove(DataComponents.POTION_CONTENTS);
                    return;
                }
                itemStack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(CraftPotionType.bukkitToMinecraftHolder((PotionType)potionType)));
            }

            @Override
            public PotionType get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                PotionContents pot = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
                if (pot == null || pot.potion().isEmpty()) {
                    return PotionType.AWKWARD;
                }
                return CraftPotionType.minecraftHolderToBukkit((Holder)((Holder)pot.potion().get()));
            }
        };
    }

    @Override
    public DataComponent<Key> tooltipStyle() {
        return new DataComponent<Key>(this){

            @Override
            public void apply(Object item, Key key) {
                ItemStack itemStack = (ItemStack)item;
                if (key == null) {
                    itemStack.remove(DataComponents.TOOLTIP_STYLE);
                    return;
                }
                itemStack.set(DataComponents.TOOLTIP_STYLE, (Object)Identifier.fromNamespaceAndPath((String)key.namespace(), (String)key.value()));
            }

            @Override
            public Key get(Object item) {
                ItemStack itemStack = (ItemStack)item;
                Identifier resourceLocation = (Identifier)itemStack.get(DataComponents.TOOLTIP_STYLE);
                return resourceLocation == null ? null : Key.key(resourceLocation.getNamespace(), resourceLocation.getPath());
            }
        };
    }
}

