/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.entity;

import com.artillexstudios.axmines.libs.axapi.AxPlugin;
import com.artillexstudios.axmines.libs.axapi.collections.RawReferenceOpenHashSet;
import com.artillexstudios.axmines.libs.axapi.events.PacketEntityInteractEvent;
import com.artillexstudios.axmines.libs.axapi.hologram.Holograms;
import com.artillexstudios.axmines.libs.axapi.hologram.page.HologramPage;
import com.artillexstudios.axmines.libs.axapi.hologram.page.LineData;
import com.artillexstudios.axmines.libs.axapi.hologram.page.TextDisplayHologramPage;
import com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.entity.Serializers;
import com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.items.WrappedItemStack;
import com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.packet.ClientboundSetPassengersWrapper;
import com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.packet.ClientboundTeleportEntityWrapper;
import com.artillexstudios.axmines.libs.axapi.nms.v1_21_R7_paper.wrapper.ServerWrapper;
import com.artillexstudios.axmines.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axmines.libs.axapi.packetentity.meta.EntityMeta;
import com.artillexstudios.axmines.libs.axapi.packetentity.meta.EntityMetaFactory;
import com.artillexstudios.axmines.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axmines.libs.axapi.packetentity.tracker.EntityTracker;
import com.artillexstudios.axmines.libs.axapi.placeholders.PlaceholderHandler;
import com.artillexstudios.axmines.libs.axapi.placeholders.PlaceholderParameters;
import com.artillexstudios.axmines.libs.axapi.utils.EquipmentSlot;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class PacketEntity
implements com.artillexstudios.axmines.libs.axapi.packetentity.PacketEntity {
    private final int id;
    private final EntityMeta meta;
    private final net.minecraft.world.entity.EntityType<?> type;
    private final VecDeltaCodec codec = new VecDeltaCodec();
    private final Set<Player> invertedVisibilityEntities = Collections.newSetFromMap(new WeakHashMap());
    private final NonNullList<ItemStack> handSlots;
    private final NonNullList<ItemStack> armorSlots;
    private Location location;
    private volatile EntityTracker.TrackedEntity tracker;
    private List<SynchedEntityData.DataValue<?>> trackedValues;
    private Vec3 vec3;
    private volatile boolean shouldTeleport = false;
    private volatile boolean itemDirty = false;
    private boolean visibleByDefault = true;
    private int riddenEntityId = -1;
    private Consumer<PacketEntityInteractEvent> interactConsumer;
    private boolean hasInvertedVisibility = false;
    private float yHeadRot = 0.0f;
    private int viewDistanceSquared = 1024;

    public PacketEntity(EntityType entityType, Location location) {
        this.id = ServerWrapper.INSTANCE.nextEntityId();
        this.type = net.minecraft.world.entity.EntityType.byString((String)entityType.getName()).orElse(net.minecraft.world.entity.EntityType.ARMOR_STAND);
        this.meta = EntityMetaFactory.getForType(entityType);
        this.location = location;
        this.handSlots = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        this.armorSlots = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    }

    private static List<SynchedEntityData.DataValue<?>> transform(List<Metadata.DataItem<?>> toTransform) {
        ArrayList<SynchedEntityData.DataValue> dataValues = null;
        if (toTransform != null) {
            dataValues = new ArrayList<SynchedEntityData.DataValue>(toTransform.size());
            for (Metadata.DataItem<?> dataItem : toTransform) {
                Serializers.Transformer transformer = Serializers.transformer(dataItem.serializer());
                dataValues.add(new SynchedEntityData.DataValue(dataItem.id(), transformer.serializer(), transformer.transform(dataItem.getValue())));
            }
        }
        return dataValues;
    }

    private static ClientboundAddEntityPacket getAddEntityPacket(PacketEntity entity) {
        return new ClientboundAddEntityPacket(entity.id(), UUID.randomUUID(), entity.location().getX(), entity.location().getY(), entity.location().getZ(), entity.location().getPitch(), entity.location().getYaw(), entity.type, 0, Vec3.ZERO, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void teleport(Location location) {
        Preconditions.checkNotNull((Object)location, (Object)"Can't teleport a packetentity to a null location!");
        this.location = location;
        VecDeltaCodec vecDeltaCodec = this.codec;
        synchronized (vecDeltaCodec) {
            this.vec3 = new Vec3(location.getX(), location.getY(), location.getZ());
            this.shouldTeleport = true;
        }
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public EntityMeta meta() {
        return this.meta;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int viewDistanceSquared() {
        return this.viewDistanceSquared;
    }

    @Override
    public void viewDistance(int blocks) {
        this.viewDistanceSquared = blocks * blocks;
    }

    @Override
    public void spawn() {
        this.meta.metadata().markNotDirty();
        this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
        ((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).tracker.addEntity(this);
    }

    @Override
    public void hide(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.add(player);
            this.hasInvertedVisibility = true;
        } else {
            this.invertedVisibilityEntities.remove(player);
            if (this.invertedVisibilityEntities.isEmpty()) {
                this.hasInvertedVisibility = false;
            }
        }
    }

    @Override
    public void show(Player player) {
        if (this.visibleByDefault) {
            this.invertedVisibilityEntities.remove(player);
            if (this.invertedVisibilityEntities.isEmpty()) {
                this.hasInvertedVisibility = false;
            }
        } else {
            this.invertedVisibilityEntities.add(player);
            this.hasInvertedVisibility = true;
        }
    }

    @Override
    public void setVisibleByDefault(boolean visible) {
        this.visibleByDefault = visible;
    }

    @Override
    public void setItem(com.artillexstudios.axmines.libs.axapi.utils.EquipmentSlot slot, com.artillexstudios.axmines.libs.axapi.items.WrappedItemStack item) {
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            this.handSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.EMPTY : ((WrappedItemStack)item).itemStack));
        } else {
            this.armorSlots.set(slot.getIndex(), (Object)(item == null ? ItemStack.EMPTY : ((WrappedItemStack)item).itemStack));
        }
        this.itemDirty = true;
    }

    @Override
    public com.artillexstudios.axmines.libs.axapi.items.WrappedItemStack getItem(com.artillexstudios.axmines.libs.axapi.utils.EquipmentSlot slot) {
        return new WrappedItemStack(slot.getType() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.armorSlots.get(slot.getIndex()) : (ItemStack)this.handSlots.get(slot.getIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendChanges() {
        List<Metadata.DataItem<?>> items = this.meta.metadata().packDirty();
        if (items != null) {
            List<SynchedEntityData.DataValue<?>> dirty = PacketEntity.transform(items);
            this.trackedValues = PacketEntity.transform(this.meta.metadata().getNonDefaultValues());
            HologramPage<?, ?> page = Holograms.byId(this.id);
            if (page == null || !page.containsPlaceholders()) {
                this.tracker.broadcast(new ClientboundSetEntityDataPacket(this.id, dirty));
            } else {
                PlaceholderParameters parameters = new PlaceholderParameters();
                parameters.merge(page.getParameters());
                for (Object player : RawReferenceOpenHashSet.rawSet(this.tracker.seenBy)) {
                    if (player == null) continue;
                    ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
                    parameters.withParameter(Player.class, (Player)wrapper.wrapped());
                    wrapper.sendPacket(new ClientboundSetEntityDataPacket(this.id, this.translate(parameters, page, dirty)));
                }
            }
        }
        if (this.itemDirty) {
            this.itemDirty = false;
            ArrayList equipments = Lists.newArrayList();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack item = this.getItemBySlot(slot);
                if (item != null && !item.isEmpty()) {
                    ItemStack sanitised = item.copy();
                    equipments.add(Pair.of((Object)slot, (Object)sanitised));
                    continue;
                }
                equipments.add(Pair.of((Object)slot, (Object)ItemStack.EMPTY));
            }
            if (!equipments.isEmpty()) {
                this.tracker.broadcast(new ClientboundSetEquipmentPacket(this.id, (List)equipments));
            }
        }
        if (this.shouldTeleport) {
            VecDeltaCodec vecDeltaCodec = this.codec;
            synchronized (vecDeltaCodec) {
                this.shouldTeleport = false;
                long k = this.codec.encodeX(this.vec3);
                long l = this.codec.encodeY(this.vec3);
                long i1 = this.codec.encodeZ(this.vec3);
                boolean flag6 = k < -32768L || k > 32767L || l < -32768L || l > 32767L || i1 < -32768L || i1 > 32767L;
                this.codec.setBase(this.vec3);
                if (!flag6) {
                    this.tracker.broadcast(new ClientboundMoveEntityPacket.PosRot(this.id, (short)k, (short)l, (short)i1, (byte)(this.location.getYaw() * 256.0f / 360.0f), (byte)(this.location.getPitch() * 256.0f / 360.0f), true));
                } else {
                    this.tracker.broadcast(ClientboundTeleportEntityWrapper.createNew(this, this.location));
                }
            }
        }
    }

    @Override
    public void removePairing(Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        serverPlayer.connection.send((Packet)new ClientboundRemoveEntitiesPacket(new int[]{this.id}));
    }

    @Override
    public void addPairing(Player player) {
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(PacketEntity.getAddEntityPacket(this));
        if (this.trackedValues != null) {
            HologramPage<?, ?> page = Holograms.byId(this.id);
            if (page == null || !page.containsPlaceholders()) {
                list.add(new ClientboundSetEntityDataPacket(this.id, this.trackedValues));
            } else {
                list.add(new ClientboundSetEntityDataPacket(this.id, this.translate(new PlaceholderParameters().merge(page.getParameters()).withParameter(Player.class, player), page, this.trackedValues)));
            }
        }
        ArrayList equipments = Lists.newArrayList();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item = this.getItemBySlot(slot);
            if (item == null || item.isEmpty()) continue;
            ItemStack sanitised = item.copy();
            equipments.add(Pair.of((Object)slot, (Object)sanitised));
        }
        if (!equipments.isEmpty()) {
            list.add(new ClientboundSetEquipmentPacket(this.id, (List)equipments));
        }
        if (this.riddenEntityId != -1) {
            list.add(ClientboundSetPassengersWrapper.createNew(this.riddenEntityId, new int[]{this.id}));
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(this.id);
        buf.writeByte((int)((byte)Mth.floor((float)(this.yHeadRot * 256.0f / 360.0f))));
        list.add((Packet)ClientboundRotateHeadPacket.STREAM_CODEC.decode((Object)buf));
        buf.release();
        serverPlayer.connection.send((Packet)new ClientboundBundlePacket(list));
    }

    @Override
    public boolean canSee(Player player) {
        if (!this.hasInvertedVisibility) {
            return this.visibleByDefault;
        }
        return this.visibleByDefault ^ this.invertedVisibilityEntities.contains(player);
    }

    @Override
    public void remove() {
        ((AxPlugin)AxPlugin.getPlugin(AxPlugin.class)).tracker.removeEntity(this);
    }

    @Override
    public void onInteract(Consumer<PacketEntityInteractEvent> event) {
        this.interactConsumer = event;
    }

    @Override
    public void callInteract(PacketEntityInteractEvent event) {
        if (this.interactConsumer != null) {
            this.interactConsumer.accept(event);
        }
    }

    @Override
    public void ride(int entityId) {
        this.riddenEntityId = entityId;
        this.tracker.broadcast(ClientboundSetPassengersWrapper.createNew(this.riddenEntityId, new int[]{this.id}));
    }

    @Override
    public void unRide(int entityId) {
        if (this.riddenEntityId == -1) {
            return;
        }
        this.tracker.broadcast(ClientboundSetPassengersWrapper.createNew(this.riddenEntityId, new int[0]));
        this.riddenEntityId = -1;
    }

    @Override
    public int riddenEntity() {
        return this.riddenEntityId;
    }

    @Override
    public void rotate(float yaw, float pitch) {
        this.location.setYaw(yaw);
        this.location.setPitch(pitch);
        this.tracker.broadcast(new ClientboundMoveEntityPacket.Rot(this.id, (byte)Mth.floor((float)(yaw * 256.0f / 360.0f)), (byte)Mth.floor((float)(pitch * 256.0f / 360.0f)), true));
    }

    @Override
    public void rotateHead(float yaw) {
        this.yHeadRot = yaw;
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeVarInt(this.id);
        buf.writeByte((int)((byte)Mth.floor((float)(yaw * 256.0f / 360.0f))));
        ClientboundRotateHeadPacket packet = (ClientboundRotateHeadPacket)ClientboundRotateHeadPacket.STREAM_CODEC.decode((Object)buf);
        this.tracker.broadcast(packet);
        buf.release();
    }

    @Override
    public void update() {
        List<SynchedEntityData.DataValue<?>> transformed = PacketEntity.transform(this.meta.metadata().packForNameUpdate());
        HologramPage<?, ?> page = Holograms.byId(this.id);
        if (page == null || this.tracker == null || !page.containsPlaceholders()) {
            return;
        }
        PlaceholderParameters parameters = new PlaceholderParameters();
        parameters.merge(page.getParameters());
        for (Object player : RawReferenceOpenHashSet.rawSet(this.tracker.seenBy)) {
            if (player == null) continue;
            ServerPlayerWrapper wrapper = ServerPlayerWrapper.wrap(player);
            parameters.withParameter(Player.class, (Player)wrapper.wrapped());
            wrapper.sendPacket(new ClientboundSetEntityDataPacket(this.id, this.translate(parameters, page, transformed)));
        }
    }

    private List<SynchedEntityData.DataValue<?>> translate(PlaceholderParameters parameters, HologramPage<?, ?> page, List<SynchedEntityData.DataValue<?>> values) {
        if (!page.containsPlaceholders()) {
            return values;
        }
        ArrayList dataValues = new ArrayList(values);
        ListIterator<SynchedEntityData.DataValue> iterator = dataValues.listIterator();
        while (iterator.hasNext()) {
            SynchedEntityData.DataValue value = (SynchedEntityData.DataValue)iterator.next();
            if (value.id() != 23 || !(page instanceof TextDisplayHologramPage)) continue;
            TextDisplayHologramPage textPage = (TextDisplayHologramPage)page;
            MutableComponent components = MutableComponent.create((ComponentContents)PlainTextContents.EMPTY);
            for (LineData lineData : textPage.getData()) {
                if (!lineData.containsPlaceholders()) {
                    components.append((Component)lineData.component());
                    continue;
                }
                String parsed = PlaceholderHandler.parseWithPlaceholderAPI(lineData.content(), parameters);
                components.append((Component)placeholderFormatCache.get((Object)parsed));
            }
            iterator.remove();
            iterator.add(new SynchedEntityData.DataValue(value.id(), value.serializer(), (Object)components));
            break;
        }
        return dataValues;
    }

    private ItemStack getItemBySlot(EquipmentSlot slot) {
        return switch (slot.getType()) {
            case EquipmentSlot.Type.HUMANOID_ARMOR -> (ItemStack)this.armorSlots.get(slot.getIndex());
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handSlots.get(slot.getIndex());
            default -> null;
        };
    }
}

