/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.nms.v1_21_R1;

import com.artillexstudios.axmines.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axmines.libs.axapi.selection.BlockSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;

public class BlockSetterImpl
implements BlockSetter {
    private static final ExecutorService executor = new ExceptionReportingScheduledThreadPool(1);
    private final WorldServer level;
    private final ArrayList<ChunkCoordIntPair> chunks = new ArrayList();
    private Chunk chunk = null;

    public BlockSetterImpl(WorldServer level) {
        this.level = level;
    }

    @Override
    public void setBlock(int x, int y, int z, BlockData data) {
        Chunk levelChunk;
        int chunkX = x >> 4;
        int chunkZ = z >> 4;
        if (this.chunk != null && chunkX == this.chunk.f().e && chunkZ == this.chunk.f().f) {
            levelChunk = this.chunk;
        } else {
            this.chunk = levelChunk = this.level.d(chunkX, chunkZ);
            this.chunks.add(levelChunk.f());
        }
        IBlockData state = ((CraftBlockData)data).getState();
        int sectionIndex = levelChunk.e(y);
        ChunkSection section = levelChunk.b(sectionIndex);
        int i = y;
        if (section.c() && state.i()) {
            return;
        }
        int j = x & 0xF;
        int k = i & 0xF;
        int l = z & 0xF;
        section.a(j, k, l, state, false);
        this.updateHeightMap((IChunkAccess)levelChunk, j, y, l, state);
    }

    @Override
    public void finalise() {
        for (ChunkCoordIntPair chunk : this.chunks) {
            Chunk levelChunk = this.level.d(chunk.e, chunk.f);
            levelChunk.a(true);
            this.sendUpdatePacket(levelChunk);
        }
        this.relight();
        this.chunks.clear();
        this.chunk = null;
    }

    private void updateHeightMap(IChunkAccess chunk, int x, int y, int z, IBlockData blockState) {
        ((HeightMap)chunk.h.get(HeightMap.Type.e)).a(x, y, z, blockState);
        ((HeightMap)chunk.h.get(HeightMap.Type.f)).a(x, y, z, blockState);
        ((HeightMap)chunk.h.get(HeightMap.Type.d)).a(x, y, z, blockState);
        ((HeightMap)chunk.h.get(HeightMap.Type.b)).a(x, y, z, blockState);
    }

    private void relight() {
        HashSet<ChunkCoordIntPair> set = new HashSet<ChunkCoordIntPair>(this.chunks);
        MinecraftServer.getServer().h(() -> {
            LightEngineThreaded lightEngine = this.level.I.a();
            lightEngine.starlight$serverRelightChunks((Collection)set, c2 -> {}, c2 -> {});
        });
    }

    private void sendUpdatePacket(@NotNull Chunk chunk) {
        PlayerChunk playerChunk = this.level.l().a.b(chunk.f().longKey);
        if (playerChunk == null) {
            return;
        }
        List playersInRange = playerChunk.s.a(playerChunk.r(), false);
        executor.execute(() -> {
            ClientboundLevelChunkWithLightPacket lightPacket = new ClientboundLevelChunkWithLightPacket(chunk, this.level.y_(), null, null, false);
            int size = playersInRange.size();
            for (int i = 0; i < size; ++i) {
                EntityPlayer player = (EntityPlayer)playersInRange.get(i);
                player.c.b((Packet)lightPacket);
            }
        });
    }
}

