/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.nms.v1_20_R4;

import com.artillexstudios.axmines.libs.axapi.libs.math3.distribution.EnumeratedDistribution;
import com.artillexstudios.axmines.libs.axapi.selection.Cuboid;
import com.artillexstudios.axmines.libs.axapi.selection.ParallelBlockSetter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.PlayerChunk;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R4.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelBlockSetterImpl
implements ParallelBlockSetter {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final ExecutorService parallelExecutor = Executors.newVirtualThreadPerTaskExecutor();
    private static final Logger log = LoggerFactory.getLogger(ParallelBlockSetterImpl.class);
    private final WorldServer level;

    public ParallelBlockSetterImpl(WorldServer level) {
        this.level = level;
    }

    public ChunkSection copy(ChunkSection section) {
        try {
            Constructor constructor = ChunkSection.class.getDeclaredConstructor(ChunkSection.class);
            constructor.setAccessible(true);
            ChunkSection newSection = (ChunkSection)constructor.newInstance(section);
            return newSection;
        }
        catch (Exception exception) {
            log.error("An unexpected issue occurred while initializing ParallelBlockSetter. Is your version supported?", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void fill(Cuboid selection, EnumeratedDistribution<BlockData> distribution, IntConsumer consumer) {
        AtomicInteger blockCount = new AtomicInteger();
        int chunkMinX = selection.getMinX() >> 4;
        int chunkMaxX = selection.getMaxX() >> 4;
        int chunkMinZ = selection.getMinZ() >> 4;
        int chunkMaxZ = selection.getMaxZ() >> 4;
        List pmf = distribution.getPmf();
        ArrayList<CompletableFuture<Void>> chunkTasks = new ArrayList<CompletableFuture<Void>>();
        for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
            int minX = Math.max(selection.getMinX(), chunkX << 4);
            int maxX = Math.min(selection.getMaxX(), (chunkX << 4) + 15);
            for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                int minZ = Math.max(selection.getMinZ(), chunkZ << 4);
                int maxZ = Math.min(selection.getMaxZ(), (chunkZ << 4) + 15);
                Chunk levelChunk = this.level.d(chunkX, chunkZ);
                ArrayList<CompletableFuture<Void>> chunkFutures = new ArrayList<CompletableFuture<Void>>();
                int lastSectionIndex = -1;
                for (int y = selection.getMinY(); y <= selection.getMaxY(); ++y) {
                    int sectionIndex = levelChunk.e(y);
                    if (lastSectionIndex == sectionIndex) continue;
                    lastSectionIndex = sectionIndex;
                    ChunkSection section = levelChunk.b(sectionIndex);
                    ChunkSection newSection = this.copy(section);
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        EnumeratedDistribution newDistribution = new EnumeratedDistribution(pmf);
                        for (int i = selection.getMinY(); i <= selection.getMaxY(); ++i) {
                            int m = levelChunk.e(i);
                            if (m < sectionIndex) continue;
                            if (m > sectionIndex) break;
                            for (int x = minX; x <= maxX; ++x) {
                                for (int z = minZ; z <= maxZ; ++z) {
                                    CraftBlockData type = (CraftBlockData)newDistribution.sample();
                                    int j = x & 0xF;
                                    int k = i & 0xF;
                                    int l = z & 0xF;
                                    IBlockData state = type.getState();
                                    blockCount.incrementAndGet();
                                    newSection.a(j, k, l, state, true);
                                    this.updateHeightMap((IChunkAccess)levelChunk, j, i, l, state);
                                }
                            }
                        }
                        try {
                            MinecraftServer.getServer().g(() -> {
                                levelChunk.d()[sectionIndex] = newSection;
                            }).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }, parallelExecutor);
                    chunkFutures.add(future);
                }
                CompletableFuture<Void> thisChunk = CompletableFuture.allOf(chunkFutures.toArray(new CompletableFuture[0]));
                thisChunk.thenAccept(ignored -> MinecraftServer.getServer().g(() -> {
                    LightEngineThreaded lightEngine = this.level.I.a();
                    levelChunk.a(true);
                    this.sendUpdatePacket(levelChunk);
                }));
                chunkTasks.add(thisChunk);
            }
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(chunkTasks.toArray(new CompletableFuture[0]));
        future.thenAccept(ignored -> consumer.accept(blockCount.get()));
    }

    private void sendUpdatePacket(@NotNull Chunk chunk) {
        PlayerChunk playerChunk = this.level.l().a.b(chunk.f().longKey);
        if (playerChunk == null) {
            return;
        }
        List playersInRange = playerChunk.x.a(playerChunk.k(), false);
    }

    private void updateHeightMap(IChunkAccess chunk, int x, int y, int z, IBlockData blockState) {
        ((HeightMap)chunk.h.get(HeightMap.Type.e)).a(x, y, z, blockState);
        ((HeightMap)chunk.h.get(HeightMap.Type.f)).a(x, y, z, blockState);
        ((HeightMap)chunk.h.get(HeightMap.Type.d)).a(x, y, z, blockState);
        ((HeightMap)chunk.h.get(HeightMap.Type.b)).a(x, y, z, blockState);
    }
}

