/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.nms.v1_20_R3.packet;

import com.artillexstudios.axmines.libs.axapi.nms.v1_20_R3.packet.FriendlyByteBufWrapper;
import com.artillexstudios.axmines.libs.axapi.nms.v1_20_R3.packet.PacketTransformer;
import com.artillexstudios.axmines.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axmines.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axmines.libs.axapi.packet.PacketEvents;
import com.artillexstudios.axmines.libs.axapi.packet.PacketSide;
import com.artillexstudios.axmines.libs.axapi.packet.PacketType;
import com.artillexstudios.axmines.libs.axapi.packet.ServerboundPacketTypes;
import com.artillexstudios.axmines.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axmines.libs.axapi.utils.logging.LogUtils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import org.bukkit.entity.Player;

public final class ChannelDuplexHandlerPacketListener
extends ChannelDuplexHandler {
    private final Player player;

    public ChannelDuplexHandlerPacketListener(Player player) {
        this.player = player;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Packet<PacketListenerPlayOut> transformed;
        FriendlyByteBufWrapper out;
        if (!PacketEvents.INSTANCE.listening()) {
            super.write(ctx, msg, promise);
            return;
        }
        if (!(msg instanceof Packet)) {
            super.write(ctx, msg, promise);
            return;
        }
        if (msg instanceof ClientboundBundlePacket) {
            ClientboundBundlePacket bundlePacket = (ClientboundBundlePacket)msg;
            if (((Boolean)FeatureFlags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Bundle packet", new Object[0]);
            }
            ArrayList<Object> packets = new ArrayList<Object>();
            for (Packet subPacket : bundlePacket.a()) {
                FriendlyByteBufWrapper in;
                FriendlyByteBufWrapper out2;
                int packetId = PacketTransformer.packetId(PacketSide.CLIENT_BOUND, subPacket);
                if (packetId == -1) {
                    super.write(ctx, msg, promise);
                    return;
                }
                PacketType type = ClientboundPacketTypes.forPacketId(packetId);
                if (((Boolean)FeatureFlags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                    LogUtils.info("(bundle) Packet id: {}, class: {}, type: {}", packetId, subPacket.getClass(), type);
                }
                PacketEvent event = new PacketEvent(this.player, PacketSide.CLIENT_BOUND, type, () -> {
                    try {
                        FriendlyByteBufWrapper buf = PacketTransformer.transformClientbound(ctx, subPacket, fbb -> {});
                        if (buf == null) {
                            super.write(ctx, msg, promise);
                            return null;
                        }
                        return buf;
                    }
                    catch (Exception exception) {
                        try {
                            super.write(ctx, msg, promise);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        return null;
                    }
                });
                PacketEvents.INSTANCE.callEvent(event);
                if (event.cancelled()) {
                    out2 = (FriendlyByteBufWrapper)event.directOut();
                    if (out2 != null) {
                        out2.buf().release();
                    }
                    if ((in = (FriendlyByteBufWrapper)event.directIn()) == null) continue;
                    in.buf().release();
                    continue;
                }
                out2 = (FriendlyByteBufWrapper)event.directOut();
                in = (FriendlyByteBufWrapper)event.directIn();
                if (in != null) {
                    in.buf().release();
                }
                if (out2 == null) {
                    packets.add(subPacket);
                    continue;
                }
                packets.add(PacketTransformer.transformClientbound(out2.buf()));
            }
            super.write(ctx, (Object)new ClientboundBundlePacket(packets), promise);
            return;
        }
        int packetId = PacketTransformer.packetId(PacketSide.CLIENT_BOUND, msg);
        if (packetId == -1) {
            super.write(ctx, msg, promise);
            return;
        }
        PacketType type = ClientboundPacketTypes.forPacketId(packetId);
        if (((Boolean)FeatureFlags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Packet id: {}, class: {}, type: {}", packetId, msg.getClass(), type);
        }
        PacketEvent event = new PacketEvent(this.player, PacketSide.CLIENT_BOUND, type, () -> {
            try {
                FriendlyByteBufWrapper buf = PacketTransformer.transformClientbound(ctx, msg, fbb -> {});
                if (buf == null) {
                    super.write(ctx, msg, promise);
                    return null;
                }
                return buf;
            }
            catch (Exception exception) {
                try {
                    super.write(ctx, msg, promise);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
        try {
            PacketEvents.INSTANCE.callEvent(event);
        }
        catch (RuntimeException e) {
            LogUtils.info("Packet id: {}, class: {}, type: {}", packetId, msg.getClass(), type);
        }
        if (event.cancelled()) {
            FriendlyByteBufWrapper in;
            FriendlyByteBufWrapper out3;
            if (((Boolean)FeatureFlags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Cancelled event!", new Object[0]);
            }
            if ((out3 = (FriendlyByteBufWrapper)event.directOut()) != null) {
                out3.buf().release();
            }
            if ((in = (FriendlyByteBufWrapper)event.directIn()) != null) {
                in.buf().release();
            }
            return;
        }
        FriendlyByteBufWrapper in = (FriendlyByteBufWrapper)event.directIn();
        if (in != null) {
            in.buf().release();
        }
        if ((out = (FriendlyByteBufWrapper)event.directOut()) == null) {
            if (((Boolean)FeatureFlags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Unchanged!", new Object[0]);
            }
            super.write(ctx, msg, promise);
            return;
        }
        if (((Boolean)FeatureFlags.DEBUG_OUTGOING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Changed!", new Object[0]);
        }
        if ((transformed = PacketTransformer.transformClientbound(out.buf())) == null) {
            super.write(ctx, msg, promise);
            return;
        }
        super.write(ctx, transformed, promise);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Packet<PacketListenerPlayIn> transformed;
        FriendlyByteBufWrapper out;
        if (!PacketEvents.INSTANCE.listening()) {
            super.channelRead(ctx, msg);
            return;
        }
        if (!(msg instanceof Packet)) {
            super.channelRead(ctx, msg);
            return;
        }
        if (msg instanceof ServerboundCustomPayloadPacket) {
            ServerboundCustomPayloadPacket serverboundCustomPayloadPacket = (ServerboundCustomPayloadPacket)msg;
            try {
                CustomPacketPayload customPacketPayload;
                CustomPacketPayload payload = customPacketPayload = serverboundCustomPayloadPacket.a();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            super.channelRead(ctx, msg);
            return;
        }
        int packetId = PacketTransformer.packetId(PacketSide.SERVER_BOUND, msg);
        if (packetId == -1) {
            super.channelRead(ctx, msg);
            return;
        }
        PacketType type = ServerboundPacketTypes.forPacketId(packetId);
        if (((Boolean)FeatureFlags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Incoming packet id: {}, class: {}, type: {}", packetId, msg.getClass(), type);
        }
        PacketEvent event = new PacketEvent(this.player, PacketSide.SERVER_BOUND, type, () -> {
            try {
                FriendlyByteBufWrapper buf = PacketTransformer.transformServerbound(ctx, msg, fbb -> {});
                if (buf == null) {
                    super.channelRead(ctx, msg);
                    return null;
                }
                return buf;
            }
            catch (Exception exception) {
                try {
                    super.channelRead(ctx, msg);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return null;
            }
        });
        PacketEvents.INSTANCE.callEvent(event);
        if (event.cancelled()) {
            FriendlyByteBufWrapper out2;
            FriendlyByteBufWrapper in;
            if (((Boolean)FeatureFlags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Incoming cancelled event!", new Object[0]);
            }
            if ((in = (FriendlyByteBufWrapper)event.directIn()) != null) {
                in.buf().release();
            }
            if ((out2 = (FriendlyByteBufWrapper)event.directOut()) == null) return;
            out2.buf().release();
            return;
        }
        FriendlyByteBufWrapper in = (FriendlyByteBufWrapper)event.directIn();
        if (in != null) {
            in.buf().release();
        }
        if ((out = (FriendlyByteBufWrapper)event.directOut()) == null) {
            if (((Boolean)FeatureFlags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
                LogUtils.info("Incoming unchanged!", new Object[0]);
            }
            super.channelRead(ctx, msg);
            return;
        }
        if (((Boolean)FeatureFlags.DEBUG_INCOMING_PACKETS.get()).booleanValue()) {
            LogUtils.info("Incoming changed!", new Object[0]);
        }
        if ((transformed = PacketTransformer.transformServerbound(out.buf())) == null) {
            super.channelRead(ctx, msg);
            return;
        }
        super.channelRead(ctx, transformed);
    }
}

