/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.metrics.collectors;

import com.artillexstudios.axmines.libs.axapi.AxPlugin;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.MetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.CPUModelMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.JavaVersionMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.MinecraftVersionMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.OnlineModeMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.OnlinePlayersMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.OperatingSystemMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.PluginVersionMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.implementation.ServerSoftwareMetricsCollector;
import com.artillexstudios.axmines.libs.axapi.utils.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public final class MetricsCollectorRegistry {
    private final List<MetricsCollector> collectors = new ArrayList<MetricsCollector>();

    public MetricsCollectorRegistry(AxPlugin plugin) {
        this.register(JavaVersionMetricsCollector::new);
        this.register(MinecraftVersionMetricsCollector::new);
        this.register(OnlinePlayersMetricsCollector::new);
        this.register(() -> new PluginVersionMetricsCollector(plugin));
        this.register(ServerSoftwareMetricsCollector::new);
        this.register(OnlineModeMetricsCollector::new);
        try {
            Object systemInfo = Class.forName("oshi.SystemInfo").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.register(() -> new CPUModelMetricsCollector(systemInfo));
            this.register(() -> new OperatingSystemMetricsCollector(systemInfo));
        }
        catch (Exception exception) {
            LogUtils.error("Failed to get systeminfo!", exception);
        }
    }

    public void register(Supplier<MetricsCollector> collector) {
        try {
            MetricsCollector metricsCollector = collector.get();
            this.collectors.add(metricsCollector);
        }
        catch (Exception exception) {
            LogUtils.error("Failed to initialize collector!", new Object[0]);
        }
    }

    public List<MetricsCollector> collectors() {
        return Collections.unmodifiableList(this.collectors);
    }
}

