/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.libs.axapi.metrics;

import com.artillexstudios.axmines.libs.axapi.AxPlugin;
import com.artillexstudios.axmines.libs.axapi.config.YamlConfiguration;
import com.artillexstudios.axmines.libs.axapi.executor.ExceptionReportingScheduledThreadPool;
import com.artillexstudios.axmines.libs.axapi.libs.snakeyaml.DumperOptions;
import com.artillexstudios.axmines.libs.axapi.metrics.MetricsConfig;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.MetricsCollector;
import com.artillexstudios.axmines.libs.axapi.metrics.collectors.MetricsCollectorRegistry;
import com.artillexstudios.axmines.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axmines.libs.axapi.utils.http.Requests;
import com.artillexstudios.axmines.libs.axapi.utils.logging.LogUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;

public final class AxMetrics {
    private final MetricsCollectorRegistry registry;
    private final long pluginId;
    private ScheduledExecutorService executorService;
    private final YamlConfiguration<?> metricsConfig;
    private final String pluginName;

    public AxMetrics(AxPlugin plugin, long pluginId) {
        this.pluginId = pluginId;
        this.registry = new MetricsCollectorRegistry(plugin);
        this.pluginName = plugin.getName();
        Path path = plugin.getDataFolder().toPath();
        Path metricsConfigPath = path.getParent().resolve("AxAPI").resolve("metrics.yml");
        this.metricsConfig = YamlConfiguration.of(metricsConfigPath, MetricsConfig.class).withDumperOptions(options -> options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)).build();
        this.metricsConfig.load();
    }

    public void start() {
        if (!MetricsConfig.enabled) {
            return;
        }
        if (this.executorService != null) {
            LogUtils.error("Failed to start metrics, as it had already been started!", new Object[0]);
            return;
        }
        this.executorService = new ExceptionReportingScheduledThreadPool(0, Thread.ofVirtual().name(this.pluginName + "-AxMetrics-executor").factory());
        this.executorService.scheduleAtFixedRate(this::submitData, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void register(MetricsCollector collector) {
        this.registry.register(() -> collector);
    }

    public void cancel() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException exception) {
                LogUtils.error("An unexpected error occurred while shutting down the metrics executor!", exception);
            }
        }
        this.executorService = null;
    }

    private void submitData() {
        block7: {
            JsonObject obj = new JsonObject();
            obj.addProperty("timestamp", System.currentTimeMillis());
            obj.addProperty("plugin-id", this.pluginId);
            obj.addProperty("port", Bukkit.getPort());
            JsonArray data = new JsonArray();
            for (MetricsCollector collector : this.registry.collectors()) {
                collector.collect(data);
            }
            obj.add("data", data);
            try {
                HttpResponse<String> response = Requests.post("https://metrics.artillex-studios.com/api/v1/upload?uuid=" + MetricsConfig.serverUuid.toString(), Map.of("Content-Type", "application/json"), () -> obj);
                UUID previousUUID = MetricsConfig.serverUuid;
                if (response.statusCode() == 425) {
                    this.metricsConfig.load();
                    if (previousUUID.equals(MetricsConfig.serverUuid)) {
                        MetricsConfig.serverUuid = UUID.randomUUID();
                        this.metricsConfig.save();
                    }
                    LogUtils.warn("Regenerated server uuid, because it was already in use!", new Object[0]);
                } else if (response.statusCode() == 200 && ((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) {
                    LogUtils.debug("Sent metrics successfully!");
                }
            }
            catch (RuntimeException exception) {
                if (!((Boolean)FeatureFlags.DEBUG.get()).booleanValue()) break block7;
                LogUtils.debug("Caught exception while sending metrics! Body: {}", (Object)obj, (Object)exception.getCause());
            }
        }
    }
}

