/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.converters;

import com.artillexstudios.axmines.AxMinesPlugin;
import com.artillexstudios.axmines.libs.axapi.libs.boostedyaml.YamlDocument;
import com.artillexstudios.axmines.libs.axapi.libs.boostedyaml.settings.Settings;
import com.artillexstudios.axmines.libs.axapi.serializers.Serializers;
import com.artillexstudios.axmines.mines.Mine;
import com.artillexstudios.axmines.utils.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u0007\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/artillexstudios/axmines/converters/CataMinesConverter;", "", "()V", "convert", "", "file", "Ljava/io/File;", "convertAll", "AxMines"})
@SourceDebugExtension(value={"SMAP\nCataMinesConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CataMinesConverter.kt\ncom/artillexstudios/axmines/converters/CataMinesConverter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n13309#2,2:80\n*S KotlinDebug\n*F\n+ 1 CataMinesConverter.kt\ncom/artillexstudios/axmines/converters/CataMinesConverter\n*L\n17#1:80,2\n*E\n"})
public final class CataMinesConverter {
    @NotNull
    public static final CataMinesConverter INSTANCE = new CataMinesConverter();

    private CataMinesConverter() {
    }

    public final void convertAll() {
        block1: {
            File minesDir = FileUtils.PLUGIN_DIRECTORY.resolve("../CataMines/mines/").toFile();
            File[] fileArray = minesDir.listFiles();
            if (fileArray == null) break block1;
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File file = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                INSTANCE.convert(file);
            }
        }
    }

    private final void convert(File file) {
        YamlDocument document = YamlDocument.create(file, new Settings[0]);
        String name = document.getString("Mine.name");
        String world = document.getString("Mine.region.world");
        Double p1x = document.getDouble("Mine.region.p1.x");
        Double p1y = document.getDouble("Mine.region.p1.y");
        Double p1z = document.getDouble("Mine.region.p1.z");
        Double p2x = document.getDouble("Mine.region.p2.x");
        Double p2y = document.getDouble("Mine.region.p2.y");
        Double p2z = document.getDouble("Mine.region.p2.z");
        List<Map<?, ?>> composition = document.getMapList("Mine.composition");
        Integer resetDelay = document.getInt("Mine.resetDelay");
        Double resetPercent = document.getDouble("Mine.resetPercentage");
        Double teleportLocX = document.getDouble("Mine.teleportLocation.x");
        Double teleportLocY = document.getDouble("Mine.teleportLocation.y");
        Double teleportLocZ = document.getDouble("Mine.teleportLocation.z");
        String resetMode = document.getString("Mine.resetMode");
        Location loc1 = new Location(Bukkit.getWorld((String)world), p1x.doubleValue(), p1y.doubleValue(), p1z.doubleValue());
        Location loc2 = new Location(Bukkit.getWorld((String)world), p2x.doubleValue(), p2y.doubleValue(), p2z.doubleValue());
        File file2 = FileUtils.INSTANCE.extractFile(AxMinesPlugin.class, "mines/_example.yml", name + ".yml", FileUtils.PLUGIN_DIRECTORY.resolve("mines"), false);
        Mine createdMine = new Mine(file2, false);
        createdMine.getConfig().getConfig().set("selection.1", Serializers.LOCATION.serialize(loc1));
        createdMine.getConfig().getConfig().set("selection.2", Serializers.LOCATION.serialize(loc2));
        createdMine.getConfig().getConfig().set("display-name", name);
        createdMine.getConfig().getConfig().set("reset.ticks", StringsKt.equals((String)resetMode, (String)"TIME", (boolean)true) || StringsKt.equals((String)resetMode, (String)"TIME_PERCENTAGE", (boolean)true) ? resetDelay * 20 : Integer.MAX_VALUE);
        createdMine.getConfig().getConfig().set("reset.percent", resetPercent);
        HashMap map = new HashMap();
        for (Map<?, ?> mutableMap : composition) {
            String block = StringsKt.replace$default((String)String.valueOf(mutableMap.get("block")), (String)"minecraft:", (String)"", (boolean)false, (int)4, null);
            Object chance = mutableMap.get("chance");
            Map map2 = map;
            String string = block.toLowerCase(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map2.put(string, Double.parseDouble(String.valueOf(chance)));
        }
        createdMine.getConfig().getConfig().set("contents", map);
        createdMine.getConfig().getConfig().set("reset-commands", CollectionsKt.emptyList());
        createdMine.getConfig().getConfig().set("random-rewards", CollectionsKt.emptyList());
        createdMine.getConfig().getConfig().save();
        int maxY = createdMine.getCuboid().getMaxY();
        createdMine.reload(false);
        Location topLoc = null;
        topLoc = teleportLocX == null ? (loc1.getBlockY() == maxY ? loc1 : loc2) : new Location(Bukkit.getWorld((String)world), teleportLocX.doubleValue(), teleportLocY.doubleValue(), teleportLocZ.doubleValue());
        createdMine.getConfig().getConfig().set("teleport-location", Serializers.LOCATION.serialize(topLoc));
        createdMine.getConfig().getConfig().save();
        Mine.reload$default(createdMine, false, 1, null);
    }
}

