/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axmines.commands;

import com.artillexstudios.axmines.AxMinesPlugin;
import com.artillexstudios.axmines.converters.CataMinesConverter;
import com.artillexstudios.axmines.libs.axapi.libs.boostedyaml.YamlDocument;
import com.artillexstudios.axmines.libs.axapi.libs.boostedyaml.settings.Settings;
import com.artillexstudios.axmines.libs.axapi.serializers.Serializers;
import com.artillexstudios.axmines.libs.axapi.utils.PaperUtils;
import com.artillexstudios.axmines.libs.axapi.utils.StringUtils;
import com.artillexstudios.axmines.mines.Mine;
import com.artillexstudios.axmines.mines.Mines;
import com.artillexstudios.axmines.mines.editor.MinesEditor;
import com.artillexstudios.axmines.selection.Selection;
import com.artillexstudios.axmines.selection.SelectionWand;
import com.artillexstudios.axmines.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.DefaultFor;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.bukkit.annotation.CommandPermission;

@Command(value={"mines", "mine", "axmines"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a8\u0006\u0018"}, d2={"Lcom/artillexstudios/axmines/commands/AxMinesCommand;", "", "()V", "convert", "", "sender", "Lorg/bukkit/command/CommandSender;", "create", "player", "Lorg/bukkit/entity/Player;", "name", "", "delete", "mine", "Lcom/artillexstudios/axmines/mines/Mine;", "editor", "help", "list", "redefine", "reload", "reset", "teleport", "teleportSet", "wand", "AxMines"})
@SourceDebugExtension(value={"SMAP\nAxMinesCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AxMinesCommand.kt\ncom/artillexstudios/axmines/commands/AxMinesCommand\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n215#2,2:164\n1855#3,2:166\n1855#3,2:168\n*S KotlinDebug\n*F\n+ 1 AxMinesCommand.kt\ncom/artillexstudios/axmines/commands/AxMinesCommand\n*L\n53#1:164,2\n58#1:166,2\n159#1:168,2\n*E\n"})
public final class AxMinesCommand {
    @Subcommand(value={"reload"})
    @CommandPermission(value="axmines.command.reload")
    public final void reload(@NotNull CommandSender sender) {
        TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.unparsed("time", String.valueOf(AxMinesPlugin.Companion.getINSTANCE().reloadWithTime()))};
        sender.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().RELOAD, tagResolverArray));
    }

    @Subcommand(value={"wand"})
    @CommandPermission(value="axmines.command.wand")
    public final void wand(@NotNull Player sender) {
        ItemStack[] itemStackArray = new ItemStack[]{SelectionWand.INSTANCE.getWand()};
        sender.getInventory().addItem(itemStackArray);
    }

    @Subcommand(value={"delete"})
    @CommandPermission(value="axmines.command.delete")
    public final void delete(@NotNull CommandSender sender, @NotNull Mine mine) {
        Mines.INSTANCE.unregister(mine);
    }

    @Subcommand(value={"list"})
    @CommandPermission(value="axmines.command.list")
    public final void list(@NotNull CommandSender sender) {
        List list = new ArrayList();
        Map<String, Mine> $this$forEach$iv = Mines.INSTANCE.getTypes();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Mine>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Mine> element$iv;
            Map.Entry<String, Mine> entry = element$iv = iterator.next();
            boolean bl = false;
            Mine v = entry.getValue();
            list.add(v.getName() + " (" + v.getConfig().DISPLAY_NAME + "<reset>)");
        }
        String mines = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null);
        Iterable $this$forEach$iv2 = AxMinesPlugin.Companion.getMESSAGES().LIST;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            String line = (String)element$iv;
            boolean bl = false;
            TagResolver[] tagResolverArray = new TagResolver[]{Placeholder.parsed("mines", mines)};
            sender.sendMessage(StringUtils.formatToString(line, tagResolverArray));
        }
    }

    @Subcommand(value={"redefine"})
    @CommandPermission(value="axmines.command.redefine")
    public final void redefine(@NotNull Player sender, @NotNull Mine mine) {
        Selection selection;
        Selection selection2 = selection = SelectionWand.INSTANCE.getSelection(sender);
        if ((selection2 != null ? selection2.getPosition1() : null) == null || selection.getPosition2() == null) {
            sender.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().NO_SELECTION, new TagResolver[0]));
            return;
        }
        mine.getConfig().getConfig().set("selection.1", Serializers.LOCATION.serialize(selection.getPosition1()));
        mine.getConfig().getConfig().set("selection.2", Serializers.LOCATION.serialize(selection.getPosition2()));
        mine.getConfig().getConfig().save();
        int maxY = mine.getCuboid().getMaxY();
        mine.reload(false);
        Location location = selection.getPosition1();
        Location topLoc = (location != null ? location.getBlockY() == maxY : false) ? selection.getPosition1() : selection.getPosition2();
        mine.getConfig().getConfig().set("teleport-location", Serializers.LOCATION.serialize(topLoc));
        mine.getConfig().getConfig().save();
        sender.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().REDEFINE, new TagResolver[0]));
    }

    @Subcommand(value={"teleport"})
    @CommandPermission(value="axmines.command.teleport")
    public final void teleport(@NotNull Player player, @NotNull Mine mine) {
        Location location = Serializers.LOCATION.deserialize(mine.getConfig().TELEPORT_LOCATION);
        if (location == null) {
            return;
        }
        Location tpLoc = location;
        PaperUtils.teleportAsync((Entity)player, tpLoc);
        player.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().TELEPORT, new TagResolver[0]));
    }

    @Subcommand(value={"editor"})
    @CommandPermission(value="axmines.command.editor")
    public final void editor(@NotNull Player player) {
        new MinesEditor(player).open();
    }

    @Subcommand(value={"setteleport"})
    @CommandPermission(value="axmines.command.setteleport")
    public final void teleportSet(@NotNull Player player, @NotNull Mine mine) {
        String tpLoc;
        String string = Serializers.LOCATION.serialize(player.getLocation());
        if (string == null) {
            return;
        }
        mine.getConfig().TELEPORT_LOCATION = tpLoc = string;
        mine.getConfig().getConfig().set("teleport-location", tpLoc);
        mine.getConfig().getConfig().save();
        player.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().SET_TELEPORT, new TagResolver[0]));
    }

    @Subcommand(value={"create"})
    @CommandPermission(value="axmines.command.create")
    public final void create(@NotNull Player player, @NotNull String name) {
        Selection selection;
        Map<String, Mine> map = Mines.INSTANCE.getTypes();
        String string = name.toLowerCase(Locale.ENGLISH);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Mine mine = map.get(string);
        if (mine != null) {
            player.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().ALREADY_EXISTS, new TagResolver[0]));
            return;
        }
        Selection selection2 = selection = SelectionWand.INSTANCE.getSelection(player);
        if ((selection2 != null ? selection2.getPosition1() : null) == null || selection.getPosition2() == null) {
            player.sendMessage(StringUtils.formatToString(AxMinesPlugin.Companion.getMESSAGES().PREFIX + AxMinesPlugin.Companion.getMESSAGES().NO_SELECTION, new TagResolver[0]));
            return;
        }
        File file = FileUtils.INSTANCE.extractFile(AxMinesPlugin.class, "mines/_example.yml", name + ".yml", FileUtils.PLUGIN_DIRECTORY.resolve("mines"), false);
        YamlDocument config = YamlDocument.create(file, new Settings[0]);
        config.set("selection.1", (Object)Serializers.LOCATION.serialize(selection.getPosition1()));
        config.set("selection.2", (Object)Serializers.LOCATION.serialize(selection.getPosition2()));
        config.set("display-name", (Object)("<#FF0000>" + name + "</#FF0000>"));
        config.save();
        Mine createdMine = new Mine(file, false);
        int maxY = createdMine.getCuboid().getMaxY();
        createdMine.reload(false);
        Location location = selection.getPosition1();
        Location topLoc = (location != null ? location.getBlockY() == maxY : false) ? selection.getPosition1() : selection.getPosition2();
        createdMine.getConfig().getConfig().set("teleport-location", Serializers.LOCATION.serialize(topLoc));
        createdMine.getConfig().getConfig().save();
        Mine.reload$default(createdMine, false, 1, null);
    }

    @Subcommand(value={"reset"})
    @CommandPermission(value="axmines.command.reset")
    public final void reset(@NotNull CommandSender sender, @NotNull Mine mine) {
        Mine.reset$default(mine, false, 1, null);
    }

    @Subcommand(value={"convert"})
    @CommandPermission(value="axmines.command.convert")
    public final void convert(@NotNull CommandSender sender) {
        CataMinesConverter.INSTANCE.convertAll();
    }

    @DefaultFor(value={"~", "~ help"})
    @CommandPermission(value="axmines.command.help")
    public final void help(@NotNull CommandSender sender) {
        Iterable $this$forEach$iv = AxMinesPlugin.Companion.getMESSAGES().HELP;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            sender.sendMessage(StringUtils.formatToString(it, new TagResolver[0]));
        }
    }
}

