/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.utils;

import club.minnced.discord.webhook.send.WebhookEmbed;
import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.block.implementation.Section;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebhookEmbedBuilder {
    private final club.minnced.discord.webhook.send.WebhookEmbedBuilder embed;
    private final Map<String, String> replacements;

    public WebhookEmbedBuilder(@NotNull Section section) {
        this(section, new HashMap<String, String>());
    }

    public WebhookEmbedBuilder(@NotNull Section section, Map<String, String> replacements) {
        this.replacements = replacements;
        this.embed = new club.minnced.discord.webhook.send.WebhookEmbedBuilder();
        section.getOptionalString("color").ifPresent(this::setColor);
        section.getOptionalString("description").ifPresent(this::setDescription);
        section.getOptionalString("image-url").ifPresent(this::setImageUrl);
        section.getOptionalString("thumbnail-url").ifPresent(this::setThumbnailUrl);
        section.getOptionalString("title.text").ifPresent(val -> this.setTitle((String)val, section.getString("title.icon")));
        section.getOptionalString("author.name").ifPresent(val -> this.setAuthor((String)val, section.getString("author.icon-url"), section.getString("author.url")));
        section.getOptionalString("footer.text").ifPresent(val -> this.setFooter((String)val, section.getString("footer.icon")));
        section.getOptionalSection("fields").ifPresent(val -> {
            for (String route : val.getRoutesAsStrings(false)) {
                section.getOptionalString("fields." + route + ".name").ifPresent(val2 -> this.addField(section.getBoolean("fields." + route + ".inline", (Boolean)false), (String)val2, section.getString("fields." + route + ".value", "")));
            }
        });
    }

    public WebhookEmbed get() {
        return this.embed.build();
    }

    public WebhookEmbedBuilder setColor(String color) {
        this.embed.setColor(Integer.valueOf(Integer.parseInt(color.replace("#", ""), 16)));
        return this;
    }

    public WebhookEmbedBuilder setDescription(String description) {
        this.embed.setDescription(this.replacePlaceholders(description));
        return this;
    }

    public WebhookEmbedBuilder setImageUrl(String imageUrl) {
        this.embed.setImageUrl(imageUrl);
        return this;
    }

    public WebhookEmbedBuilder setThumbnailUrl(String thumbnailUrl) {
        this.embed.setThumbnailUrl(thumbnailUrl);
        return this;
    }

    public WebhookEmbedBuilder setTitle(@NotNull String text, @Nullable String icon) {
        this.embed.setTitle(new WebhookEmbed.EmbedTitle(this.replacePlaceholders(text), icon));
        return this;
    }

    public WebhookEmbedBuilder setAuthor(@NotNull String name, @Nullable String iconUrl, @Nullable String url) {
        this.embed.setAuthor(new WebhookEmbed.EmbedAuthor(this.replacePlaceholders(name), iconUrl, url));
        return this;
    }

    public WebhookEmbedBuilder setFooter(@NotNull String text, @Nullable String icon) {
        this.embed.setFooter(new WebhookEmbed.EmbedFooter(this.replacePlaceholders(text), icon));
        return this;
    }

    public WebhookEmbedBuilder addField(boolean inline, @NotNull String name, @NotNull String value) {
        this.embed.addField(new WebhookEmbed.EmbedField(inline, this.replacePlaceholders(name), this.replacePlaceholders(value)));
        return this;
    }

    public WebhookEmbedBuilder setTimeSpan(@Nullable TemporalAccessor timestamp) {
        this.embed.setTimestamp(timestamp);
        return this;
    }

    private String replacePlaceholders(@NotNull String string) {
        AtomicReference<String> message = new AtomicReference<String>(string);
        this.replacements.forEach((key, value) -> message.set(((String)message.get()).replace((CharSequence)key, (CharSequence)value)));
        return message.get();
    }
}

