/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.utils;

import com.artillexstudios.axinventoryrestore.libs.axapi.libs.boostedyaml.block.implementation.Section;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDAEmbedBuilder {
    private final EmbedBuilder embed = new EmbedBuilder();
    private final Map<String, String> replacements;

    public JDAEmbedBuilder(Section section, Map<String, String> replacements) {
        this.replacements = replacements;
        section.getOptionalString("color").ifPresent(this::setColor);
        section.getOptionalString("description").ifPresent(this::setDescription);
        section.getOptionalString("image-url").ifPresent(this::setImageUrl);
        section.getOptionalString("thumbnail-url").ifPresent(this::setThumbnailUrl);
        section.getOptionalString("title.text").ifPresent(val -> this.setTitle((String)val, section.getString("title.icon")));
        section.getOptionalString("author.name").ifPresent(val -> this.setAuthor((String)val, section.getString("author.icon-url"), section.getString("author.url")));
        section.getOptionalString("footer.text").ifPresent(val -> this.setFooter((String)val, section.getString("footer.icon")));
        section.getOptionalSection("fields").ifPresent(val -> {
            for (String route : val.getRoutesAsStrings(false)) {
                section.getOptionalString("fields." + route + ".name").ifPresent(val2 -> this.addField(section.getBoolean("fields." + route + ".inline", (Boolean)false), (String)val2, section.getString("fields." + route + ".value", "")));
            }
        });
    }

    public MessageEmbed get() {
        return this.embed.build();
    }

    public JDAEmbedBuilder setColor(String color) {
        this.embed.setColor(Integer.parseInt(color.replace("#", ""), 16));
        return this;
    }

    public JDAEmbedBuilder setDescription(String description) {
        this.embed.setDescription((CharSequence)this.replacePlaceholders(description));
        return this;
    }

    public JDAEmbedBuilder setImageUrl(String imageUrl) {
        this.embed.setImage(imageUrl);
        return this;
    }

    public JDAEmbedBuilder setThumbnailUrl(String thumbnailUrl) {
        this.embed.setThumbnail(thumbnailUrl);
        return this;
    }

    public JDAEmbedBuilder setTitle(@NotNull String text, @Nullable String icon) {
        this.embed.setTitle(this.replacePlaceholders(text), icon);
        return this;
    }

    public JDAEmbedBuilder setAuthor(@NotNull String name, @Nullable String iconUrl, @Nullable String url) {
        this.embed.setAuthor(this.replacePlaceholders(name), url, iconUrl);
        return this;
    }

    public JDAEmbedBuilder setFooter(@NotNull String text, @Nullable String icon) {
        this.embed.setFooter(this.replacePlaceholders(text), icon);
        return this;
    }

    public JDAEmbedBuilder addField(boolean inline, @NotNull String name, @NotNull String value) {
        this.embed.addField(this.replacePlaceholders(name), this.replacePlaceholders(value), inline);
        return this;
    }

    public JDAEmbedBuilder setTimestamp(@Nullable TemporalAccessor timestamp) {
        this.embed.setTimestamp(timestamp);
        return this;
    }

    private String replacePlaceholders(@NotNull String str) {
        AtomicReference<String> toFormat = new AtomicReference<String>(str);
        this.replacements.forEach((pattern, replacement) -> toFormat.set(((String)toFormat.get()).replace((CharSequence)pattern, (CharSequence)replacement)));
        return toFormat.get();
    }
}

