/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axinventoryrestore.libs.axapi.nms.v1_20_R4;

import com.artillexstudios.axinventoryrestore.libs.axapi.utils.logging.LogUtils;
import com.google.common.base.Preconditions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;

public enum ItemStackSerializer {
    INSTANCE;


    public byte[] serializeAsBytes(ItemStack itemStack) {
        byte[] byArray;
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Can't serialise a null itemstack!");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Can't serialise air!");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            NBTTagCompound compoundTag = (NBTTagCompound)CraftItemStack.asNMSCopy((ItemStack)itemStack).a((HolderLookup.a)MinecraftServer.getServer().bc());
            compoundTag.a("DataVersion", SharedConstants.b().d().c());
            NBTCompressedStreamTools.a((NBTTagCompound)compoundTag, (OutputStream)outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        outputStream.close();
        return byArray;
    }

    public ItemStack deserializeFromBytes(byte[] bytes) {
        CraftItemStack craftItemStack;
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            NBTTagCompound compound = NBTCompressedStreamTools.a((InputStream)stream, (NBTReadLimiter)NBTReadLimiter.a());
            int dataVersion = compound.h("DataVersion");
            NBTTagCompound converted = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.t, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)compound), dataVersion, SharedConstants.b().d().c()).getValue();
            craftItemStack = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.a((HolderLookup.a)MinecraftServer.getServer().bc(), (NBTBase)converted).orElseThrow()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        stream.close();
        return craftItemStack;
    }

    public String serializeAsSnbt(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"Can't serialise a null itemstack!");
        Preconditions.checkArgument((itemStack.getType() != Material.AIR ? 1 : 0) != 0, (Object)"Can't serialise air!");
        NBTTagCompound tag = (NBTTagCompound)CraftItemStack.asNMSCopy((ItemStack)itemStack).a((HolderLookup.a)MinecraftServer.getServer().bc());
        tag.a("DataVersion", SharedConstants.b().d().c());
        return new SnbtPrinterTagVisitor().a((NBTBase)tag);
    }

    public ItemStack deserializeFromSnbt(String snbt) {
        try {
            NBTTagCompound parsed = MojangsonParser.a((String)snbt);
            int dataVersion = parsed.h("DataVersion");
            NBTTagCompound converted = (NBTTagCompound)MinecraftServer.getServer().L.update(DataConverterTypes.t, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)parsed), dataVersion, SharedConstants.b().d().c()).getValue();
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)((net.minecraft.world.item.ItemStack)net.minecraft.world.item.ItemStack.a((HolderLookup.a)MinecraftServer.getServer().bc(), (NBTBase)converted).orElseThrow()));
        }
        catch (CommandSyntaxException exception) {
            LogUtils.error("Failed to parse SNBT into an ItemStack! Please, check out the exception for more details!", new Object[]{exception});
            throw new RuntimeException(exception);
        }
    }
}

